# CVE-2023-24055
POC and Scanner for CVE-2023-24055

Use at your own risk!

## config_scanner.py

A simple Parser for the KeePass config file running unter Windows. 
The tool will open the directory %APPDATA%\Roaming\KeePass\KeePass.config.xml 
and will output all triggers. The triggers
- Execute command line / URL
- Synchronize active database with a file/URL
- Export active database

are marked as dangerous. This is my personal opinion, I am sure you can perform 
malicious stuff with some other actions, too! 

**Hint: If you do not recognize some of the triggers, check them carefully!**


## poc.py

Proof of Concept code for CVE-2023-24055

The tool will open the directory %APPDATA%\Roaming\KeePass\KeePass.config.xml and will 
add a trigger to the KeePass config so that the current database gets exportet to
c:\\Users\\%USERNAME%\\KeepassExport.csv 
when it is opened.

The parameter ExportNoKey is set to TRUE so that KeePass will not ask for the master password during export.

# Todo:

* Add feature to config_scanner to read arbitrary config files provides by the commandline

# Action IDs
~~~
2uX4OwcwTBOe7y66y27kxw==: Execute command line / URL
tkamn96US7mbrjykfswQ6g==: Change trigger on/off state
/UFV1XmPRPqrifL4cO+UuA==: Open database file
9VdhS/hMQV2pE3o5zRDwvQ==: Save active database
Iq135Bd4Tu2ZtFcdArOtTQ==: Synchronize active database with a file/URL
gOZ/TnLxQEWRdh8sI9jsvg==: Import into active database
D5prW87VRr65NO2xP5RIIg==: Export active database
W79FnVS/Sb2X+yzuX5kKZw==: Close active database
P7gzLdYWToeZBWTbFkzWJg==: Activate database (select tab)
Oz0+MeSzQqa6zNXAO6ypaQ==: Wait
CfePcyTsT+yItiXVMPQ0bg==: Show message box
QGmlNlcbR5Kps3NlMODPww==: Perform global auto-type
MXCPrWSTQ/WU7sgaI24yTQ==: Perform auto-type with selected entry
Qug3gXPTTuyBSJ47NqyDhA==: Show entries by tag
lYGPRZlmSYirPoboGpZoNg==: Add custom toolbar button
1m1BomyyRLqkSApB+glIeQ==: Remove custom toolbar button
~~~

# Further readings
* Trigger Examples: https://keepass.info/help/kb/trigger_examples.html
* Discussion on Sourceforge: https://sourceforge.net/p/keepass/discussion/329220/thread/a146e5cf6b/ 
* KeeThief: https://blog.harmj0y.net/redteaming/keethief-a-case-study-in-attacking-keepass-part-2/
* IDs: https://github.com/EmpireProject/Empire/blob/master/data/module_source/collection/vaults/KeePassConfig.ps1

# Disclaimer

This software is for educational purposes only! Do not use it to harm anyone! By using my application you automatically agree to all laws that apply to you and take responsibility for your actions! Violation of laws can have serious consequences! As the developer, I do not accept any liability and am not responsible for any misuse or damage caused by this program.

