# Apache Airflow SQL injection PoC (CVE-2023-22884)

**PoC for CVE-2023-22884 is an Apache Airflow RCE vulnerability affecting versions prior to 2.4.0.**

[<img src="https://github.com/jakabakos/CVE-2023-22884-Airflow-SQLi/blob/main/proofs/airflow-2-proof.png?raw=true" width="100%">](https://youtu.be/CywFs1kzui8 " CVE-2023-22884 PoC - Apache Airflow SQLi ")

The official report description says:

> Improper Neutralization of Special Elements used in a Command ('Command Injection') vulnerability in Apache Software Foundation Apache Airflow, Apache Software Foundation Apache Airflow MySQL Provider. This issue affects Apache Airflow: before 2.5.1; Apache Airflow MySQL Provider: before 4.0.0. [(source)](https://nvd.nist.gov/vuln/detail/CVE-2023-22884)

> Affected versions of this package are vulnerable to Command Injection due to lack of sanitization of input to the LOAD DATA LOCAL INFILE statement, which can be used by an attacker to execute commands on the operating system. [(source)](https://security.snyk.io/vuln/SNYK-PYTHON-APACHEAIRFLOW-3257971)

The repo is created for a CVE analysis blog post available on <a href="https://www.vicarius.io/vsociety/posts/2811" target="_blank">vsociety blog</a>.

## Usage
You can clone the repo:
```bash
git clone https://github.com/jakabakos/CVE-2023-22884-Airflow-SQLi.git
```

### Setting up the PoC
```bash
cd CVE-2023-22884-Airflow-SQLi/airflow-2.5.0
```

Run it with `docker-compose run --build`.

As a result, you should see in the logs that the webserver and other components are up and there is a login form under `localhost:8080`. The default username and password is `airflow`.

See the example DAG in folder dags.

### Exploitation
You can run the exploit in test and attack mode.

```bash
cd exploit

# Run exploit in test mode:
python3 exploit.py -u admin -p admin --host http://localhost:8080 --mode test -ci mysql -di bulk_load_from_file 

# Run exploit in attack mode:
python3 exploit.py -u admin -p admin --host http://localhost:8080 --mode attack -ci mysql -di bulk_load_from_file -dc dag_config.json
```
## Disclaimer
This software has been created purely for the purposes of academic research and for the development of effective defensive techniques, and is not intended to be used to attack systems except where explicitly authorized. Project maintainers are not responsible or liable for misuse of the software. Use responsibly.
