# CVE-2023-22432

## PoC verification of web2py vulnerability (CVE-2023-22432)
A vulnerability ([CVE-2023-22432](https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2023-22432)) in [web2py](http://web2py.com) was disclosed on Jan 31, 2023 (US time). This article describes our discussion of this vulnerability and the results of our verification.

## Vulnerability Summary
This vulnerability is an open redirect vulnerability in web2py that allows an arbitrary URL to be specified as the callback destination URL in the admin page URL. Countermeasures against open redirects were originally implemented, but this vulnerability is reproduced by applying a special bypass method to the URL. This can lead you to malicious sites.

## Affected Versions
- web2py prior to 2.23.1

## Countermeasures
- Update to web2py 2.23.1 or higher.

## Vulnerability History
An open redirect vulnerability (CVE-2022-33146) was discovered in web2py in 2022, and we wondered if there were other vulnerabilities like CVE-2022-33146, so we checked the source code of web2py, and we found the way to bypass open redirect prevention. [Takuto Yoshikai](https://twitter.com/TakutoYoshikai) (the author) of Aeye Security Lab reported this to the IPA and web2py development team.

## Verification environment
- M1 Mac
- Python3.8
- web2py 2.22.5

## Verification

Run build.sh in this repository. Then web2py will start.
```bash
bash build.sh
```
Access to `http://localhost:8000/admin/default/index/?send=//example.com`

<img src="image4.png" width="400">

Enter password "password123", and click Login.

<img src="image3.png" width="400">

It didn't redirect to example.com, so open redirect prevention worked well.

Access to `http://localhost:8000/admin/default/index/?send=\/\/example.com`

The payload is `\/\/example.com`.

<img src="image1.png" width="400">

Enter password "password123", and click Login.

<img src="image2.png" width="400">

It redirected to example.com, so open redirect prevention didn't work correctly.

## Summary
After review and verification, we have confirmed that it is possible to direct the administrator to a malicious web site by crafting the admin page URL. We recommend updating the system as soon as possible.

## Reference Information
- https://www.cve.org/CVERecord?id=CVE-2023-22432
- https://nvd.nist.gov/vuln/detail/CVE-2023-22432
- https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2023-22432
- https://jvndb.jvn.jp/en/contents/2023/JVNDB-2023-000020.html
- http://web2py.com
