#include "utils.h"

const uint16_t svcmgr_id[] = {
    'a','n','d','r','o','i','d','.',
    'o','s','.', 'I','S','e','r','v',
    'i','c','e', 'M','a','n','a','g',
    'e','r'}; 

void print_binder_string16(const uint16_t *str16, size_t len) {
    if (str16 == NULL) {
        printf("(null)\n");
        return;
    }

    for (size_t i = 0; i < len; i++) {
        uint16_t c = str16[i];
        // 仅处理ASCII字符（0-127）
        if (c <= 0x7F) {
            putchar((char)c);
        } else {
            putchar('?');  // 非ASCII字符替换为问号
        }
    }
    putchar('\n');
}

uint32_t binder_parse_log(
    BYTE* rbuffer, 
    size_t rsize
){
    uint32_t result = 0;
    size_t end_addr = (size_t)rbuffer + rsize;
    for (size_t ptr = (size_t)rbuffer; ptr < end_addr; ){
        uint32_t cmd = *((uint32_t*)ptr);
        ptr += sizeof(uint32_t);
        switch (cmd) {
        case BR_NOOP:
            puts("BR_NOOP");
            result = cmd;
            break;
        case BR_TRANSACTION_COMPLETE:
            puts("BR_TRANSACTION_COMPLETE");
            result = cmd;
            break;
        case BR_INCREFS:
            puts("BR_INCREFS");
            ptr += sizeof(struct binder_ptr_cookie);
            result = cmd;
            break;
        case BR_ACQUIRE:
            puts("BR_ACQUIRE");
            ptr += sizeof(struct binder_ptr_cookie);
            result = cmd;
            break;
        case BR_RELEASE:
            puts("BR_RELEASE");
            ptr += sizeof(struct binder_ptr_cookie);
            result = cmd;
            break;
        case BR_DECREFS:
            puts("BR_DECREFS");
            ptr += sizeof(struct binder_ptr_cookie);
            result = cmd;
            break;
        case BR_TRANSACTION_SEC_CTX:
        case BR_TRANSACTION:{
            puts("BR_TRANSACTION");
            BOOL is_sec_ctx = FALSE;
            struct binder_transaction_data_secctx tds;
            size_t surplus_size = end_addr-ptr;
            binder_uintptr_t secctx = 0;
            memset(&tds, 0, sizeof(tds));
            if(cmd == BR_TRANSACTION){
                CHECK(surplus_size > sizeof(
                    struct binder_transaction_data));
                ptr += sizeof(struct binder_transaction_data);
            }else{
                CHECK(surplus_size > sizeof(
                    struct binder_transaction_data));
                is_sec_ctx = TRUE;
                memcpy(
                    &tds.transaction_data, 
                    (const void*)ptr, sizeof(tds.transaction_data));
                secctx = tds.secctx;
                ptr += sizeof(tds.transaction_data);
            }
            result = cmd;
            break;
        }
        case BR_REPLY:{
            puts("BR_REPLY");
            result = cmd;
            CHECK(
                (end_addr - ptr) >= 
                sizeof(struct binder_transaction_data));
            struct binder_transaction_data* tr = 
                (struct binder_transaction_data*)ptr;
            ptr += sizeof(*tr);
            break;
        }
        case BR_FAILED_REPLY:
            puts("BR_FAILED_REPLY");
            result = cmd;
            break;
        case BR_DEAD_BINDER:
            puts("BR_DEAD_BINDER");
            result = cmd;
            CHECK(
                (end_addr - ptr) >= sizeof(binder_uintptr_t));
            ptr += sizeof(binder_uintptr_t);
            break;
        case BR_DEAD_REPLY:
            puts("BR_DEAD_REPLY");

            result = cmd;
            break;
        case BR_ONEWAY_SPAM_SUSPECT:
            puts("BR_ONEWAY_SPAM_SUSPECT");
            result = cmd;
            break;
        case BR_SPAWN_LOOPER:
            puts("BR_SPAWN_LOOPER");
            result = cmd;
            break;                
        default:
            printf("default: %x\n", cmd);
            result = cmd;
            return cmd;
        }
    }
    return result;
}


pthread_t create_thread(PTHREAD_FUNC func, void* args){
    pthread_t tpid = 0;
    if(pthread_create(&tpid, NULL, func, args) == -1){
        return 0;
    }
    return tpid;
}

void print_hex(BYTE* buffer, size_t len){
    uint32_t* na = (uint32_t*)buffer;
    for(size_t i=0; i<(len/sizeof(uint32_t)); i++){
        printf("%x ", na[i]);
    }
    puts("\n");
}

void delay_ms(unsigned int milliseconds) {
    usleep(milliseconds * 1000); // 1ms = 1000μs
}

void heap_spray(size_t num, size_t count, const void* src){

}