#ifndef HWBINDER_H_
#define hwbinder_h_

#include "base.h"
#include "binder.h"
#include "uapi_binder.h"
#include "utils.h"

#define HWBINDER_DEVICE "/dev/hwbinder"
#define HWSERVICE_MANAGER "android.hidl.manager@1.0::IServiceManager"
#define TOKEN_MANAGER   "android.hidl.token@1.0::ITokenManager"

#define MOV_PTR(p, o)   p += (o)
#define ALIGN_32(p)   \
while (((uint64_t)p) % sizeof(uint32_t)){ p++; }
#define ALIGN_64(p)   \
while(((unsigned long long)p) % sizeof(8)){ p++; }

typedef void * hidl_pointer;

typedef struct _hidl_string{
    hidl_pointer buffer_;
    uint32_t size_;
    BOOL owns_buffer_;
}hidl_string, phidl_string;

typedef struct hidl_vec {
   hidl_pointer buffer;
   uint32_t size;
   BOOL owns_buffer;
} hidl_vec;

typedef struct service_list {
   struct service_list *next;
   const char *service_name;
   hidl_vec *token;
} service_list_t;


uint32_t find_hwservice(
    PBINDER_INFO info, 
    hidl_string* name,
    hidl_string* instance
);

uint32_t get_handle_by_token(
    PBINDER_INFO info,
    uint32_t tm,
    hidl_vec* tk
);

BOOL create_token(
    PBINDER_INFO info, 
    uint32_t tm, 
    uint32_t svc,
    hidl_vec* tk
);

BOOL unregister_token(
    PBINDER_INFO info,
    uint32_t tm,
    const hidl_vec* token
);

uint32_t get_token_manager(PBINDER_INFO info);


/* Create wrapper for hidl_strings. */
hidl_string *hidl_string_new(const char *str);
hidl_vec hidl_vec_new(BYTE* token, size_t size);
int hwbinder_open(PBINDER_INFO info, size_t mapsize);

#endif