﻿# CVE-2022-49186: Linux Kernel Privilege Escalation Research

## Overview

Security research and proof-of-concept exploit for CVE-2022-49186, a Linux kernel vulnerability in the Visconti clock driver that enables local privilege escalation through array overflow.


## Vulnerability Details

- **Type**: Array overflow due to signed-to-unsigned conversion

- **CVSS Score**: 7.8 (High)

- **Impact**: Local privilege escalation to root

- **Affected**: Linux kernel 5.17.0 - 5.17.1


## Repository Contents

- `CVE-2022-49186.pdf` - Complete research paper

- `exploit/exploit.c` - Privilege escalation exploit code

- `vulnerable-module/visconti\_clk.c` - Vulnerable kernel module

- `vulnerable-module/Makefile` - Module build configuration


## Quick Build

```bash

# Build vulnerable module

cd vulnerable-module \&\& make

# Build exploit

cd ../exploit \&\& gcc -o exploit exploit.c -static
