# CVE-2022-48565 PoC

## Introduction

This is a Proof of Concept (PoC) demonstrating the vulnerability **CVE-2022-48565**, which is based on **unsafe deserialization of Plist files** in Python. By processing specially crafted Property List (Plist) files, an attacker can execute arbitrary code on the target system, potentially leading to **Remote Code Execution (RCE)**.

In this repository, you will find four PoC scripts, each showing different ways to exploit this vulnerability. These examples demonstrate how malicious code can be embedded in Plist files and executed on a system.

Here is a video demonstrating the Proof of Concept:

[![Video Thumbnail](https://img.youtube.com/vi/2wcJDGlKueg/0.jpg)](https://youtu.be/2wcJDGlKueg)

## Disclaimer

These PoC scripts are for educational purposes and security research only. Use these scripts in a controlled environment and never on production systems. Misuse of this vulnerability could result in serious legal and ethical consequences.

## Requirements

- Python <=3.9.1
- Python 2.x

- macOS: Some examples (e.g., opening the Calculator or Safari) only work on macOS, as they use macOS-specific commands

## Installation

Clone this repository:

```git clone https://github.com/Einstein2150/CVE-2022-48565-POC```

Change into the directory:

```cd CVE-2022-48565-POC```

   	
## PoC Scripts

There are four PoC scripts, each showing different ways to exploit this vulnerability.


### 1. cve-2022-48565_poc_echo.py

This script shows a simple example where unsafe deserialization is used to execute a shell command that prints a message to the console.

**Usage:**
```
bash
python2 cve-2022-48565_poc_echo.py
```

### 2. cve-2022-48565_poc_calc.py

In this example, it is demonstrated how an attacker can open the macOS Calculator by deserializing a malicious Plist file.

**Usage:**
```
bash
python2 cve-2022-48565_poc_calc.py
```


### 3. cve-2022-48565_poc_wget.py

This script shows how an attacker can download a file from an external source and automatically open it in Safari. The wget command is used to download index.html from the website foto-video-it.de, which is then opened in Safari.v

**Usage:**
```
bash
python2 cve-2022-48565_poc_wget.py
```

### 4. cve-2022-48565_poc_external_plist.py

This script simulates a practical attack scenario where the malicious Plist file is stored externally and loaded at runtime. This demonstrates how an attacker can load a Plist file from an external source and use it to execute malicious code.

The malicious.plist file contains the payload and must be placed in the same directory as the script.

**Usage:**
```
bash
python2 cve-2022-48565_poc_external_plist.py
```


## License

This project is licensed under the MIT License. See the LICENSE file for more details.
