# CVE-2022-47966
POC for CVE-2022-47966 affecting the following ManageEngine products:
* Access Manager Plus
* Active Directory 360
* ADAudit Plus
* ADManager Plus
* ADSelfService Plus
* Analytics Plus
* Application Control Plus
* Asset Explorer
* Browser Security Plus
* Device Control Plus
* Endpoint Central
* Endpoint Central MSP
* Endpoint DLP
* Key Manager Plus
* OS Deployer
* PAM 360
* Password Manager Pro
* Patch Manager Plus
* Remote Access Plus
* Remote Monitoring and Management (RMM)
* ServiceDesk Plus
* ServiceDesk Plus MSP
* SupportCenter Plus
* Vulnerability Manager Plus

This specific POC only works on products utilizing Apache Santuario (xmlsec) <= 1.4.1 such as:
* ServiceDesk Plus
* Endpoint Central
* ADManager Plus
* ADSelfService Plus

Other products may perform additional checks on the SAML response. Modifying this POC to work on products that perform additional checks involves:
* Scanning the logs of the vulnerable product for stack traces or additional logs message indicating an invalid SAML response.
* Reverse engineering the vulnerable product and searching for the code that implements the checks.

## Technical Analysis
A technical root cause analysis of the vulnerability can be found on our blog:
https://www.horizon3.ai/manageengine-cve-2022-47966-technical-deep-dive

## Original Researcher's Writeup
[Khoadha of Viettel Security](https://twitter.com/_l0gg) documents his original research of this vulnerability and how it can be exploited across many versions of xmlsec:
https://blog.viettelcybersecurity.com/saml-show-stopper/

## Indicators of Compromise
For analyzing ManageEngine logs for indicators of compromise check out our IOC blog:
https://www.horizon3.ai/manageengine-cve-2022-47966-iocs/

## Summary
This POC abuses the pre-authentication remote code execution vulnerability to run a command with Java's Runtime.exec method.

## Usage
For Active Directory related products, such as ADManager, an issuer argument is required:
```plaintext
root@kali:~# python3 ./CVE-2022-47966.py --url https://10.0.40.90:8443/samlLogin/<guid> --issuer https://sts.windows.net/<guid>/ --command notepad.exe
```

For other products, a URL is all that is required:
```plaintext
root@kali:~# python3 ./CVE-2022-47966.py --url https://10.0.40.64:8080/SamlResponseServlet --command notepad.exe
```

## Mitigations
Update to the latest version of the affected product.

## Follow the Horizon3.ai Attack Team on Twitter for the latest security research:
*  [Horizon3 Attack Team](https://twitter.com/Horizon3Attack)
*  [James Horseman](https://twitter.com/JamesHorseman2)
*  [Zach Hanley](https://twitter.com/hacks_zach)

## Disclaimer
This software has been created purely for the purposes of academic research and for the development of effective defensive techniques, and is not intended to be used to attack systems except where explicitly authorized. Project maintainers are not responsible or liable for misuse of the software. Use responsibly.
