# details-for-CVE-2022-46505
MatrixSSL session resume bug
## 1. Description of bug

An issue in MatrixSSL 4.5.1-open and earlier leads to failure to securely check the SessionID field, resulting in the misuse of an **all-zero MasterSecret** that can decrypt secret data.

## 2. Affected version

MatrixSSL 4.5.1-open and earlier

## 3. Vulnerability Type

tls resume session decryption

## 4. Bug details

The matrixssl server stores negotiated session information through a list. 

```c
static sslSessionEntry_t g_sessionTable[SSL_SESSION_TABLE_SIZE]; 
// SSL_SESSION_TABLE_SIZE is 32
```

```c
typedef struct
{
    unsigned char id[SSL_MAX_SESSION_ID_SIZE]; // 32
    unsigned char masterSecret[SSL_HS_MASTER_SIZE]; // 48
    const sslCipherSpec_t *cipher;
    unsigned char majVer;
    unsigned char minVer;
    short extendedMasterSecret;           /* was the extension used? */
    psTime_t startTime;
    int32 inUse;
    DLListEntry chronList;
} sslSessionEntry_t;
```

The first four bytes of the SessionID field are a **little-endian sequence** number ranging **from 0 to 31.** 

![Untitled](Untitled.png)

Matrixssl determines whether the session is a resume session by matching the length of the session ID received with the four-byte quick index. 

However, when the storage list is initialized, MasterSecret is all zeros. 

Therefore, the malicious Client can send a **one-byte SessionID** for all-zero MasterSecret session resumption. When the server receives a single byte sessionid, the following bytes default to 0. Therefore, it can be validated and indexed to the list, and the MasterSecret corresponding to that sequence number in the list may still be 0. If this happens, we can **calculate the key and decrypt the TLS communication data.**

`./matrixssl/matrixssl.c  —>  int32 matrixResumeSession(ssl_t *ssl)`

![Untitled](Untitled%201.png)

![Untitled](Untitled%202.png)

**Adding console output for debug :** 

![Untitled](Untitled%203.png)

**Testing result :**

![Untitled](Untitled%204.png)

![Untitled](Untitled%205.png)

**Use all-zero MasterSecret to decrypt !**

![Untitled](Untitled%206.png)
