# CVE-2022-45782 – dotCMS Password Reset Token Predictability (PoC)

This repository contains a proof-of-concept exploit for CVE-2022-45782, a vulnerability in dotCMS where password-reset tokens are generated using the non-cryptographic method RandomStringUtils.randomAlphanumeric().
Because this token is predictable, an attacker can brute-force or derive it and reset the password of an administrator account.

This PoC demonstrates the full exploit chain:
- running a vulnerable dotCMS instance
- triggering password reset
- receiving the attacker’s reset token
- cracking the administrator’s token using the randomstringutils repo
- resetting the administrator’s account


## Repository Structure

This repo uses a Git submodule containing the cracker for the vulnerable token-generation function.
It is the C implementation of the cracker used to derive/guess password-reset tokens generated by RandomStringUtils.randomAlphanumeric().

Clone with submodule:
```
git clone https://github.com/alex91ar/randomstringutils.git
```


## Running the Vulnerable dotCMS Instance

1. Configure SMTP (Gmail Example)

dotCMS must send reset emails for the PoC to work.

Edit docker-compose.yml:
```
DOT_MAIL_SMTP_USER: "<smtp_email>"
DOT_MAIL_SMTP_PASSWORD: "<smtp_pass>"
```

(If using Gmail: enable App Password and use the generated 16-character app password.)

2. Start dotCMS
```
docker compose up
```
If it fails (common on first startup), simply run again.

Login page:
https://localhost:8443/dotAdmin/#/public/login


3. Create Accounts

Inside dotCMS:
- Create an administrator account
- Create a separate attacker account

These two accounts will be used by the PoC.


## Compiling the Token Cracker (randomstringutils)

randomstringutils is the brute-forcer/cracker for dotCMS’s insecure token.

Compile it using:
```
cd randomstringutils
gcc -lpthread -O3 -o randomutils randomutils.c
```
This produces the fast token-cracker binary.


## Running the Exploit (PoC)
1. Set the attacker and administrator usernames (in README or poc.py, depending on your setup)
2. Run the proof-of-concept:
```
python3 poc.py
```
3. The attacker receives their own password-reset email
4. Paste the attacker reset token into the terminal when prompted
5. The PoC uses the randomutils cracker to compute the matching admin reset token and brute forces the timestamp

If successful, the script uses the cracked admin token to reset the admin account.

## Disclaimer

This repository is for educational, academic, and authorized security testing only.
Do NOT use this exploit against systems you do not own or have explicit permission to test.
