# CVE-2022-4556 - Stored XSS in SOGo Webmail (v5.7.1)

## 🧠 Summary

A **Stored Cross-Site Scripting (XSS)** vulnerability was discovered in the **`fullName`** field of the **Identity Preferences** section in the **SOGo web interface**, affecting version **5.7.1**. An authenticated attacker could inject a malicious script that would execute whenever any user (including the attacker) accessed the Mail tab.

## 🆔 CVE Details

- **CVE ID**: [CVE-2022-4556](https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2022-4556)
- **CVSS v3.1**: 6.1 (Medium)
- **Vector**: AV:N/AC:L/PR:N/UI:R/S:C/C:L/I:L/A:N
- **Vulnerability Type**: Stored XSS (OWASP WSTG-INPV-02)
- **Attack Type**: Remote (authenticated)
- **Discoverers**: [Ashkan Rafiee](https://www.linkedin.com/in/AshkanRafiee), [Mostafa Abbasi](https://www.linkedin.com/in/mostafa-abbasii/)
- **Vendor**: [Alinto (SOGo)](https://sogo.nu)
- **Affected Product**: SOGo Webmail
- **Affected Version**: Confirmed in v5.7.1
- **Fixed Version**: v5.8.0

---

## 💥 Proof of Concept (PoC)

### ✅ Steps to Reproduce

1. **Log in** as an authenticated user to your running instance of SOGo (v5.7.1).
2. Navigate to:
   ```
   Preferences → Mail → IMAP Accounts → Edit Identity
   ```
3. In the **Full Name** field, input the following XSS payload:
   ```html
   </script><svg onload=alert(1)>
   ```
4. Click **OK**, then **Save** the preferences.
5. Navigate to the **Mail** tab.
6. The JavaScript payload will execute in the browser, confirming stored XSS.


---

## 🔎 Root Cause

The application fails to properly sanitize user input in the `fullName` field before reflecting it into HTML content, allowing stored JavaScript payloads to persist across sessions and users.

---

## 🔧 Remediation

Sanitize all user-controlled input before rendering it into the DOM. In this case, ensure the `fullName` field is properly escaped or filtered on both input and output.

🛠 Refer to the [OWASP Cheat Sheet](https://cheatsheetseries.owasp.org/cheatsheets/Cross_Site_Scripting_Prevention_Cheat_Sheet.html):  

---

## 📅 Timeline

- **2022-11-21**: Initial report submitted (bug #5642)
- **2022-11-22**: Vendor acknowledged and committed a fix
- **2022-11-30**: Patch released in [SOGo v5.8.0](https://github.com/Alinto/sogo/releases/tag/SOGo-5.8.0)
- **2025**: CVE published by MITRE and assigned CVE-2022-4556

---

## 🔗 References

- [Bug Report #5642](https://bugs.sogo.nu/view.php?id=5642) *(authentication required)*
- [Vendor Patch (v5.8.0)](https://github.com/Alinto/sogo/releases/tag/SOGo-5.8.0)
- [Patch Commits](https://github.com/Alinto/sogo/commit/efac49ae91a4a325df9931e78e543f707a0f8e5e) and others
- [OWASP XSS Testing Guide](https://owasp.org/www-project-web-security-testing-guide/latest/4-Web_Application_Security_Testing/07-Input_Validation_Testing/02-Testing_for_Stored_Cross_Site_Scripting)

---

## 👤 Authors

**Ashkan Rafiee**
[LinkedIn](https://www.linkedin.com/in/AshkanRafiee)
[GitHub](https://github.com/AshkanRafiee) 

**Mostafa Abbasi**
[LinkedIn](https://www.linkedin.com/in/mostafa-abbasii/)
[GitHub](https://github.com/mostafa-absi) 

---

## 🪪 License

This writeup and documentation are licensed under the [Creative Commons Attribution 4.0 International License (CC BY 4.0)](https://creativecommons.org/licenses/by/4.0/).
