# CVE-2022-44721 Crowdstrike Falcon Uninstaller
CrowdStrike Falcon is a cloud-powered endpoint detection and response (EDR) and antivirus (AV) solution. On each end-device a kernel level managed sensor is deployed and makes use of the cloud-based capabilities. The sensor can be configured with an uninstall protection. It prevents the uninstallation of CrowdStrike Falcon sensor on the end-device without a one-time generated token. 

Exploiting this vulnerability allows an attacker with administrative privileges to bypass the token check on Windows end-devices and to uninstall the sensor from the device without proper authorization, effectively removing the device's EDR and AV protection. 

Vulnerable sensor version: 6.44.15806 

 

## Timeline 
- 22/08/2022: After the release of CVE-2022-2841 affecting version 6.31.14505 and 6.42.15210 the Deda Cloud Cybersecurity team started ritual operation to check whether patched releases were still affected 
- 25/08/2022: CVE-2022-2841 PoC can still be used for Race Condition but does not work on version 6.44.15806. With a small change of the PoC to speed up the race condition, we were able to uninstall the fixed sensor without the security token 
- 25/08/2022: We also implemeted an easier Powershell version of the exploit 
- 25/08/2022: We sent first Powershell PoC (Falcon-6.44.15806-uninstall.ps1) to Crowdstrike support team 
- 11/11/2022: We sent exploit source code (Falcon-6.44.15806-uninstall.cpp) and proofs (PoC video) to Crowdstrike support team 
- 29/11/2022: Crowdstrike support team acknowledged the vulnerability of already hotfixed 6.44.15806 sensor and approved the release of the new CVE 

Snip of Crowdstrike support team acknowledge e-mail 
```
...
As the referenced CVE was not released in coordination with CrowdStrike, it may be missing some details, however our customers 
have been kept up to date on our remediation efforts and the affected sensor versions, including a release of the hotfix for v6.44.15806. 
Please see the relevant tech alerts explaining the nature of this issue and the fix releases at 
https://supportportal.crowdstrike.com/s/article/Tech-Alert-Uninstall-Protection-Bug-in-Falcon-Sensor-for-Windows

Therefore, I believe you can go ahead and publish the CVE adding the impacted Sensor versions 
we were able to test and confirm they are affected.
...
```
As stated in the e-mail, Crowdstrike already patched the vulnerable versions.

## PoC key changes
``` 
# edit #1
Line 111: std::string cmd = "cmd /c start msiexec /x " + guid;

# edit #2
Line 67: if (g_msiexec_instance_count == 3 || g_msiexec_instance_count == 5) {
```

## Execution
- Compile Falcon-6.44.15806-uninstall.cpp with Visual Studio
- Execute as Administrator in a cmd: 
```
.\Falcon-6.44.15806-uninstall.exe "C:\ProgramData\Package Cache\{XXXXXXXX-XXXX-XXXX-XXXX-XXXXXXXXXXXX}v6.44.15806\CsAgent.msi"
```
- Press "Yes" or "Ok" on every request prompted (be fast!)
- Enjoy

## Screenshots
Name of the test machine: MOANA
Policies: EXTRA AGGRESSIVE (all options enabled)
![cve](https://user-images.githubusercontent.com/119488062/204765468-44327598-e166-477f-9fc8-fb1f06d29b99.png)


Uninstall in progress...
![CVE1](https://user-images.githubusercontent.com/119488062/204765554-922ce82c-d428-4023-bbac-4c7602d914e1.png)


Uninstall completed (there are no more file inside the Crowdstrike directory) - Restart required if deamon is still active in memory and running (it will generate detections)
![CVE2](https://user-images.githubusercontent.com/119488062/204765573-140b105d-f515-47dc-98cf-38a7f5164fe7.png)


Moana results unreachable via Cloud
![CVE3](https://user-images.githubusercontent.com/119488062/204765587-6d4c5a6b-f7cb-434f-b690-c21043933391.png)


Dump of lsass.exe
![cve4](https://user-images.githubusercontent.com/119488062/204765620-28f2ea7d-1dce-40e8-bcfa-9b8d06c06240.png)


## Authors
Fortunato [fox] Lodari, Raffaele Nacca, Walter Oberacher, Davide Bianchin, Luca Bernardi @ Deda Cloud Cybersecurity Team 
