/*
 * This file has been automatically generated by charsets_gen.py.
 * Do not edit it by hand.
 *
 * Definitions of aliases for all the charsets supported by the
 * application, obtained by mixing the IANA charset list [1] and
 * the list of iconv-supported charsets.
 *
 * [1] http://www.iana.org/assignments/character-sets
 *
 */

#include "charset.h"

char charset_buffer[] = "\
437\0850\0851\0852\0855\0857\0860\0861\0862\0863\0865\0866\0869\0904\0\
ansi_x3.110-1983\0ansi_x3.4-1968\0ansi_x3.4-1986\0arabic\0arabic7\0ascii\0\
asmo-708\0asmo_449\0big5\0big5-hkscs\0brf\0bs_4730\0ca\0cn\0cp-ar\0cp-gr\0cp-is\0\
cp037\0cp038\0cp1026\0cp154\0cp273\0cp274\0cp275\0cp278\0cp280\0cp281\0cp284\0\
cp285\0cp290\0cp297\0cp367\0cp420\0cp423\0cp424\0cp437\0cp500\0cp775\0cp819\0\
cp850\0cp851\0cp852\0cp855\0cp857\0cp860\0cp861\0cp862\0cp863\0cp864\0cp865\0\
cp866\0cp868\0cp869\0cp870\0cp871\0cp880\0cp891\0cp903\0cp904\0cp905\0cp918\0\
cp936\0csa7-1\0csa7-2\0csa_t500-1983\0csa_z243.4-1985-1\0csa_z243.4-1985-2\0\
csascii\0csbig5\0csbrf\0csdecmcs\0csebcdicatdea\0csebcdiccafr\0csebcdicdkno\0\
csebcdicdknoa\0csebcdices\0csebcdicesa\0csebcdicess\0csebcdicfise\0\
csebcdicfisea\0csebcdicfr\0csebcdicit\0csebcdicpt\0csebcdicuk\0csebcdicus\0\
cseuckr\0cseucpkdfmtjapanese\0csgb2312\0cshproman8\0csibbm904\0csibm037\0\
csibm038\0csibm1026\0csibm273\0csibm274\0csibm275\0csibm277\0csibm278\0\
csibm280\0csibm281\0csibm284\0csibm285\0csibm290\0csibm297\0csibm420\0\
csibm423\0csibm424\0csibm500\0csibm851\0csibm855\0csibm857\0csibm860\0\
csibm861\0csibm863\0csibm864\0csibm865\0csibm866\0csibm868\0csibm869\0\
csibm870\0csibm871\0csibm880\0csibm891\0csibm903\0csibm905\0csibm918\0\
csibmebcdicatde\0csiso10367box\0csiso103t618bit\0csiso10swedish\0\
csiso111ecmacyrillic\0csiso115481\0csiso11swedishfornames\0\
csiso121canadian1\0csiso122canadian2\0csiso139csn369103\0\
csiso141jusib1002\0csiso143iecp271\0csiso14jisc6220ro\0csiso150\0\
csiso150greekccitt\0csiso151cuba\0csiso153gost1976874\0csiso15italian\0\
csiso16portuguese\0csiso17spanish\0csiso18greek7old\0csiso19latingreek\0\
csiso2022jp\0csiso2022jp2\0csiso2022kr\0csiso2033\0csiso21german\0\
csiso25french\0csiso27latingreek1\0csiso49inis\0csiso4unitedkingdom\0\
csiso50inis8\0csiso51iniscyrillic\0csiso5427cyrillic\0csiso5428greek\0\
csiso57gb1988\0csiso60danishnorwegian\0csiso60norwegian1\0\
csiso61norwegian2\0csiso646danish\0csiso69french\0csiso84portuguese2\0\
csiso85spanish2\0csiso86hungarian\0csiso88greek7\0csiso89asmo449\0csiso90\0\
csiso92jisc62991984b\0csiso99naplps\0csisolatin1\0csisolatin2\0\
csisolatin3\0csisolatin4\0csisolatin5\0csisolatin6\0csisolatinarabic\0\
csisolatincyrillic\0csisolatingreek\0csisolatinhebrew\0cskoi8r\0csksc5636\0\
cskz1048\0csmacintosh\0csn_369103\0csnatsdano\0csnatssefi\0cspc775baltic\0\
cspc850multilingual\0cspc862latinhebrew\0cspc8codepage437\0cspcp852\0\
csptcp154\0csshiftjis\0cstscii\0csucs4\0csunicode\0csunicodelatin1\0\
csviscii\0cswindows31j\0cuba\0cyrillic\0cyrillic-asian\0de\0dec\0dec-mcs\0\
din_66003\0dk\0ds2089\0ds_2089\0e13b\0ebcdic-at-de\0ebcdic-at-de-a\0\
ebcdic-be\0ebcdic-br\0ebcdic-ca-fr\0ebcdic-cp-ar1\0ebcdic-cp-ar2\0\
ebcdic-cp-be\0ebcdic-cp-ca\0ebcdic-cp-ch\0ebcdic-cp-dk\0ebcdic-cp-es\0\
ebcdic-cp-fi\0ebcdic-cp-fr\0ebcdic-cp-gb\0ebcdic-cp-gr\0ebcdic-cp-he\0\
ebcdic-cp-is\0ebcdic-cp-it\0ebcdic-cp-nl\0ebcdic-cp-no\0ebcdic-cp-roece\0\
ebcdic-cp-se\0ebcdic-cp-tr\0ebcdic-cp-us\0ebcdic-cp-wt\0ebcdic-cp-yu\0\
ebcdic-cyrillic\0ebcdic-dk-no\0ebcdic-dk-no-a\0ebcdic-es\0ebcdic-es-a\0\
ebcdic-es-s\0ebcdic-fi-se\0ebcdic-fi-se-a\0ebcdic-fr\0ebcdic-int\0\
ebcdic-it\0ebcdic-jp-e\0ebcdic-jp-kana\0ebcdic-pt\0ebcdic-uk\0ebcdic-us\0\
ecma-114\0ecma-118\0ecma-cyrillic\0elot_928\0es\0es2\0euc-jp\0euc-kr\0\
extended_unix_code_packed_format_for_japanese\0fi\0fr\0gb\0gb18030\0gb2312\0\
gb_1988-80\0gbk\0gost_19768-74\0greek\0greek-ccitt\0greek7\0greek7-old\0\
greek8\0hebrew\0hp-roman8\0hu\0ibm-1047\0ibm037\0ibm038\0ibm1026\0ibm1047\0\
ibm273\0ibm274\0ibm275\0ibm277\0ibm278\0ibm280\0ibm281\0ibm284\0ibm285\0ibm290\0\
ibm297\0ibm367\0ibm420\0ibm423\0ibm424\0ibm437\0ibm500\0ibm775\0ibm819\0ibm850\0\
ibm851\0ibm852\0ibm855\0ibm857\0ibm860\0ibm861\0ibm862\0ibm863\0ibm864\0ibm865\0\
ibm866\0ibm868\0ibm869\0ibm870\0ibm871\0ibm880\0ibm891\0ibm903\0ibm904\0ibm905\0\
ibm918\0iec_p27-1\0inis\0inis-8\0inis-cyrillic\0iso-10646\0iso-10646-ucs-2\0\
iso-10646-ucs-4\0iso-10646-unicode-latin1\0iso-11548-1\0iso-2022-cn\0\
iso-2022-cn-ext\0iso-2022-jp\0iso-2022-jp-2\0iso-2022-kr\0iso-8859-1\0\
iso-8859-10\0iso-8859-13\0iso-8859-14\0iso-8859-15\0iso-8859-16\0\
iso-8859-2\0iso-8859-3\0iso-8859-4\0iso-8859-5\0iso-8859-6\0iso-8859-7\0\
iso-8859-8\0iso-8859-9\0iso-celtic\0iso-ir-10\0iso-ir-100\0iso-ir-101\0\
iso-ir-103\0iso-ir-109\0iso-ir-11\0iso-ir-110\0iso-ir-111\0iso-ir-121\0\
iso-ir-122\0iso-ir-126\0iso-ir-127\0iso-ir-138\0iso-ir-139\0iso-ir-14\0\
iso-ir-141\0iso-ir-143\0iso-ir-144\0iso-ir-148\0iso-ir-15\0iso-ir-150\0\
iso-ir-151\0iso-ir-153\0iso-ir-155\0iso-ir-157\0iso-ir-16\0iso-ir-17\0\
iso-ir-18\0iso-ir-19\0iso-ir-199\0iso-ir-21\0iso-ir-226\0iso-ir-25\0\
iso-ir-27\0iso-ir-37\0iso-ir-4\0iso-ir-49\0iso-ir-50\0iso-ir-51\0iso-ir-54\0\
iso-ir-55\0iso-ir-57\0iso-ir-6\0iso-ir-60\0iso-ir-61\0iso-ir-69\0iso-ir-8-1\0\
iso-ir-84\0iso-ir-85\0iso-ir-86\0iso-ir-88\0iso-ir-89\0iso-ir-9-1\0\
iso-ir-90\0iso-ir-92\0iso-ir-98\0iso-ir-99\0iso-latin-1\0\
iso5427cyrillic1981\0iso646-ca\0iso646-ca2\0iso646-cn\0iso646-cu\0\
iso646-de\0iso646-dk\0iso646-es\0iso646-es2\0iso646-fi\0iso646-fr\0\
iso646-fr1\0iso646-gb\0iso646-hu\0iso646-it\0iso646-jp\0iso646-jp-ocr-b\0\
iso646-kr\0iso646-no\0iso646-no2\0iso646-pt\0iso646-pt2\0iso646-se\0\
iso646-se2\0iso646-us\0iso646-yu\0iso_10367-box\0iso_11548-1\0\
iso_2033-1983\0iso_5427\0iso_5427:1981\0iso_5428:1980\0iso_646.irv:1991\0\
iso_8859-1\0iso_8859-10:1992\0iso_8859-14\0iso_8859-14:1998\0iso_8859-15\0\
iso_8859-16\0iso_8859-16:2001\0iso_8859-1:1987\0iso_8859-2\0\
iso_8859-2:1987\0iso_8859-3\0iso_8859-3:1988\0iso_8859-4\0iso_8859-4:1988\0\
iso_8859-5\0iso_8859-5:1988\0iso_8859-6\0iso_8859-6:1987\0iso_8859-7\0\
iso_8859-7:1987\0iso_8859-8\0iso_8859-8:1988\0iso_8859-9\0iso_8859-9:1989\0\
iso_9036\0iso_tr_11548-1\0it\0jis_c6220-1969-ro\0jis_c6229-1984-b\0jp\0\
jp-ocr-b\0js\0jus_i.b1.002\0koi8-e\0koi8-r\0koi8-u\0ksc5636\0kz-1048\0l1\0l10\0\
l2\0l3\0l4\0l5\0l6\0l8\0latin-9\0latin-greek\0latin-greek-1\0latin1\0latin10\0\
latin2\0latin3\0latin4\0latin5\0latin6\0latin8\0mac\0macintosh\0ms936\0\
ms_kanji\0msz_7795.3\0naplps\0nats-dano\0nats-sefi\0nc_nc00-10:81\0\
nf_z_62-010\0nf_z_62-010_(1973)\0no\0no2\0ns_4551-1\0ns_4551-2\0pt\0pt154\0\
pt2\0ptcp154\0r8\0rk1048\0roman8\0se\0se2\0sen_850200_b\0sen_850200_c\0\
shift_jis\0st_sev_358-88\0strk1048-2002\0t.61\0t.61-8bit\0tis-620\0tscii\0uk\0\
us\0us-ascii\0utf-16\0utf-16be\0utf-16le\0utf-32\0utf-32be\0utf-32le\0utf-7\0\
utf-8\0utf16\0utf7\0utf8\0viscii\0windows-1250\0windows-1251\0windows-1252\0\
windows-1253\0windows-1254\0windows-1255\0windows-1256\0windows-1257\0\
windows-1258\0windows-31j\0windows-936\0yu\0";

charset_t charset_aliases[] = {
    /* 437; ibm437; ibm437 */
    {&charset_buffer[0], &charset_buffer[3265], &charset_buffer[3265]},
    /* 850; ibm850; ibm850 */
    {&charset_buffer[4], &charset_buffer[3293], &charset_buffer[3293]},
    /* 851; ibm851; ibm851 */
    {&charset_buffer[8], &charset_buffer[3300], &charset_buffer[3300]},
    /* 852; ibm852; ibm852 */
    {&charset_buffer[12], &charset_buffer[3307], &charset_buffer[3307]},
    /* 855; ibm855; ibm855 */
    {&charset_buffer[16], &charset_buffer[3314], &charset_buffer[3314]},
    /* 857; ibm857; ibm857 */
    {&charset_buffer[20], &charset_buffer[3321], &charset_buffer[3321]},
    /* 860; ibm860; ibm860 */
    {&charset_buffer[24], &charset_buffer[3328], &charset_buffer[3328]},
    /* 861; ibm861; ibm861 */
    {&charset_buffer[28], &charset_buffer[3335], &charset_buffer[3335]},
    /* 862; ibm862; ibm862 */
    {&charset_buffer[32], &charset_buffer[3342], &charset_buffer[3342]},
    /* 863; ibm863; ibm863 */
    {&charset_buffer[36], &charset_buffer[3349], &charset_buffer[3349]},
    /* 865; ibm865; ibm865 */
    {&charset_buffer[40], &charset_buffer[3363], &charset_buffer[3363]},
    /* 866; ibm866; ibm866 */
    {&charset_buffer[44], &charset_buffer[3370], &charset_buffer[3370]},
    /* 869; ibm869; ibm869 */
    {&charset_buffer[48], &charset_buffer[3384], &charset_buffer[3384]},
    /* 904; ibm904; ibm904 */
    {&charset_buffer[52], &charset_buffer[3426], &charset_buffer[3426]},
    /* ansi_x3.110-1983; ansi_x3.110-1983; ansi_x3.110-1983 */
    {&charset_buffer[56], &charset_buffer[56], &charset_buffer[56]},
    /* ansi_x3.4-1968; us-ascii; us-ascii */
    {&charset_buffer[73], &charset_buffer[5635], &charset_buffer[5635]},
    /* ansi_x3.4-1986; us-ascii; us-ascii */
    {&charset_buffer[88], &charset_buffer[5635], &charset_buffer[5635]},
    /* arabic; iso-8859-6; iso-8859-6 */
    {&charset_buffer[103], &charset_buffer[3743], &charset_buffer[3743]},
    /* arabic7; asmo_449; asmo_449 */
    {&charset_buffer[110], &charset_buffer[133], &charset_buffer[133]},
    /* ascii; us-ascii; us-ascii */
    {&charset_buffer[118], &charset_buffer[5635], &charset_buffer[5635]},
    /* asmo-708; iso-8859-6; iso-8859-6 */
    {&charset_buffer[124], &charset_buffer[3743], &charset_buffer[3743]},
    /* asmo_449; asmo_449; asmo_449 */
    {&charset_buffer[133], &charset_buffer[133], &charset_buffer[133]},
    /* big5; big5; big5 */
    {&charset_buffer[142], &charset_buffer[142], &charset_buffer[142]},
    /* big5-hkscs; big5-hkscs; big5-hkscs */
    {&charset_buffer[147], &charset_buffer[147], &charset_buffer[147]},
    /* brf; brf; brf */
    {&charset_buffer[158], &charset_buffer[158], &charset_buffer[158]},
    /* bs_4730; bs_4730; bs_4730 */
    {&charset_buffer[162], &charset_buffer[162], &charset_buffer[162]},
    /* ca; csa_z243.4-1985-1; csa_z243.4-1985-1 */
    {&charset_buffer[170], &charset_buffer[493], &charset_buffer[493]},
    /* cn; gb_1988-80; gb_1988-80 */
    {&charset_buffer[173], &charset_buffer[3029], &charset_buffer[3029]},
    /* cp-ar; ibm868; ibm868 */
    {&charset_buffer[176], &charset_buffer[3377], &charset_buffer[3377]},
    /* cp-gr; ibm869; ibm869 */
    {&charset_buffer[182], &charset_buffer[3384], &charset_buffer[3384]},
    /* cp-is; ibm861; ibm861 */
    {&charset_buffer[188], &charset_buffer[3335], &charset_buffer[3335]},
    /* cp037; ibm037; ibm037 */
    {&charset_buffer[194], &charset_buffer[3130], &charset_buffer[3130]},
    /* cp038; ibm038; ibm038 */
    {&charset_buffer[200], &charset_buffer[3137], &charset_buffer[3137]},
    /* cp1026; ibm1026; ibm1026 */
    {&charset_buffer[206], &charset_buffer[3144], &charset_buffer[3144]},
    /* cp154; ptcp154; pt154 */
    {&charset_buffer[213], &charset_buffer[5504], &charset_buffer[5494]},
    /* cp273; ibm273; ibm273 */
    {&charset_buffer[219], &charset_buffer[3160], &charset_buffer[3160]},
    /* cp274; ibm274; ibm274 */
    {&charset_buffer[225], &charset_buffer[3167], &charset_buffer[3167]},
    /* cp275; ibm275; ibm275 */
    {&charset_buffer[231], &charset_buffer[3174], &charset_buffer[3174]},
    /* cp278; ibm278; ibm278 */
    {&charset_buffer[237], &charset_buffer[3188], &charset_buffer[3188]},
    /* cp280; ibm280; ibm280 */
    {&charset_buffer[243], &charset_buffer[3195], &charset_buffer[3195]},
    /* cp281; ibm281; ibm281 */
    {&charset_buffer[249], &charset_buffer[3202], &charset_buffer[3202]},
    /* cp284; ibm284; ibm284 */
    {&charset_buffer[255], &charset_buffer[3209], &charset_buffer[3209]},
    /* cp285; ibm285; ibm285 */
    {&charset_buffer[261], &charset_buffer[3216], &charset_buffer[3216]},
    /* cp290; ibm290; ibm290 */
    {&charset_buffer[267], &charset_buffer[3223], &charset_buffer[3223]},
    /* cp297; ibm297; ibm297 */
    {&charset_buffer[273], &charset_buffer[3230], &charset_buffer[3230]},
    /* cp367; us-ascii; us-ascii */
    {&charset_buffer[279], &charset_buffer[5635], &charset_buffer[5635]},
    /* cp420; ibm420; ibm420 */
    {&charset_buffer[285], &charset_buffer[3244], &charset_buffer[3244]},
    /* cp423; ibm423; ibm423 */
    {&charset_buffer[291], &charset_buffer[3251], &charset_buffer[3251]},
    /* cp424; ibm424; ibm424 */
    {&charset_buffer[297], &charset_buffer[3258], &charset_buffer[3258]},
    /* cp437; ibm437; ibm437 */
    {&charset_buffer[303], &charset_buffer[3265], &charset_buffer[3265]},
    /* cp500; ibm500; ibm500 */
    {&charset_buffer[309], &charset_buffer[3272], &charset_buffer[3272]},
    /* cp775; ibm775; ibm775 */
    {&charset_buffer[315], &charset_buffer[3279], &charset_buffer[3279]},
    /* cp819; iso-8859-1; iso-8859-1 */
    {&charset_buffer[321], &charset_buffer[3628], &charset_buffer[3628]},
    /* cp850; ibm850; ibm850 */
    {&charset_buffer[327], &charset_buffer[3293], &charset_buffer[3293]},
    /* cp851; ibm851; ibm851 */
    {&charset_buffer[333], &charset_buffer[3300], &charset_buffer[3300]},
    /* cp852; ibm852; ibm852 */
    {&charset_buffer[339], &charset_buffer[3307], &charset_buffer[3307]},
    /* cp855; ibm855; ibm855 */
    {&charset_buffer[345], &charset_buffer[3314], &charset_buffer[3314]},
    /* cp857; ibm857; ibm857 */
    {&charset_buffer[351], &charset_buffer[3321], &charset_buffer[3321]},
    /* cp860; ibm860; ibm860 */
    {&charset_buffer[357], &charset_buffer[3328], &charset_buffer[3328]},
    /* cp861; ibm861; ibm861 */
    {&charset_buffer[363], &charset_buffer[3335], &charset_buffer[3335]},
    /* cp862; ibm862; ibm862 */
    {&charset_buffer[369], &charset_buffer[3342], &charset_buffer[3342]},
    /* cp863; ibm863; ibm863 */
    {&charset_buffer[375], &charset_buffer[3349], &charset_buffer[3349]},
    /* cp864; ibm864; ibm864 */
    {&charset_buffer[381], &charset_buffer[3356], &charset_buffer[3356]},
    /* cp865; ibm865; ibm865 */
    {&charset_buffer[387], &charset_buffer[3363], &charset_buffer[3363]},
    /* cp866; ibm866; ibm866 */
    {&charset_buffer[393], &charset_buffer[3370], &charset_buffer[3370]},
    /* cp868; ibm868; ibm868 */
    {&charset_buffer[399], &charset_buffer[3377], &charset_buffer[3377]},
    /* cp869; ibm869; ibm869 */
    {&charset_buffer[405], &charset_buffer[3384], &charset_buffer[3384]},
    /* cp870; ibm870; ibm870 */
    {&charset_buffer[411], &charset_buffer[3391], &charset_buffer[3391]},
    /* cp871; ibm871; ibm871 */
    {&charset_buffer[417], &charset_buffer[3398], &charset_buffer[3398]},
    /* cp880; ibm880; ibm880 */
    {&charset_buffer[423], &charset_buffer[3405], &charset_buffer[3405]},
    /* cp891; ibm891; ibm891 */
    {&charset_buffer[429], &charset_buffer[3412], &charset_buffer[3412]},
    /* cp903; ibm903; ibm903 */
    {&charset_buffer[435], &charset_buffer[3419], &charset_buffer[3419]},
    /* cp904; ibm904; ibm904 */
    {&charset_buffer[441], &charset_buffer[3426], &charset_buffer[3426]},
    /* cp905; ibm905; ibm905 */
    {&charset_buffer[447], &charset_buffer[3433], &charset_buffer[3433]},
    /* cp918; ibm918; ibm918 */
    {&charset_buffer[453], &charset_buffer[3440], &charset_buffer[3440]},
    /* cp936; gbk; gbk */
    {&charset_buffer[459], &charset_buffer[3040], &charset_buffer[3040]},
    /* csa7-1; csa_z243.4-1985-1; csa_z243.4-1985-1 */
    {&charset_buffer[465], &charset_buffer[493], &charset_buffer[493]},
    /* csa7-2; csa_z243.4-1985-2; csa_z243.4-1985-2 */
    {&charset_buffer[472], &charset_buffer[511], &charset_buffer[511]},
    /* csa_t500-1983; ansi_x3.110-1983; ansi_x3.110-1983 */
    {&charset_buffer[479], &charset_buffer[56], &charset_buffer[56]},
    /* csa_z243.4-1985-1; csa_z243.4-1985-1; csa_z243.4-1985-1 */
    {&charset_buffer[493], &charset_buffer[493], &charset_buffer[493]},
    /* csa_z243.4-1985-2; csa_z243.4-1985-2; csa_z243.4-1985-2 */
    {&charset_buffer[511], &charset_buffer[511], &charset_buffer[511]},
    /* csascii; us-ascii; us-ascii */
    {&charset_buffer[529], &charset_buffer[5635], &charset_buffer[5635]},
    /* csbig5; big5; big5 */
    {&charset_buffer[537], &charset_buffer[142], &charset_buffer[142]},
    /* csbrf; brf; brf */
    {&charset_buffer[544], &charset_buffer[158], &charset_buffer[158]},
    /* csdecmcs; dec-mcs; dec-mcs */
    {&charset_buffer[550], &charset_buffer[2310], &charset_buffer[2310]},
    /* csebcdicatdea; ebcdic-at-de-a; ebcdic-at-de-a */
    {&charset_buffer[559], &charset_buffer[2364], &charset_buffer[2364]},
    /* csebcdiccafr; ebcdic-ca-fr; ebcdic-ca-fr */
    {&charset_buffer[573], &charset_buffer[2399], &charset_buffer[2399]},
    /* csebcdicdkno; ebcdic-dk-no; ebcdic-dk-no */
    {&charset_buffer[586], &charset_buffer[2719], &charset_buffer[2719]},
    /* csebcdicdknoa; ebcdic-dk-no-a; ebcdic-dk-no-a */
    {&charset_buffer[599], &charset_buffer[2732], &charset_buffer[2732]},
    /* csebcdices; ebcdic-es; ebcdic-es */
    {&charset_buffer[613], &charset_buffer[2747], &charset_buffer[2747]},
    /* csebcdicesa; ebcdic-es-a; ebcdic-es-a */
    {&charset_buffer[624], &charset_buffer[2757], &charset_buffer[2757]},
    /* csebcdicess; ebcdic-es-s; ebcdic-es-s */
    {&charset_buffer[636], &charset_buffer[2769], &charset_buffer[2769]},
    /* csebcdicfise; ebcdic-fi-se; ebcdic-fi-se */
    {&charset_buffer[648], &charset_buffer[2781], &charset_buffer[2781]},
    /* csebcdicfisea; ebcdic-fi-se-a; ebcdic-fi-se-a */
    {&charset_buffer[661], &charset_buffer[2794], &charset_buffer[2794]},
    /* csebcdicfr; ebcdic-fr; ebcdic-fr */
    {&charset_buffer[675], &charset_buffer[2809], &charset_buffer[2809]},
    /* csebcdicit; ebcdic-it; ebcdic-it */
    {&charset_buffer[686], &charset_buffer[2830], &charset_buffer[2830]},
    /* csebcdicpt; ebcdic-pt; ebcdic-pt */
    {&charset_buffer[697], &charset_buffer[2867], &charset_buffer[2867]},
    /* csebcdicuk; ebcdic-uk; ebcdic-uk */
    {&charset_buffer[708], &charset_buffer[2877], &charset_buffer[2877]},
    /* csebcdicus; ebcdic-us; ebcdic-us */
    {&charset_buffer[719], &charset_buffer[2887], &charset_buffer[2887]},
    /* cseuckr; euc-kr; euc-kr */
    {&charset_buffer[730], &charset_buffer[2952], &charset_buffer[2952]},
    /* cseucpkdfmtjapanese; euc-jp; euc-jp */
    {&charset_buffer[738], &charset_buffer[2945], &charset_buffer[2945]},
    /* csgb2312; gb2312; gb2312 */
    {&charset_buffer[758], &charset_buffer[3022], &charset_buffer[3022]},
    /* cshproman8; hp-roman8; hp-roman8 */
    {&charset_buffer[767], &charset_buffer[3108], &charset_buffer[3108]},
    /* csibbm904; ibm904; ibm904 */
    {&charset_buffer[778], &charset_buffer[3426], &charset_buffer[3426]},
    /* csibm037; ibm037; ibm037 */
    {&charset_buffer[788], &charset_buffer[3130], &charset_buffer[3130]},
    /* csibm038; ibm038; ibm038 */
    {&charset_buffer[797], &charset_buffer[3137], &charset_buffer[3137]},
    /* csibm1026; ibm1026; ibm1026 */
    {&charset_buffer[806], &charset_buffer[3144], &charset_buffer[3144]},
    /* csibm273; ibm273; ibm273 */
    {&charset_buffer[816], &charset_buffer[3160], &charset_buffer[3160]},
    /* csibm274; ibm274; ibm274 */
    {&charset_buffer[825], &charset_buffer[3167], &charset_buffer[3167]},
    /* csibm275; ibm275; ibm275 */
    {&charset_buffer[834], &charset_buffer[3174], &charset_buffer[3174]},
    /* csibm277; ibm277; ibm277 */
    {&charset_buffer[843], &charset_buffer[3181], &charset_buffer[3181]},
    /* csibm278; ibm278; ibm278 */
    {&charset_buffer[852], &charset_buffer[3188], &charset_buffer[3188]},
    /* csibm280; ibm280; ibm280 */
    {&charset_buffer[861], &charset_buffer[3195], &charset_buffer[3195]},
    /* csibm281; ibm281; ibm281 */
    {&charset_buffer[870], &charset_buffer[3202], &charset_buffer[3202]},
    /* csibm284; ibm284; ibm284 */
    {&charset_buffer[879], &charset_buffer[3209], &charset_buffer[3209]},
    /* csibm285; ibm285; ibm285 */
    {&charset_buffer[888], &charset_buffer[3216], &charset_buffer[3216]},
    /* csibm290; ibm290; ibm290 */
    {&charset_buffer[897], &charset_buffer[3223], &charset_buffer[3223]},
    /* csibm297; ibm297; ibm297 */
    {&charset_buffer[906], &charset_buffer[3230], &charset_buffer[3230]},
    /* csibm420; ibm420; ibm420 */
    {&charset_buffer[915], &charset_buffer[3244], &charset_buffer[3244]},
    /* csibm423; ibm423; ibm423 */
    {&charset_buffer[924], &charset_buffer[3251], &charset_buffer[3251]},
    /* csibm424; ibm424; ibm424 */
    {&charset_buffer[933], &charset_buffer[3258], &charset_buffer[3258]},
    /* csibm500; ibm500; ibm500 */
    {&charset_buffer[942], &charset_buffer[3272], &charset_buffer[3272]},
    /* csibm851; ibm851; ibm851 */
    {&charset_buffer[951], &charset_buffer[3300], &charset_buffer[3300]},
    /* csibm855; ibm855; ibm855 */
    {&charset_buffer[960], &charset_buffer[3314], &charset_buffer[3314]},
    /* csibm857; ibm857; ibm857 */
    {&charset_buffer[969], &charset_buffer[3321], &charset_buffer[3321]},
    /* csibm860; ibm860; ibm860 */
    {&charset_buffer[978], &charset_buffer[3328], &charset_buffer[3328]},
    /* csibm861; ibm861; ibm861 */
    {&charset_buffer[987], &charset_buffer[3335], &charset_buffer[3335]},
    /* csibm863; ibm863; ibm863 */
    {&charset_buffer[996], &charset_buffer[3349], &charset_buffer[3349]},
    /* csibm864; ibm864; ibm864 */
    {&charset_buffer[1005], &charset_buffer[3356], &charset_buffer[3356]},
    /* csibm865; ibm865; ibm865 */
    {&charset_buffer[1014], &charset_buffer[3363], &charset_buffer[3363]},
    /* csibm866; ibm866; ibm866 */
    {&charset_buffer[1023], &charset_buffer[3370], &charset_buffer[3370]},
    /* csibm868; ibm868; ibm868 */
    {&charset_buffer[1032], &charset_buffer[3377], &charset_buffer[3377]},
    /* csibm869; ibm869; ibm869 */
    {&charset_buffer[1041], &charset_buffer[3384], &charset_buffer[3384]},
    /* csibm870; ibm870; ibm870 */
    {&charset_buffer[1050], &charset_buffer[3391], &charset_buffer[3391]},
    /* csibm871; ibm871; ibm871 */
    {&charset_buffer[1059], &charset_buffer[3398], &charset_buffer[3398]},
    /* csibm880; ibm880; ibm880 */
    {&charset_buffer[1068], &charset_buffer[3405], &charset_buffer[3405]},
    /* csibm891; ibm891; ibm891 */
    {&charset_buffer[1077], &charset_buffer[3412], &charset_buffer[3412]},
    /* csibm903; ibm903; ibm903 */
    {&charset_buffer[1086], &charset_buffer[3419], &charset_buffer[3419]},
    /* csibm905; ibm905; ibm905 */
    {&charset_buffer[1095], &charset_buffer[3433], &charset_buffer[3433]},
    /* csibm918; ibm918; ibm918 */
    {&charset_buffer[1104], &charset_buffer[3440], &charset_buffer[3440]},
    /* csibmebcdicatde; ebcdic-at-de; ebcdic-at-de */
    {&charset_buffer[1113], &charset_buffer[2351], &charset_buffer[2351]},
    /* csiso10367box; iso_10367-box; iso_10367-box */
    {&charset_buffer[1129], &charset_buffer[4685], &charset_buffer[4685]},
    /* csiso103t618bit; t.61-8bit; t.61-8bit */
    {&charset_buffer[1143], &charset_buffer[5605], &charset_buffer[5605]},
    /* csiso10swedish; sen_850200_b; sen_850200_b */
    {&charset_buffer[1159], &charset_buffer[5536], &charset_buffer[5536]},
    /* csiso111ecmacyrillic; ecma-cyrillic; ecma-cyrillic */
    {&charset_buffer[1174], &charset_buffer[2915], &charset_buffer[2915]},
    /* csiso115481; iso-11548-1; iso_11548-1 */
    {&charset_buffer[1195], &charset_buffer[3550], &charset_buffer[4699]},
    /* csiso11swedishfornames; sen_850200_c; sen_850200_c */
    {&charset_buffer[1207], &charset_buffer[5549], &charset_buffer[5549]},
    /* csiso121canadian1; csa_z243.4-1985-1; csa_z243.4-1985-1 */
    {&charset_buffer[1230], &charset_buffer[493], &charset_buffer[493]},
    /* csiso122canadian2; csa_z243.4-1985-2; csa_z243.4-1985-2 */
    {&charset_buffer[1248], &charset_buffer[511], &charset_buffer[511]},
    /* csiso139csn369103; csn_369103; csn_369103 */
    {&charset_buffer[1266], &charset_buffer[2078], &charset_buffer[2078]},
    /* csiso141jusib1002; jus_i.b1.002; jus_i.b1.002 */
    {&charset_buffer[1284], &charset_buffer[5186], &charset_buffer[5186]},
    /* csiso143iecp271; iec_p27-1; iec_p27-1 */
    {&charset_buffer[1302], &charset_buffer[3447], &charset_buffer[3447]},
    /* csiso14jisc6220ro; jis_c6220-1969-ro; jis_c6220-1969-ro */
    {&charset_buffer[1318], &charset_buffer[5136], &charset_buffer[5136]},
    /* csiso150; greek-ccitt; greek-ccitt */
    {&charset_buffer[1336], &charset_buffer[3064], &charset_buffer[3064]},
    /* csiso150greekccitt; greek-ccitt; greek-ccitt */
    {&charset_buffer[1345], &charset_buffer[3064], &charset_buffer[3064]},
    /* csiso151cuba; nc_nc00-10:81; nc_nc00-10:81 */
    {&charset_buffer[1364], &charset_buffer[5419], &charset_buffer[5419]},
    /* csiso153gost1976874; gost_19768-74; gost_19768-74 */
    {&charset_buffer[1377], &charset_buffer[3044], &charset_buffer[3044]},
    /* csiso15italian; it; it */
    {&charset_buffer[1397], &charset_buffer[5133], &charset_buffer[5133]},
    /* csiso16portuguese; pt; pt */
    {&charset_buffer[1412], &charset_buffer[5491], &charset_buffer[5491]},
    /* csiso17spanish; es; es */
    {&charset_buffer[1430], &charset_buffer[2938], &charset_buffer[2938]},
    /* csiso18greek7old; greek7-old; greek7-old */
    {&charset_buffer[1445], &charset_buffer[3083], &charset_buffer[3083]},
    /* csiso19latingreek; latin-greek; latin-greek */
    {&charset_buffer[1462], &charset_buffer[5269], &charset_buffer[5269]},
    /* csiso2022jp; iso-2022-jp; iso-2022-jp */
    {&charset_buffer[1480], &charset_buffer[3590], &charset_buffer[3590]},
    /* csiso2022jp2; iso-2022-jp-2; iso-2022-jp-2 */
    {&charset_buffer[1492], &charset_buffer[3602], &charset_buffer[3602]},
    /* csiso2022kr; iso-2022-kr; iso-2022-kr */
    {&charset_buffer[1505], &charset_buffer[3616], &charset_buffer[3616]},
    /* csiso2033; iso_2033-1983; iso_2033-1983 */
    {&charset_buffer[1517], &charset_buffer[4711], &charset_buffer[4711]},
    /* csiso21german; din_66003; din_66003 */
    {&charset_buffer[1527], &charset_buffer[2318], &charset_buffer[2318]},
    /* csiso25french; nf_z_62-010_(1973); nf_z_62-010_(1973) */
    {&charset_buffer[1541], &charset_buffer[5445], &charset_buffer[5445]},
    /* csiso27latingreek1; latin-greek-1; latin-greek-1 */
    {&charset_buffer[1555], &charset_buffer[5281], &charset_buffer[5281]},
    /* csiso49inis; inis; inis */
    {&charset_buffer[1574], &charset_buffer[3457], &charset_buffer[3457]},
    /* csiso4unitedkingdom; bs_4730; bs_4730 */
    {&charset_buffer[1586], &charset_buffer[162], &charset_buffer[162]},
    /* csiso50inis8; inis-8; inis-8 */
    {&charset_buffer[1606], &charset_buffer[3462], &charset_buffer[3462]},
    /* csiso51iniscyrillic; inis-cyrillic; inis-cyrillic */
    {&charset_buffer[1619], &charset_buffer[3469], &charset_buffer[3469]},
    /* csiso5427cyrillic; iso_5427; iso_5427 */
    {&charset_buffer[1639], &charset_buffer[4725], &charset_buffer[4725]},
    /* csiso5428greek; iso_5428:1980; iso_5428:1980 */
    {&charset_buffer[1657], &charset_buffer[4748], &charset_buffer[4748]},
    /* csiso57gb1988; gb_1988-80; gb_1988-80 */
    {&charset_buffer[1672], &charset_buffer[3029], &charset_buffer[3029]},
    /* csiso60danishnorwegian; ns_4551-1; ns_4551-1 */
    {&charset_buffer[1686], &charset_buffer[5471], &charset_buffer[5471]},
    /* csiso60norwegian1; ns_4551-1; ns_4551-1 */
    {&charset_buffer[1709], &charset_buffer[5471], &charset_buffer[5471]},
    /* csiso61norwegian2; ns_4551-2; ns_4551-2 */
    {&charset_buffer[1727], &charset_buffer[5481], &charset_buffer[5481]},
    /* csiso646danish; ds_2089; ds_2089 */
    {&charset_buffer[1745], &charset_buffer[2338], &charset_buffer[2338]},
    /* csiso69french; nf_z_62-010; nf_z_62-010 */
    {&charset_buffer[1760], &charset_buffer[5433], &charset_buffer[5433]},
    /* csiso84portuguese2; pt2; pt2 */
    {&charset_buffer[1774], &charset_buffer[5500], &charset_buffer[5500]},
    /* csiso85spanish2; es2; es2 */
    {&charset_buffer[1793], &charset_buffer[2941], &charset_buffer[2941]},
    /* csiso86hungarian; msz_7795.3; msz_7795.3 */
    {&charset_buffer[1809], &charset_buffer[5381], &charset_buffer[5381]},
    /* csiso88greek7; greek7; greek7 */
    {&charset_buffer[1826], &charset_buffer[3076], &charset_buffer[3076]},
    /* csiso89asmo449; asmo_449; asmo_449 */
    {&charset_buffer[1840], &charset_buffer[133], &charset_buffer[133]},
    /* csiso90; iso-ir-90; iso-ir-90 */
    {&charset_buffer[1855], &charset_buffer[4351], &charset_buffer[4351]},
    /* csiso92jisc62991984b; jis_c6229-1984-b; jis_c6229-1984-b */
    {&charset_buffer[1863], &charset_buffer[5154], &charset_buffer[5154]},
    /* csiso99naplps; ansi_x3.110-1983; ansi_x3.110-1983 */
    {&charset_buffer[1884], &charset_buffer[56], &charset_buffer[56]},
    /* csisolatin1; iso-8859-1; iso-8859-1 */
    {&charset_buffer[1898], &charset_buffer[3628], &charset_buffer[3628]},
    /* csisolatin2; iso-8859-2; iso-8859-2 */
    {&charset_buffer[1910], &charset_buffer[3699], &charset_buffer[3699]},
    /* csisolatin3; iso-8859-3; iso-8859-3 */
    {&charset_buffer[1922], &charset_buffer[3710], &charset_buffer[3710]},
    /* csisolatin4; iso-8859-4; iso-8859-4 */
    {&charset_buffer[1934], &charset_buffer[3721], &charset_buffer[3721]},
    /* csisolatin5; iso-8859-9; iso-8859-9 */
    {&charset_buffer[1946], &charset_buffer[3776], &charset_buffer[3776]},
    /* csisolatin6; iso-8859-10; iso-8859-10 */
    {&charset_buffer[1958], &charset_buffer[3639], &charset_buffer[3639]},
    /* csisolatinarabic; iso-8859-6; iso-8859-6 */
    {&charset_buffer[1970], &charset_buffer[3743], &charset_buffer[3743]},
    /* csisolatincyrillic; iso-8859-5; iso-8859-5 */
    {&charset_buffer[1987], &charset_buffer[3732], &charset_buffer[3732]},
    /* csisolatingreek; iso-8859-7; iso-8859-7 */
    {&charset_buffer[2006], &charset_buffer[3754], &charset_buffer[3754]},
    /* csisolatinhebrew; iso-8859-8; iso-8859-8 */
    {&charset_buffer[2022], &charset_buffer[3765], &charset_buffer[3765]},
    /* cskoi8r; koi8-r; koi8-r */
    {&charset_buffer[2039], &charset_buffer[5206], &charset_buffer[5206]},
    /* csksc5636; ksc5636; ksc5636 */
    {&charset_buffer[2047], &charset_buffer[5220], &charset_buffer[5220]},
    /* cskz1048; kz-1048; strk1048-2002 */
    {&charset_buffer[2057], &charset_buffer[5228], &charset_buffer[5586]},
    /* csmacintosh; macintosh; macintosh */
    {&charset_buffer[2066], &charset_buffer[5356], &charset_buffer[5356]},
    /* csn_369103; csn_369103; csn_369103 */
    {&charset_buffer[2078], &charset_buffer[2078], &charset_buffer[2078]},
    /* csnatsdano; nats-dano; nats-dano */
    {&charset_buffer[2089], &charset_buffer[5399], &charset_buffer[5399]},
    /* csnatssefi; nats-sefi; nats-sefi */
    {&charset_buffer[2100], &charset_buffer[5409], &charset_buffer[5409]},
    /* cspc775baltic; ibm775; ibm775 */
    {&charset_buffer[2111], &charset_buffer[3279], &charset_buffer[3279]},
    /* cspc850multilingual; ibm850; ibm850 */
    {&charset_buffer[2125], &charset_buffer[3293], &charset_buffer[3293]},
    /* cspc862latinhebrew; ibm862; ibm862 */
    {&charset_buffer[2145], &charset_buffer[3342], &charset_buffer[3342]},
    /* cspc8codepage437; ibm437; ibm437 */
    {&charset_buffer[2164], &charset_buffer[3265], &charset_buffer[3265]},
    /* cspcp852; ibm852; ibm852 */
    {&charset_buffer[2181], &charset_buffer[3307], &charset_buffer[3307]},
    /* csptcp154; ptcp154; pt154 */
    {&charset_buffer[2190], &charset_buffer[5504], &charset_buffer[5494]},
    /* csshiftjis; shift_jis; shift_jis */
    {&charset_buffer[2200], &charset_buffer[5562], &charset_buffer[5562]},
    /* cstscii; tscii; tscii */
    {&charset_buffer[2211], &charset_buffer[5623], &charset_buffer[5623]},
    /* csucs4; iso-10646-ucs-4; csucs4 */
    {&charset_buffer[2219], &charset_buffer[3509], &charset_buffer[2219]},
    /* csunicode; iso-10646-ucs-2; csunicode */
    {&charset_buffer[2226], &charset_buffer[3493], &charset_buffer[2226]},
    /* csunicodelatin1; iso-10646-unicode-latin1; iso-10646 */
    {&charset_buffer[2236], &charset_buffer[3525], &charset_buffer[3483]},
    /* csviscii; viscii; viscii */
    {&charset_buffer[2252], &charset_buffer[5722], &charset_buffer[5722]},
    /* cswindows31j; windows-31j; windows-31j */
    {&charset_buffer[2261], &charset_buffer[5846], &charset_buffer[5846]},
    /* cuba; nc_nc00-10:81; nc_nc00-10:81 */
    {&charset_buffer[2274], &charset_buffer[5419], &charset_buffer[5419]},
    /* cyrillic; iso-8859-5; iso-8859-5 */
    {&charset_buffer[2279], &charset_buffer[3732], &charset_buffer[3732]},
    /* cyrillic-asian; ptcp154; pt154 */
    {&charset_buffer[2288], &charset_buffer[5504], &charset_buffer[5494]},
    /* de; din_66003; din_66003 */
    {&charset_buffer[2303], &charset_buffer[2318], &charset_buffer[2318]},
    /* dec; dec-mcs; dec-mcs */
    {&charset_buffer[2306], &charset_buffer[2310], &charset_buffer[2310]},
    /* dec-mcs; dec-mcs; dec-mcs */
    {&charset_buffer[2310], &charset_buffer[2310], &charset_buffer[2310]},
    /* din_66003; din_66003; din_66003 */
    {&charset_buffer[2318], &charset_buffer[2318], &charset_buffer[2318]},
    /* dk; ds_2089; ds_2089 */
    {&charset_buffer[2328], &charset_buffer[2338], &charset_buffer[2338]},
    /* ds2089; ds_2089; ds_2089 */
    {&charset_buffer[2331], &charset_buffer[2338], &charset_buffer[2338]},
    /* ds_2089; ds_2089; ds_2089 */
    {&charset_buffer[2338], &charset_buffer[2338], &charset_buffer[2338]},
    /* e13b; iso_2033-1983; iso_2033-1983 */
    {&charset_buffer[2346], &charset_buffer[4711], &charset_buffer[4711]},
    /* ebcdic-at-de; ebcdic-at-de; ebcdic-at-de */
    {&charset_buffer[2351], &charset_buffer[2351], &charset_buffer[2351]},
    /* ebcdic-at-de-a; ebcdic-at-de-a; ebcdic-at-de-a */
    {&charset_buffer[2364], &charset_buffer[2364], &charset_buffer[2364]},
    /* ebcdic-be; ibm274; ibm274 */
    {&charset_buffer[2379], &charset_buffer[3167], &charset_buffer[3167]},
    /* ebcdic-br; ibm275; ibm275 */
    {&charset_buffer[2389], &charset_buffer[3174], &charset_buffer[3174]},
    /* ebcdic-ca-fr; ebcdic-ca-fr; ebcdic-ca-fr */
    {&charset_buffer[2399], &charset_buffer[2399], &charset_buffer[2399]},
    /* ebcdic-cp-ar1; ibm420; ibm420 */
    {&charset_buffer[2412], &charset_buffer[3244], &charset_buffer[3244]},
    /* ebcdic-cp-ar2; ibm918; ibm918 */
    {&charset_buffer[2426], &charset_buffer[3440], &charset_buffer[3440]},
    /* ebcdic-cp-be; ibm500; ibm500 */
    {&charset_buffer[2440], &charset_buffer[3272], &charset_buffer[3272]},
    /* ebcdic-cp-ca; ibm037; ibm037 */
    {&charset_buffer[2453], &charset_buffer[3130], &charset_buffer[3130]},
    /* ebcdic-cp-ch; ibm500; ibm500 */
    {&charset_buffer[2466], &charset_buffer[3272], &charset_buffer[3272]},
    /* ebcdic-cp-dk; ibm277; ibm277 */
    {&charset_buffer[2479], &charset_buffer[3181], &charset_buffer[3181]},
    /* ebcdic-cp-es; ibm284; ibm284 */
    {&charset_buffer[2492], &charset_buffer[3209], &charset_buffer[3209]},
    /* ebcdic-cp-fi; ibm278; ibm278 */
    {&charset_buffer[2505], &charset_buffer[3188], &charset_buffer[3188]},
    /* ebcdic-cp-fr; ibm297; ibm297 */
    {&charset_buffer[2518], &charset_buffer[3230], &charset_buffer[3230]},
    /* ebcdic-cp-gb; ibm285; ibm285 */
    {&charset_buffer[2531], &charset_buffer[3216], &charset_buffer[3216]},
    /* ebcdic-cp-gr; ibm423; ibm423 */
    {&charset_buffer[2544], &charset_buffer[3251], &charset_buffer[3251]},
    /* ebcdic-cp-he; ibm424; ibm424 */
    {&charset_buffer[2557], &charset_buffer[3258], &charset_buffer[3258]},
    /* ebcdic-cp-is; ibm871; ibm871 */
    {&charset_buffer[2570], &charset_buffer[3398], &charset_buffer[3398]},
    /* ebcdic-cp-it; ibm280; ibm280 */
    {&charset_buffer[2583], &charset_buffer[3195], &charset_buffer[3195]},
    /* ebcdic-cp-nl; ibm037; ibm037 */
    {&charset_buffer[2596], &charset_buffer[3130], &charset_buffer[3130]},
    /* ebcdic-cp-no; ibm277; ibm277 */
    {&charset_buffer[2609], &charset_buffer[3181], &charset_buffer[3181]},
    /* ebcdic-cp-roece; ibm870; ibm870 */
    {&charset_buffer[2622], &charset_buffer[3391], &charset_buffer[3391]},
    /* ebcdic-cp-se; ibm278; ibm278 */
    {&charset_buffer[2638], &charset_buffer[3188], &charset_buffer[3188]},
    /* ebcdic-cp-tr; ibm905; ibm905 */
    {&charset_buffer[2651], &charset_buffer[3433], &charset_buffer[3433]},
    /* ebcdic-cp-us; ibm037; ibm037 */
    {&charset_buffer[2664], &charset_buffer[3130], &charset_buffer[3130]},
    /* ebcdic-cp-wt; ibm037; ibm037 */
    {&charset_buffer[2677], &charset_buffer[3130], &charset_buffer[3130]},
    /* ebcdic-cp-yu; ibm870; ibm870 */
    {&charset_buffer[2690], &charset_buffer[3391], &charset_buffer[3391]},
    /* ebcdic-cyrillic; ibm880; ibm880 */
    {&charset_buffer[2703], &charset_buffer[3405], &charset_buffer[3405]},
    /* ebcdic-dk-no; ebcdic-dk-no; ebcdic-dk-no */
    {&charset_buffer[2719], &charset_buffer[2719], &charset_buffer[2719]},
    /* ebcdic-dk-no-a; ebcdic-dk-no-a; ebcdic-dk-no-a */
    {&charset_buffer[2732], &charset_buffer[2732], &charset_buffer[2732]},
    /* ebcdic-es; ebcdic-es; ebcdic-es */
    {&charset_buffer[2747], &charset_buffer[2747], &charset_buffer[2747]},
    /* ebcdic-es-a; ebcdic-es-a; ebcdic-es-a */
    {&charset_buffer[2757], &charset_buffer[2757], &charset_buffer[2757]},
    /* ebcdic-es-s; ebcdic-es-s; ebcdic-es-s */
    {&charset_buffer[2769], &charset_buffer[2769], &charset_buffer[2769]},
    /* ebcdic-fi-se; ebcdic-fi-se; ebcdic-fi-se */
    {&charset_buffer[2781], &charset_buffer[2781], &charset_buffer[2781]},
    /* ebcdic-fi-se-a; ebcdic-fi-se-a; ebcdic-fi-se-a */
    {&charset_buffer[2794], &charset_buffer[2794], &charset_buffer[2794]},
    /* ebcdic-fr; ebcdic-fr; ebcdic-fr */
    {&charset_buffer[2809], &charset_buffer[2809], &charset_buffer[2809]},
    /* ebcdic-int; ibm038; ibm038 */
    {&charset_buffer[2819], &charset_buffer[3137], &charset_buffer[3137]},
    /* ebcdic-it; ebcdic-it; ebcdic-it */
    {&charset_buffer[2830], &charset_buffer[2830], &charset_buffer[2830]},
    /* ebcdic-jp-e; ibm281; ibm281 */
    {&charset_buffer[2840], &charset_buffer[3202], &charset_buffer[3202]},
    /* ebcdic-jp-kana; ibm290; ibm290 */
    {&charset_buffer[2852], &charset_buffer[3223], &charset_buffer[3223]},
    /* ebcdic-pt; ebcdic-pt; ebcdic-pt */
    {&charset_buffer[2867], &charset_buffer[2867], &charset_buffer[2867]},
    /* ebcdic-uk; ebcdic-uk; ebcdic-uk */
    {&charset_buffer[2877], &charset_buffer[2877], &charset_buffer[2877]},
    /* ebcdic-us; ebcdic-us; ebcdic-us */
    {&charset_buffer[2887], &charset_buffer[2887], &charset_buffer[2887]},
    /* ecma-114; iso-8859-6; iso-8859-6 */
    {&charset_buffer[2897], &charset_buffer[3743], &charset_buffer[3743]},
    /* ecma-118; iso-8859-7; iso-8859-7 */
    {&charset_buffer[2906], &charset_buffer[3754], &charset_buffer[3754]},
    /* ecma-cyrillic; ecma-cyrillic; ecma-cyrillic */
    {&charset_buffer[2915], &charset_buffer[2915], &charset_buffer[2915]},
    /* elot_928; iso-8859-7; iso-8859-7 */
    {&charset_buffer[2929], &charset_buffer[3754], &charset_buffer[3754]},
    /* es; es; es */
    {&charset_buffer[2938], &charset_buffer[2938], &charset_buffer[2938]},
    /* es2; es2; es2 */
    {&charset_buffer[2941], &charset_buffer[2941], &charset_buffer[2941]},
    /* euc-jp; euc-jp; euc-jp */
    {&charset_buffer[2945], &charset_buffer[2945], &charset_buffer[2945]},
    /* euc-kr; euc-kr; euc-kr */
    {&charset_buffer[2952], &charset_buffer[2952], &charset_buffer[2952]},
    /* extended_unix_code_packed_format_for_japanese; euc-jp; euc-jp */
    {&charset_buffer[2959], &charset_buffer[2945], &charset_buffer[2945]},
    /* fi; sen_850200_b; sen_850200_b */
    {&charset_buffer[3005], &charset_buffer[5536], &charset_buffer[5536]},
    /* fr; nf_z_62-010; nf_z_62-010 */
    {&charset_buffer[3008], &charset_buffer[5433], &charset_buffer[5433]},
    /* gb; bs_4730; bs_4730 */
    {&charset_buffer[3011], &charset_buffer[162], &charset_buffer[162]},
    /* gb18030; gb18030; gb18030 */
    {&charset_buffer[3014], &charset_buffer[3014], &charset_buffer[3014]},
    /* gb2312; gb2312; gb2312 */
    {&charset_buffer[3022], &charset_buffer[3022], &charset_buffer[3022]},
    /* gb_1988-80; gb_1988-80; gb_1988-80 */
    {&charset_buffer[3029], &charset_buffer[3029], &charset_buffer[3029]},
    /* gbk; gbk; gbk */
    {&charset_buffer[3040], &charset_buffer[3040], &charset_buffer[3040]},
    /* gost_19768-74; gost_19768-74; gost_19768-74 */
    {&charset_buffer[3044], &charset_buffer[3044], &charset_buffer[3044]},
    /* greek; iso-8859-7; iso-8859-7 */
    {&charset_buffer[3058], &charset_buffer[3754], &charset_buffer[3754]},
    /* greek-ccitt; greek-ccitt; greek-ccitt */
    {&charset_buffer[3064], &charset_buffer[3064], &charset_buffer[3064]},
    /* greek7; greek7; greek7 */
    {&charset_buffer[3076], &charset_buffer[3076], &charset_buffer[3076]},
    /* greek7-old; greek7-old; greek7-old */
    {&charset_buffer[3083], &charset_buffer[3083], &charset_buffer[3083]},
    /* greek8; iso-8859-7; iso-8859-7 */
    {&charset_buffer[3094], &charset_buffer[3754], &charset_buffer[3754]},
    /* hebrew; iso-8859-8; iso-8859-8 */
    {&charset_buffer[3101], &charset_buffer[3765], &charset_buffer[3765]},
    /* hp-roman8; hp-roman8; hp-roman8 */
    {&charset_buffer[3108], &charset_buffer[3108], &charset_buffer[3108]},
    /* hu; msz_7795.3; msz_7795.3 */
    {&charset_buffer[3118], &charset_buffer[5381], &charset_buffer[5381]},
    /* ibm-1047; ibm1047; ibm1047 */
    {&charset_buffer[3121], &charset_buffer[3152], &charset_buffer[3152]},
    /* ibm037; ibm037; ibm037 */
    {&charset_buffer[3130], &charset_buffer[3130], &charset_buffer[3130]},
    /* ibm038; ibm038; ibm038 */
    {&charset_buffer[3137], &charset_buffer[3137], &charset_buffer[3137]},
    /* ibm1026; ibm1026; ibm1026 */
    {&charset_buffer[3144], &charset_buffer[3144], &charset_buffer[3144]},
    /* ibm1047; ibm1047; ibm1047 */
    {&charset_buffer[3152], &charset_buffer[3152], &charset_buffer[3152]},
    /* ibm273; ibm273; ibm273 */
    {&charset_buffer[3160], &charset_buffer[3160], &charset_buffer[3160]},
    /* ibm274; ibm274; ibm274 */
    {&charset_buffer[3167], &charset_buffer[3167], &charset_buffer[3167]},
    /* ibm275; ibm275; ibm275 */
    {&charset_buffer[3174], &charset_buffer[3174], &charset_buffer[3174]},
    /* ibm277; ibm277; ibm277 */
    {&charset_buffer[3181], &charset_buffer[3181], &charset_buffer[3181]},
    /* ibm278; ibm278; ibm278 */
    {&charset_buffer[3188], &charset_buffer[3188], &charset_buffer[3188]},
    /* ibm280; ibm280; ibm280 */
    {&charset_buffer[3195], &charset_buffer[3195], &charset_buffer[3195]},
    /* ibm281; ibm281; ibm281 */
    {&charset_buffer[3202], &charset_buffer[3202], &charset_buffer[3202]},
    /* ibm284; ibm284; ibm284 */
    {&charset_buffer[3209], &charset_buffer[3209], &charset_buffer[3209]},
    /* ibm285; ibm285; ibm285 */
    {&charset_buffer[3216], &charset_buffer[3216], &charset_buffer[3216]},
    /* ibm290; ibm290; ibm290 */
    {&charset_buffer[3223], &charset_buffer[3223], &charset_buffer[3223]},
    /* ibm297; ibm297; ibm297 */
    {&charset_buffer[3230], &charset_buffer[3230], &charset_buffer[3230]},
    /* ibm367; us-ascii; us-ascii */
    {&charset_buffer[3237], &charset_buffer[5635], &charset_buffer[5635]},
    /* ibm420; ibm420; ibm420 */
    {&charset_buffer[3244], &charset_buffer[3244], &charset_buffer[3244]},
    /* ibm423; ibm423; ibm423 */
    {&charset_buffer[3251], &charset_buffer[3251], &charset_buffer[3251]},
    /* ibm424; ibm424; ibm424 */
    {&charset_buffer[3258], &charset_buffer[3258], &charset_buffer[3258]},
    /* ibm437; ibm437; ibm437 */
    {&charset_buffer[3265], &charset_buffer[3265], &charset_buffer[3265]},
    /* ibm500; ibm500; ibm500 */
    {&charset_buffer[3272], &charset_buffer[3272], &charset_buffer[3272]},
    /* ibm775; ibm775; ibm775 */
    {&charset_buffer[3279], &charset_buffer[3279], &charset_buffer[3279]},
    /* ibm819; iso-8859-1; iso-8859-1 */
    {&charset_buffer[3286], &charset_buffer[3628], &charset_buffer[3628]},
    /* ibm850; ibm850; ibm850 */
    {&charset_buffer[3293], &charset_buffer[3293], &charset_buffer[3293]},
    /* ibm851; ibm851; ibm851 */
    {&charset_buffer[3300], &charset_buffer[3300], &charset_buffer[3300]},
    /* ibm852; ibm852; ibm852 */
    {&charset_buffer[3307], &charset_buffer[3307], &charset_buffer[3307]},
    /* ibm855; ibm855; ibm855 */
    {&charset_buffer[3314], &charset_buffer[3314], &charset_buffer[3314]},
    /* ibm857; ibm857; ibm857 */
    {&charset_buffer[3321], &charset_buffer[3321], &charset_buffer[3321]},
    /* ibm860; ibm860; ibm860 */
    {&charset_buffer[3328], &charset_buffer[3328], &charset_buffer[3328]},
    /* ibm861; ibm861; ibm861 */
    {&charset_buffer[3335], &charset_buffer[3335], &charset_buffer[3335]},
    /* ibm862; ibm862; ibm862 */
    {&charset_buffer[3342], &charset_buffer[3342], &charset_buffer[3342]},
    /* ibm863; ibm863; ibm863 */
    {&charset_buffer[3349], &charset_buffer[3349], &charset_buffer[3349]},
    /* ibm864; ibm864; ibm864 */
    {&charset_buffer[3356], &charset_buffer[3356], &charset_buffer[3356]},
    /* ibm865; ibm865; ibm865 */
    {&charset_buffer[3363], &charset_buffer[3363], &charset_buffer[3363]},
    /* ibm866; ibm866; ibm866 */
    {&charset_buffer[3370], &charset_buffer[3370], &charset_buffer[3370]},
    /* ibm868; ibm868; ibm868 */
    {&charset_buffer[3377], &charset_buffer[3377], &charset_buffer[3377]},
    /* ibm869; ibm869; ibm869 */
    {&charset_buffer[3384], &charset_buffer[3384], &charset_buffer[3384]},
    /* ibm870; ibm870; ibm870 */
    {&charset_buffer[3391], &charset_buffer[3391], &charset_buffer[3391]},
    /* ibm871; ibm871; ibm871 */
    {&charset_buffer[3398], &charset_buffer[3398], &charset_buffer[3398]},
    /* ibm880; ibm880; ibm880 */
    {&charset_buffer[3405], &charset_buffer[3405], &charset_buffer[3405]},
    /* ibm891; ibm891; ibm891 */
    {&charset_buffer[3412], &charset_buffer[3412], &charset_buffer[3412]},
    /* ibm903; ibm903; ibm903 */
    {&charset_buffer[3419], &charset_buffer[3419], &charset_buffer[3419]},
    /* ibm904; ibm904; ibm904 */
    {&charset_buffer[3426], &charset_buffer[3426], &charset_buffer[3426]},
    /* ibm905; ibm905; ibm905 */
    {&charset_buffer[3433], &charset_buffer[3433], &charset_buffer[3433]},
    /* ibm918; ibm918; ibm918 */
    {&charset_buffer[3440], &charset_buffer[3440], &charset_buffer[3440]},
    /* iec_p27-1; iec_p27-1; iec_p27-1 */
    {&charset_buffer[3447], &charset_buffer[3447], &charset_buffer[3447]},
    /* inis; inis; inis */
    {&charset_buffer[3457], &charset_buffer[3457], &charset_buffer[3457]},
    /* inis-8; inis-8; inis-8 */
    {&charset_buffer[3462], &charset_buffer[3462], &charset_buffer[3462]},
    /* inis-cyrillic; inis-cyrillic; inis-cyrillic */
    {&charset_buffer[3469], &charset_buffer[3469], &charset_buffer[3469]},
    /* iso-10646; iso-10646-unicode-latin1; iso-10646 */
    {&charset_buffer[3483], &charset_buffer[3525], &charset_buffer[3483]},
    /* iso-10646-ucs-2; iso-10646-ucs-2; csunicode */
    {&charset_buffer[3493], &charset_buffer[3493], &charset_buffer[2226]},
    /* iso-10646-ucs-4; iso-10646-ucs-4; csucs4 */
    {&charset_buffer[3509], &charset_buffer[3509], &charset_buffer[2219]},
    /* iso-10646-unicode-latin1; iso-10646-unicode-latin1; iso-10646 */
    {&charset_buffer[3525], &charset_buffer[3525], &charset_buffer[3483]},
    /* iso-11548-1; iso-11548-1; iso_11548-1 */
    {&charset_buffer[3550], &charset_buffer[3550], &charset_buffer[4699]},
    /* iso-2022-cn; iso-2022-cn; iso-2022-cn */
    {&charset_buffer[3562], &charset_buffer[3562], &charset_buffer[3562]},
    /* iso-2022-cn-ext; iso-2022-cn-ext; iso-2022-cn-ext */
    {&charset_buffer[3574], &charset_buffer[3574], &charset_buffer[3574]},
    /* iso-2022-jp; iso-2022-jp; iso-2022-jp */
    {&charset_buffer[3590], &charset_buffer[3590], &charset_buffer[3590]},
    /* iso-2022-jp-2; iso-2022-jp-2; iso-2022-jp-2 */
    {&charset_buffer[3602], &charset_buffer[3602], &charset_buffer[3602]},
    /* iso-2022-kr; iso-2022-kr; iso-2022-kr */
    {&charset_buffer[3616], &charset_buffer[3616], &charset_buffer[3616]},
    /* iso-8859-1; iso-8859-1; iso-8859-1 */
    {&charset_buffer[3628], &charset_buffer[3628], &charset_buffer[3628]},
    /* iso-8859-10; iso-8859-10; iso-8859-10 */
    {&charset_buffer[3639], &charset_buffer[3639], &charset_buffer[3639]},
    /* iso-8859-13; iso-8859-13; iso-8859-13 */
    {&charset_buffer[3651], &charset_buffer[3651], &charset_buffer[3651]},
    /* iso-8859-14; iso-8859-14; iso-8859-14 */
    {&charset_buffer[3663], &charset_buffer[3663], &charset_buffer[3663]},
    /* iso-8859-15; iso-8859-15; iso-8859-15 */
    {&charset_buffer[3675], &charset_buffer[3675], &charset_buffer[3675]},
    /* iso-8859-16; iso-8859-16; iso-8859-16 */
    {&charset_buffer[3687], &charset_buffer[3687], &charset_buffer[3687]},
    /* iso-8859-2; iso-8859-2; iso-8859-2 */
    {&charset_buffer[3699], &charset_buffer[3699], &charset_buffer[3699]},
    /* iso-8859-3; iso-8859-3; iso-8859-3 */
    {&charset_buffer[3710], &charset_buffer[3710], &charset_buffer[3710]},
    /* iso-8859-4; iso-8859-4; iso-8859-4 */
    {&charset_buffer[3721], &charset_buffer[3721], &charset_buffer[3721]},
    /* iso-8859-5; iso-8859-5; iso-8859-5 */
    {&charset_buffer[3732], &charset_buffer[3732], &charset_buffer[3732]},
    /* iso-8859-6; iso-8859-6; iso-8859-6 */
    {&charset_buffer[3743], &charset_buffer[3743], &charset_buffer[3743]},
    /* iso-8859-7; iso-8859-7; iso-8859-7 */
    {&charset_buffer[3754], &charset_buffer[3754], &charset_buffer[3754]},
    /* iso-8859-8; iso-8859-8; iso-8859-8 */
    {&charset_buffer[3765], &charset_buffer[3765], &charset_buffer[3765]},
    /* iso-8859-9; iso-8859-9; iso-8859-9 */
    {&charset_buffer[3776], &charset_buffer[3776], &charset_buffer[3776]},
    /* iso-celtic; iso-8859-14; iso-8859-14 */
    {&charset_buffer[3787], &charset_buffer[3663], &charset_buffer[3663]},
    /* iso-ir-10; sen_850200_b; sen_850200_b */
    {&charset_buffer[3798], &charset_buffer[5536], &charset_buffer[5536]},
    /* iso-ir-100; iso-8859-1; iso-8859-1 */
    {&charset_buffer[3808], &charset_buffer[3628], &charset_buffer[3628]},
    /* iso-ir-101; iso-8859-2; iso-8859-2 */
    {&charset_buffer[3819], &charset_buffer[3699], &charset_buffer[3699]},
    /* iso-ir-103; t.61-8bit; t.61-8bit */
    {&charset_buffer[3830], &charset_buffer[5605], &charset_buffer[5605]},
    /* iso-ir-109; iso-8859-3; iso-8859-3 */
    {&charset_buffer[3841], &charset_buffer[3710], &charset_buffer[3710]},
    /* iso-ir-11; sen_850200_c; sen_850200_c */
    {&charset_buffer[3852], &charset_buffer[5549], &charset_buffer[5549]},
    /* iso-ir-110; iso-8859-4; iso-8859-4 */
    {&charset_buffer[3862], &charset_buffer[3721], &charset_buffer[3721]},
    /* iso-ir-111; ecma-cyrillic; ecma-cyrillic */
    {&charset_buffer[3873], &charset_buffer[2915], &charset_buffer[2915]},
    /* iso-ir-121; csa_z243.4-1985-1; csa_z243.4-1985-1 */
    {&charset_buffer[3884], &charset_buffer[493], &charset_buffer[493]},
    /* iso-ir-122; csa_z243.4-1985-2; csa_z243.4-1985-2 */
    {&charset_buffer[3895], &charset_buffer[511], &charset_buffer[511]},
    /* iso-ir-126; iso-8859-7; iso-8859-7 */
    {&charset_buffer[3906], &charset_buffer[3754], &charset_buffer[3754]},
    /* iso-ir-127; iso-8859-6; iso-8859-6 */
    {&charset_buffer[3917], &charset_buffer[3743], &charset_buffer[3743]},
    /* iso-ir-138; iso-8859-8; iso-8859-8 */
    {&charset_buffer[3928], &charset_buffer[3765], &charset_buffer[3765]},
    /* iso-ir-139; csn_369103; csn_369103 */
    {&charset_buffer[3939], &charset_buffer[2078], &charset_buffer[2078]},
    /* iso-ir-14; jis_c6220-1969-ro; jis_c6220-1969-ro */
    {&charset_buffer[3950], &charset_buffer[5136], &charset_buffer[5136]},
    /* iso-ir-141; jus_i.b1.002; jus_i.b1.002 */
    {&charset_buffer[3960], &charset_buffer[5186], &charset_buffer[5186]},
    /* iso-ir-143; iec_p27-1; iec_p27-1 */
    {&charset_buffer[3971], &charset_buffer[3447], &charset_buffer[3447]},
    /* iso-ir-144; iso-8859-5; iso-8859-5 */
    {&charset_buffer[3982], &charset_buffer[3732], &charset_buffer[3732]},
    /* iso-ir-148; iso-8859-9; iso-8859-9 */
    {&charset_buffer[3993], &charset_buffer[3776], &charset_buffer[3776]},
    /* iso-ir-15; it; it */
    {&charset_buffer[4004], &charset_buffer[5133], &charset_buffer[5133]},
    /* iso-ir-150; greek-ccitt; greek-ccitt */
    {&charset_buffer[4014], &charset_buffer[3064], &charset_buffer[3064]},
    /* iso-ir-151; nc_nc00-10:81; nc_nc00-10:81 */
    {&charset_buffer[4025], &charset_buffer[5419], &charset_buffer[5419]},
    /* iso-ir-153; gost_19768-74; gost_19768-74 */
    {&charset_buffer[4036], &charset_buffer[3044], &charset_buffer[3044]},
    /* iso-ir-155; iso_10367-box; iso_10367-box */
    {&charset_buffer[4047], &charset_buffer[4685], &charset_buffer[4685]},
    /* iso-ir-157; iso-8859-10; iso-8859-10 */
    {&charset_buffer[4058], &charset_buffer[3639], &charset_buffer[3639]},
    /* iso-ir-16; pt; pt */
    {&charset_buffer[4069], &charset_buffer[5491], &charset_buffer[5491]},
    /* iso-ir-17; es; es */
    {&charset_buffer[4079], &charset_buffer[2938], &charset_buffer[2938]},
    /* iso-ir-18; greek7-old; greek7-old */
    {&charset_buffer[4089], &charset_buffer[3083], &charset_buffer[3083]},
    /* iso-ir-19; latin-greek; latin-greek */
    {&charset_buffer[4099], &charset_buffer[5269], &charset_buffer[5269]},
    /* iso-ir-199; iso-8859-14; iso-8859-14 */
    {&charset_buffer[4109], &charset_buffer[3663], &charset_buffer[3663]},
    /* iso-ir-21; din_66003; din_66003 */
    {&charset_buffer[4120], &charset_buffer[2318], &charset_buffer[2318]},
    /* iso-ir-226; iso-8859-16; iso-8859-16 */
    {&charset_buffer[4130], &charset_buffer[3687], &charset_buffer[3687]},
    /* iso-ir-25; nf_z_62-010_(1973); nf_z_62-010_(1973) */
    {&charset_buffer[4141], &charset_buffer[5445], &charset_buffer[5445]},
    /* iso-ir-27; latin-greek-1; latin-greek-1 */
    {&charset_buffer[4151], &charset_buffer[5281], &charset_buffer[5281]},
    /* iso-ir-37; iso_5427; iso_5427 */
    {&charset_buffer[4161], &charset_buffer[4725], &charset_buffer[4725]},
    /* iso-ir-4; bs_4730; bs_4730 */
    {&charset_buffer[4171], &charset_buffer[162], &charset_buffer[162]},
    /* iso-ir-49; inis; inis */
    {&charset_buffer[4180], &charset_buffer[3457], &charset_buffer[3457]},
    /* iso-ir-50; inis-8; inis-8 */
    {&charset_buffer[4190], &charset_buffer[3462], &charset_buffer[3462]},
    /* iso-ir-51; inis-cyrillic; inis-cyrillic */
    {&charset_buffer[4200], &charset_buffer[3469], &charset_buffer[3469]},
    /* iso-ir-54; iso_5427:1981; iso_5427:1981 */
    {&charset_buffer[4210], &charset_buffer[4734], &charset_buffer[4734]},
    /* iso-ir-55; iso_5428:1980; iso_5428:1980 */
    {&charset_buffer[4220], &charset_buffer[4748], &charset_buffer[4748]},
    /* iso-ir-57; gb_1988-80; gb_1988-80 */
    {&charset_buffer[4230], &charset_buffer[3029], &charset_buffer[3029]},
    /* iso-ir-6; us-ascii; us-ascii */
    {&charset_buffer[4240], &charset_buffer[5635], &charset_buffer[5635]},
    /* iso-ir-60; ns_4551-1; ns_4551-1 */
    {&charset_buffer[4249], &charset_buffer[5471], &charset_buffer[5471]},
    /* iso-ir-61; ns_4551-2; ns_4551-2 */
    {&charset_buffer[4259], &charset_buffer[5481], &charset_buffer[5481]},
    /* iso-ir-69; nf_z_62-010; nf_z_62-010 */
    {&charset_buffer[4269], &charset_buffer[5433], &charset_buffer[5433]},
    /* iso-ir-8-1; nats-sefi; nats-sefi */
    {&charset_buffer[4279], &charset_buffer[5409], &charset_buffer[5409]},
    /* iso-ir-84; pt2; pt2 */
    {&charset_buffer[4290], &charset_buffer[5500], &charset_buffer[5500]},
    /* iso-ir-85; es2; es2 */
    {&charset_buffer[4300], &charset_buffer[2941], &charset_buffer[2941]},
    /* iso-ir-86; msz_7795.3; msz_7795.3 */
    {&charset_buffer[4310], &charset_buffer[5381], &charset_buffer[5381]},
    /* iso-ir-88; greek7; greek7 */
    {&charset_buffer[4320], &charset_buffer[3076], &charset_buffer[3076]},
    /* iso-ir-89; asmo_449; asmo_449 */
    {&charset_buffer[4330], &charset_buffer[133], &charset_buffer[133]},
    /* iso-ir-9-1; nats-dano; nats-dano */
    {&charset_buffer[4340], &charset_buffer[5399], &charset_buffer[5399]},
    /* iso-ir-90; iso-ir-90; iso-ir-90 */
    {&charset_buffer[4351], &charset_buffer[4351], &charset_buffer[4351]},
    /* iso-ir-92; jis_c6229-1984-b; jis_c6229-1984-b */
    {&charset_buffer[4361], &charset_buffer[5154], &charset_buffer[5154]},
    /* iso-ir-98; iso_2033-1983; iso_2033-1983 */
    {&charset_buffer[4371], &charset_buffer[4711], &charset_buffer[4711]},
    /* iso-ir-99; ansi_x3.110-1983; ansi_x3.110-1983 */
    {&charset_buffer[4381], &charset_buffer[56], &charset_buffer[56]},
    /* iso-latin-1; iso-8859-1; iso-8859-1 */
    {&charset_buffer[4391], &charset_buffer[3628], &charset_buffer[3628]},
    /* iso5427cyrillic1981; iso_5427:1981; iso_5427:1981 */
    {&charset_buffer[4403], &charset_buffer[4734], &charset_buffer[4734]},
    /* iso646-ca; csa_z243.4-1985-1; csa_z243.4-1985-1 */
    {&charset_buffer[4423], &charset_buffer[493], &charset_buffer[493]},
    /* iso646-ca2; csa_z243.4-1985-2; csa_z243.4-1985-2 */
    {&charset_buffer[4433], &charset_buffer[511], &charset_buffer[511]},
    /* iso646-cn; gb_1988-80; gb_1988-80 */
    {&charset_buffer[4444], &charset_buffer[3029], &charset_buffer[3029]},
    /* iso646-cu; nc_nc00-10:81; nc_nc00-10:81 */
    {&charset_buffer[4454], &charset_buffer[5419], &charset_buffer[5419]},
    /* iso646-de; din_66003; din_66003 */
    {&charset_buffer[4464], &charset_buffer[2318], &charset_buffer[2318]},
    /* iso646-dk; ds_2089; ds_2089 */
    {&charset_buffer[4474], &charset_buffer[2338], &charset_buffer[2338]},
    /* iso646-es; es; es */
    {&charset_buffer[4484], &charset_buffer[2938], &charset_buffer[2938]},
    /* iso646-es2; es2; es2 */
    {&charset_buffer[4494], &charset_buffer[2941], &charset_buffer[2941]},
    /* iso646-fi; sen_850200_b; sen_850200_b */
    {&charset_buffer[4505], &charset_buffer[5536], &charset_buffer[5536]},
    /* iso646-fr; nf_z_62-010; nf_z_62-010 */
    {&charset_buffer[4515], &charset_buffer[5433], &charset_buffer[5433]},
    /* iso646-fr1; nf_z_62-010_(1973); nf_z_62-010_(1973) */
    {&charset_buffer[4525], &charset_buffer[5445], &charset_buffer[5445]},
    /* iso646-gb; bs_4730; bs_4730 */
    {&charset_buffer[4536], &charset_buffer[162], &charset_buffer[162]},
    /* iso646-hu; msz_7795.3; msz_7795.3 */
    {&charset_buffer[4546], &charset_buffer[5381], &charset_buffer[5381]},
    /* iso646-it; it; it */
    {&charset_buffer[4556], &charset_buffer[5133], &charset_buffer[5133]},
    /* iso646-jp; jis_c6220-1969-ro; jis_c6220-1969-ro */
    {&charset_buffer[4566], &charset_buffer[5136], &charset_buffer[5136]},
    /* iso646-jp-ocr-b; jis_c6229-1984-b; jis_c6229-1984-b */
    {&charset_buffer[4576], &charset_buffer[5154], &charset_buffer[5154]},
    /* iso646-kr; ksc5636; ksc5636 */
    {&charset_buffer[4592], &charset_buffer[5220], &charset_buffer[5220]},
    /* iso646-no; ns_4551-1; ns_4551-1 */
    {&charset_buffer[4602], &charset_buffer[5471], &charset_buffer[5471]},
    /* iso646-no2; ns_4551-2; ns_4551-2 */
    {&charset_buffer[4612], &charset_buffer[5481], &charset_buffer[5481]},
    /* iso646-pt; pt; pt */
    {&charset_buffer[4623], &charset_buffer[5491], &charset_buffer[5491]},
    /* iso646-pt2; pt2; pt2 */
    {&charset_buffer[4633], &charset_buffer[5500], &charset_buffer[5500]},
    /* iso646-se; sen_850200_b; sen_850200_b */
    {&charset_buffer[4644], &charset_buffer[5536], &charset_buffer[5536]},
    /* iso646-se2; sen_850200_c; sen_850200_c */
    {&charset_buffer[4654], &charset_buffer[5549], &charset_buffer[5549]},
    /* iso646-us; us-ascii; us-ascii */
    {&charset_buffer[4665], &charset_buffer[5635], &charset_buffer[5635]},
    /* iso646-yu; jus_i.b1.002; jus_i.b1.002 */
    {&charset_buffer[4675], &charset_buffer[5186], &charset_buffer[5186]},
    /* iso_10367-box; iso_10367-box; iso_10367-box */
    {&charset_buffer[4685], &charset_buffer[4685], &charset_buffer[4685]},
    /* iso_11548-1; iso-11548-1; iso_11548-1 */
    {&charset_buffer[4699], &charset_buffer[3550], &charset_buffer[4699]},
    /* iso_2033-1983; iso_2033-1983; iso_2033-1983 */
    {&charset_buffer[4711], &charset_buffer[4711], &charset_buffer[4711]},
    /* iso_5427; iso_5427; iso_5427 */
    {&charset_buffer[4725], &charset_buffer[4725], &charset_buffer[4725]},
    /* iso_5427:1981; iso_5427:1981; iso_5427:1981 */
    {&charset_buffer[4734], &charset_buffer[4734], &charset_buffer[4734]},
    /* iso_5428:1980; iso_5428:1980; iso_5428:1980 */
    {&charset_buffer[4748], &charset_buffer[4748], &charset_buffer[4748]},
    /* iso_646.irv:1991; us-ascii; us-ascii */
    {&charset_buffer[4762], &charset_buffer[5635], &charset_buffer[5635]},
    /* iso_8859-1; iso-8859-1; iso-8859-1 */
    {&charset_buffer[4779], &charset_buffer[3628], &charset_buffer[3628]},
    /* iso_8859-10:1992; iso-8859-10; iso-8859-10 */
    {&charset_buffer[4790], &charset_buffer[3639], &charset_buffer[3639]},
    /* iso_8859-14; iso-8859-14; iso-8859-14 */
    {&charset_buffer[4807], &charset_buffer[3663], &charset_buffer[3663]},
    /* iso_8859-14:1998; iso-8859-14; iso-8859-14 */
    {&charset_buffer[4819], &charset_buffer[3663], &charset_buffer[3663]},
    /* iso_8859-15; iso-8859-15; iso-8859-15 */
    {&charset_buffer[4836], &charset_buffer[3675], &charset_buffer[3675]},
    /* iso_8859-16; iso-8859-16; iso-8859-16 */
    {&charset_buffer[4848], &charset_buffer[3687], &charset_buffer[3687]},
    /* iso_8859-16:2001; iso-8859-16; iso-8859-16 */
    {&charset_buffer[4860], &charset_buffer[3687], &charset_buffer[3687]},
    /* iso_8859-1:1987; iso-8859-1; iso-8859-1 */
    {&charset_buffer[4877], &charset_buffer[3628], &charset_buffer[3628]},
    /* iso_8859-2; iso-8859-2; iso-8859-2 */
    {&charset_buffer[4893], &charset_buffer[3699], &charset_buffer[3699]},
    /* iso_8859-2:1987; iso-8859-2; iso-8859-2 */
    {&charset_buffer[4904], &charset_buffer[3699], &charset_buffer[3699]},
    /* iso_8859-3; iso-8859-3; iso-8859-3 */
    {&charset_buffer[4920], &charset_buffer[3710], &charset_buffer[3710]},
    /* iso_8859-3:1988; iso-8859-3; iso-8859-3 */
    {&charset_buffer[4931], &charset_buffer[3710], &charset_buffer[3710]},
    /* iso_8859-4; iso-8859-4; iso-8859-4 */
    {&charset_buffer[4947], &charset_buffer[3721], &charset_buffer[3721]},
    /* iso_8859-4:1988; iso-8859-4; iso-8859-4 */
    {&charset_buffer[4958], &charset_buffer[3721], &charset_buffer[3721]},
    /* iso_8859-5; iso-8859-5; iso-8859-5 */
    {&charset_buffer[4974], &charset_buffer[3732], &charset_buffer[3732]},
    /* iso_8859-5:1988; iso-8859-5; iso-8859-5 */
    {&charset_buffer[4985], &charset_buffer[3732], &charset_buffer[3732]},
    /* iso_8859-6; iso-8859-6; iso-8859-6 */
    {&charset_buffer[5001], &charset_buffer[3743], &charset_buffer[3743]},
    /* iso_8859-6:1987; iso-8859-6; iso-8859-6 */
    {&charset_buffer[5012], &charset_buffer[3743], &charset_buffer[3743]},
    /* iso_8859-7; iso-8859-7; iso-8859-7 */
    {&charset_buffer[5028], &charset_buffer[3754], &charset_buffer[3754]},
    /* iso_8859-7:1987; iso-8859-7; iso-8859-7 */
    {&charset_buffer[5039], &charset_buffer[3754], &charset_buffer[3754]},
    /* iso_8859-8; iso-8859-8; iso-8859-8 */
    {&charset_buffer[5055], &charset_buffer[3765], &charset_buffer[3765]},
    /* iso_8859-8:1988; iso-8859-8; iso-8859-8 */
    {&charset_buffer[5066], &charset_buffer[3765], &charset_buffer[3765]},
    /* iso_8859-9; iso-8859-9; iso-8859-9 */
    {&charset_buffer[5082], &charset_buffer[3776], &charset_buffer[3776]},
    /* iso_8859-9:1989; iso-8859-9; iso-8859-9 */
    {&charset_buffer[5093], &charset_buffer[3776], &charset_buffer[3776]},
    /* iso_9036; asmo_449; asmo_449 */
    {&charset_buffer[5109], &charset_buffer[133], &charset_buffer[133]},
    /* iso_tr_11548-1; iso-11548-1; iso_11548-1 */
    {&charset_buffer[5118], &charset_buffer[3550], &charset_buffer[4699]},
    /* it; it; it */
    {&charset_buffer[5133], &charset_buffer[5133], &charset_buffer[5133]},
    /* jis_c6220-1969-ro; jis_c6220-1969-ro; jis_c6220-1969-ro */
    {&charset_buffer[5136], &charset_buffer[5136], &charset_buffer[5136]},
    /* jis_c6229-1984-b; jis_c6229-1984-b; jis_c6229-1984-b */
    {&charset_buffer[5154], &charset_buffer[5154], &charset_buffer[5154]},
    /* jp; jis_c6220-1969-ro; jis_c6220-1969-ro */
    {&charset_buffer[5171], &charset_buffer[5136], &charset_buffer[5136]},
    /* jp-ocr-b; jis_c6229-1984-b; jis_c6229-1984-b */
    {&charset_buffer[5174], &charset_buffer[5154], &charset_buffer[5154]},
    /* js; jus_i.b1.002; jus_i.b1.002 */
    {&charset_buffer[5183], &charset_buffer[5186], &charset_buffer[5186]},
    /* jus_i.b1.002; jus_i.b1.002; jus_i.b1.002 */
    {&charset_buffer[5186], &charset_buffer[5186], &charset_buffer[5186]},
    /* koi8-e; ecma-cyrillic; ecma-cyrillic */
    {&charset_buffer[5199], &charset_buffer[2915], &charset_buffer[2915]},
    /* koi8-r; koi8-r; koi8-r */
    {&charset_buffer[5206], &charset_buffer[5206], &charset_buffer[5206]},
    /* koi8-u; koi8-u; koi8-u */
    {&charset_buffer[5213], &charset_buffer[5213], &charset_buffer[5213]},
    /* ksc5636; ksc5636; ksc5636 */
    {&charset_buffer[5220], &charset_buffer[5220], &charset_buffer[5220]},
    /* kz-1048; kz-1048; strk1048-2002 */
    {&charset_buffer[5228], &charset_buffer[5228], &charset_buffer[5586]},
    /* l1; iso-8859-1; iso-8859-1 */
    {&charset_buffer[5236], &charset_buffer[3628], &charset_buffer[3628]},
    /* l10; iso-8859-16; iso-8859-16 */
    {&charset_buffer[5239], &charset_buffer[3687], &charset_buffer[3687]},
    /* l2; iso-8859-2; iso-8859-2 */
    {&charset_buffer[5243], &charset_buffer[3699], &charset_buffer[3699]},
    /* l3; iso-8859-3; iso-8859-3 */
    {&charset_buffer[5246], &charset_buffer[3710], &charset_buffer[3710]},
    /* l4; iso-8859-4; iso-8859-4 */
    {&charset_buffer[5249], &charset_buffer[3721], &charset_buffer[3721]},
    /* l5; iso-8859-9; iso-8859-9 */
    {&charset_buffer[5252], &charset_buffer[3776], &charset_buffer[3776]},
    /* l6; iso-8859-10; iso-8859-10 */
    {&charset_buffer[5255], &charset_buffer[3639], &charset_buffer[3639]},
    /* l8; iso-8859-14; iso-8859-14 */
    {&charset_buffer[5258], &charset_buffer[3663], &charset_buffer[3663]},
    /* latin-9; iso-8859-15; iso-8859-15 */
    {&charset_buffer[5261], &charset_buffer[3675], &charset_buffer[3675]},
    /* latin-greek; latin-greek; latin-greek */
    {&charset_buffer[5269], &charset_buffer[5269], &charset_buffer[5269]},
    /* latin-greek-1; latin-greek-1; latin-greek-1 */
    {&charset_buffer[5281], &charset_buffer[5281], &charset_buffer[5281]},
    /* latin1; iso-8859-1; iso-8859-1 */
    {&charset_buffer[5295], &charset_buffer[3628], &charset_buffer[3628]},
    /* latin10; iso-8859-16; iso-8859-16 */
    {&charset_buffer[5302], &charset_buffer[3687], &charset_buffer[3687]},
    /* latin2; iso-8859-2; iso-8859-2 */
    {&charset_buffer[5310], &charset_buffer[3699], &charset_buffer[3699]},
    /* latin3; iso-8859-3; iso-8859-3 */
    {&charset_buffer[5317], &charset_buffer[3710], &charset_buffer[3710]},
    /* latin4; iso-8859-4; iso-8859-4 */
    {&charset_buffer[5324], &charset_buffer[3721], &charset_buffer[3721]},
    /* latin5; iso-8859-9; iso-8859-9 */
    {&charset_buffer[5331], &charset_buffer[3776], &charset_buffer[3776]},
    /* latin6; iso-8859-10; iso-8859-10 */
    {&charset_buffer[5338], &charset_buffer[3639], &charset_buffer[3639]},
    /* latin8; iso-8859-14; iso-8859-14 */
    {&charset_buffer[5345], &charset_buffer[3663], &charset_buffer[3663]},
    /* mac; macintosh; macintosh */
    {&charset_buffer[5352], &charset_buffer[5356], &charset_buffer[5356]},
    /* macintosh; macintosh; macintosh */
    {&charset_buffer[5356], &charset_buffer[5356], &charset_buffer[5356]},
    /* ms936; gbk; gbk */
    {&charset_buffer[5366], &charset_buffer[3040], &charset_buffer[3040]},
    /* ms_kanji; shift_jis; shift_jis */
    {&charset_buffer[5372], &charset_buffer[5562], &charset_buffer[5562]},
    /* msz_7795.3; msz_7795.3; msz_7795.3 */
    {&charset_buffer[5381], &charset_buffer[5381], &charset_buffer[5381]},
    /* naplps; ansi_x3.110-1983; ansi_x3.110-1983 */
    {&charset_buffer[5392], &charset_buffer[56], &charset_buffer[56]},
    /* nats-dano; nats-dano; nats-dano */
    {&charset_buffer[5399], &charset_buffer[5399], &charset_buffer[5399]},
    /* nats-sefi; nats-sefi; nats-sefi */
    {&charset_buffer[5409], &charset_buffer[5409], &charset_buffer[5409]},
    /* nc_nc00-10:81; nc_nc00-10:81; nc_nc00-10:81 */
    {&charset_buffer[5419], &charset_buffer[5419], &charset_buffer[5419]},
    /* nf_z_62-010; nf_z_62-010; nf_z_62-010 */
    {&charset_buffer[5433], &charset_buffer[5433], &charset_buffer[5433]},
    /* nf_z_62-010_(1973); nf_z_62-010_(1973); nf_z_62-010_(1973) */
    {&charset_buffer[5445], &charset_buffer[5445], &charset_buffer[5445]},
    /* no; ns_4551-1; ns_4551-1 */
    {&charset_buffer[5464], &charset_buffer[5471], &charset_buffer[5471]},
    /* no2; ns_4551-2; ns_4551-2 */
    {&charset_buffer[5467], &charset_buffer[5481], &charset_buffer[5481]},
    /* ns_4551-1; ns_4551-1; ns_4551-1 */
    {&charset_buffer[5471], &charset_buffer[5471], &charset_buffer[5471]},
    /* ns_4551-2; ns_4551-2; ns_4551-2 */
    {&charset_buffer[5481], &charset_buffer[5481], &charset_buffer[5481]},
    /* pt; pt; pt */
    {&charset_buffer[5491], &charset_buffer[5491], &charset_buffer[5491]},
    /* pt154; ptcp154; pt154 */
    {&charset_buffer[5494], &charset_buffer[5504], &charset_buffer[5494]},
    /* pt2; pt2; pt2 */
    {&charset_buffer[5500], &charset_buffer[5500], &charset_buffer[5500]},
    /* ptcp154; ptcp154; pt154 */
    {&charset_buffer[5504], &charset_buffer[5504], &charset_buffer[5494]},
    /* r8; hp-roman8; hp-roman8 */
    {&charset_buffer[5512], &charset_buffer[3108], &charset_buffer[3108]},
    /* rk1048; kz-1048; strk1048-2002 */
    {&charset_buffer[5515], &charset_buffer[5228], &charset_buffer[5586]},
    /* roman8; hp-roman8; hp-roman8 */
    {&charset_buffer[5522], &charset_buffer[3108], &charset_buffer[3108]},
    /* se; sen_850200_b; sen_850200_b */
    {&charset_buffer[5529], &charset_buffer[5536], &charset_buffer[5536]},
    /* se2; sen_850200_c; sen_850200_c */
    {&charset_buffer[5532], &charset_buffer[5549], &charset_buffer[5549]},
    /* sen_850200_b; sen_850200_b; sen_850200_b */
    {&charset_buffer[5536], &charset_buffer[5536], &charset_buffer[5536]},
    /* sen_850200_c; sen_850200_c; sen_850200_c */
    {&charset_buffer[5549], &charset_buffer[5549], &charset_buffer[5549]},
    /* shift_jis; shift_jis; shift_jis */
    {&charset_buffer[5562], &charset_buffer[5562], &charset_buffer[5562]},
    /* st_sev_358-88; gost_19768-74; gost_19768-74 */
    {&charset_buffer[5572], &charset_buffer[3044], &charset_buffer[3044]},
    /* strk1048-2002; kz-1048; strk1048-2002 */
    {&charset_buffer[5586], &charset_buffer[5228], &charset_buffer[5586]},
    /* t.61; t.61-8bit; t.61-8bit */
    {&charset_buffer[5600], &charset_buffer[5605], &charset_buffer[5605]},
    /* t.61-8bit; t.61-8bit; t.61-8bit */
    {&charset_buffer[5605], &charset_buffer[5605], &charset_buffer[5605]},
    /* tis-620; tis-620; tis-620 */
    {&charset_buffer[5615], &charset_buffer[5615], &charset_buffer[5615]},
    /* tscii; tscii; tscii */
    {&charset_buffer[5623], &charset_buffer[5623], &charset_buffer[5623]},
    /* uk; bs_4730; bs_4730 */
    {&charset_buffer[5629], &charset_buffer[162], &charset_buffer[162]},
    /* us; us-ascii; us-ascii */
    {&charset_buffer[5632], &charset_buffer[5635], &charset_buffer[5635]},
    /* us-ascii; us-ascii; us-ascii */
    {&charset_buffer[5635], &charset_buffer[5635], &charset_buffer[5635]},
    /* utf-16; utf-16; utf-16 */
    {&charset_buffer[5644], &charset_buffer[5644], &charset_buffer[5644]},
    /* utf-16be; utf-16be; utf-16be */
    {&charset_buffer[5651], &charset_buffer[5651], &charset_buffer[5651]},
    /* utf-16le; utf-16le; utf-16le */
    {&charset_buffer[5660], &charset_buffer[5660], &charset_buffer[5660]},
    /* utf-32; utf-32; utf-32 */
    {&charset_buffer[5669], &charset_buffer[5669], &charset_buffer[5669]},
    /* utf-32be; utf-32be; utf-32be */
    {&charset_buffer[5676], &charset_buffer[5676], &charset_buffer[5676]},
    /* utf-32le; utf-32le; utf-32le */
    {&charset_buffer[5685], &charset_buffer[5685], &charset_buffer[5685]},
    /* utf-7; utf-7; utf-7 */
    {&charset_buffer[5694], &charset_buffer[5694], &charset_buffer[5694]},
    /* utf-8; utf-8; utf-8 */
    {&charset_buffer[5700], &charset_buffer[5700], &charset_buffer[5700]},
    /* utf16; utf-16; utf-16 */
    {&charset_buffer[5706], &charset_buffer[5644], &charset_buffer[5644]},
    /* utf7; utf-7; utf-7 */
    {&charset_buffer[5712], &charset_buffer[5694], &charset_buffer[5694]},
    /* utf8; utf-8; utf-8 */
    {&charset_buffer[5717], &charset_buffer[5700], &charset_buffer[5700]},
    /* viscii; viscii; viscii */
    {&charset_buffer[5722], &charset_buffer[5722], &charset_buffer[5722]},
    /* windows-1250; windows-1250; windows-1250 */
    {&charset_buffer[5729], &charset_buffer[5729], &charset_buffer[5729]},
    /* windows-1251; windows-1251; windows-1251 */
    {&charset_buffer[5742], &charset_buffer[5742], &charset_buffer[5742]},
    /* windows-1252; windows-1252; windows-1252 */
    {&charset_buffer[5755], &charset_buffer[5755], &charset_buffer[5755]},
    /* windows-1253; windows-1253; windows-1253 */
    {&charset_buffer[5768], &charset_buffer[5768], &charset_buffer[5768]},
    /* windows-1254; windows-1254; windows-1254 */
    {&charset_buffer[5781], &charset_buffer[5781], &charset_buffer[5781]},
    /* windows-1255; windows-1255; windows-1255 */
    {&charset_buffer[5794], &charset_buffer[5794], &charset_buffer[5794]},
    /* windows-1256; windows-1256; windows-1256 */
    {&charset_buffer[5807], &charset_buffer[5807], &charset_buffer[5807]},
    /* windows-1257; windows-1257; windows-1257 */
    {&charset_buffer[5820], &charset_buffer[5820], &charset_buffer[5820]},
    /* windows-1258; windows-1258; windows-1258 */
    {&charset_buffer[5833], &charset_buffer[5833], &charset_buffer[5833]},
    /* windows-31j; windows-31j; windows-31j */
    {&charset_buffer[5846], &charset_buffer[5846], &charset_buffer[5846]},
    /* windows-936; gbk; gbk */
    {&charset_buffer[5858], &charset_buffer[3040], &charset_buffer[3040]},
    /* yu; jus_i.b1.002; jus_i.b1.002 */
    {&charset_buffer[5870], &charset_buffer[5186], &charset_buffer[5186]}
};
