# Description for CVE-2022-43343

N-Prolog v1.91 was discovered to contain a global buffer overflow vulnerability in the function gettoken() at Main.c

# Reproduction

To reproduce the vulnerability, download a vulnerable version of N-Prolog (v1.91) and compile the project:

```
git clone https://github.com/sasagawa888/nprolog.git
cd nprolog
git checkout ae7cc9bf6087cfcb57baadbe59f5005c6dc0f09c
make
```

Once the project has been compiled, we can point N-Prolog towards our proof of concept file included in this repository (CVE-2022-43343_crash):

```
./npl -s CVE-2022-43343_crash
```

The previous command will produce a crash and return an error message:

```
segmentation fault  ./npl -s CVE-2022-43343_crash
```

To gain a better understanding of where the crash is taking place, lets recompile the project with address sanitizer (ASAN) by adding -fsanitize=address to the CFLAGS and LIBS variables in the Makefile. We also want the compiler to store symbol table information in the executable (-g flag) to help us determine which line of code produced the crash:

```
CC   = gcc
LIBS = -lm -ldl -fsanitize=address


LIBSRASPI = -lm -ldl -lwiringPi -fsanitize=address -g
INCS =  
CFLAGS = $(INCS) -Wall -O3 -fsanitize=address
DEST = /usr/local/bin
```

Next we will clean any stale files and recompile the project:

```
make clean
make
```

Execute npl in script mode against the malicious file:

```
./npl -s CVE-2022-43343_crash
```


ASAN reports an invalid write of size 1 to a global variable in the function *gettoken() at parser.c, line 1022*:
```
==291696==ERROR: AddressSanitizer: global-buffer-overflow on address 0x56107f6d54b0 at pc 0x56107f651925 bp 0x7ffc7a408e10 sp 0x7ffc7a408e08
WRITE of size 1 at 0x56107f6d54b0 thread T0
    #0 0x56107f651924 in gettoken /dev/shm/nprolog/parser.c:1022
    #1 0x56107f656924 in parser /dev/shm/nprolog/parser.c:40
    #2 0x56107f6624ca in b_consult /dev/shm/nprolog/builtin.c:1561
    #3 0x56107f642d72 in main /dev/shm/nprolog/main.c:276
    #4 0x7f8c85646189 in __libc_start_call_main ../sysdeps/nptl/libc_start_call_main.h:58
    #5 0x7f8c85646244 in __libc_start_main_impl ../csu/libc-start.c:381
    #6 0x56107f6432c0 in _start (/dev/shm/nprolog/npl+0x162c0)

0x56107f6d54b0 is located 48 bytes to the left of global variable 'record_pt' defined in 'main.c:24:5' (0x56107f6d54e0) of size 4
0x56107f6d54b0 is located 0 bytes to the right of global variable 'stok' defined in 'main.c:27:7' (0x56107f6d53a0) of size 272
SUMMARY: AddressSanitizer: global-buffer-overflow /dev/shm/nprolog/parser.c:1022 in gettoken
Shadow bytes around the buggy address:
  0x0ac28fed2a40: f9 f9 f9 f9 04 f9 f9 f9 f9 f9 f9 f9 04 f9 f9 f9
  0x0ac28fed2a50: f9 f9 f9 f9 04 f9 f9 f9 f9 f9 f9 f9 04 f9 f9 f9
  0x0ac28fed2a60: f9 f9 f9 f9 04 f9 f9 f9 f9 f9 f9 f9 04 f9 f9 f9
  0x0ac28fed2a70: f9 f9 f9 f9 00 00 00 00 00 00 00 00 00 00 00 00
  0x0ac28fed2a80: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
=>0x0ac28fed2a90: 00 00 00 00 00 00[f9]f9 f9 f9 f9 f9 04 f9 f9 f9
  0x0ac28fed2aa0: f9 f9 f9 f9 00 00 00 00 00 00 00 00 00 00 00 00
  0x0ac28fed2ab0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
  0x0ac28fed2ac0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
  0x0ac28fed2ad0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
  0x0ac28fed2ae0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
Shadow byte legend (one shadow byte represents 8 application bytes):
  Addressable:           00
  Partially addressable: 01 02 03 04 05 06 07 
  Heap left redzone:       fa
  Freed heap region:       fd
  Stack left redzone:      f1
  Stack mid redzone:       f2
  Stack right redzone:     f3
  Stack after return:      f5
  Stack use after scope:   f8
  Global redzone:          f9
  Global init order:       f6
  Poisoned by user:        f7
  Container overflow:      fc
  Array cookie:            ac
  Intra object redzone:    bb
  ASan internal:           fe
  Left alloca redzone:     ca
  Right alloca redzone:    cb
  Shadow gap:              cc
==291696==ABORTING
```


# References
* https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2022-43343
* https://learn.microsoft.com/en-us/cpp/sanitizers/error-global-buffer-overflow?view=msvc-170


