# CVE-2022-41678: Dangerous MBeans Accessible via Jolokia API in Apache ActiveMQ

By listing and inspecting the MBeans exposed by the Jolokia API at http://127.0.0.1:8161/api/jolokia the following attack vectors have been identified:
- Arbitrary File Write using Log4J resulting in Remote Code Execution
- Arbitrary File Read using Log4J
- SSRF using Log4J
- Arbitrary File Overwrite using Java Flight Recorder (RCE is also achievable via the JFR as discovered by the threatbook.cn team)

This vulnerability can be exploited by a local attacker that knows the basic authentication credentials (by default “admin:admin”) used by the ActiveMQ web interface.

### Vendor Disclosure:

The vendor's disclosure for this vulnerability can be found [here](https://activemq.apache.org/security-advisories.data/CVE-2022-41678-announcement.txt).

**NOTE**: This vulnerability is not a "deserialization vulnerability".

### Requirements:

This vulnerability requires:
<br/>
- Valid credentials for user with "admin" role

### Proof Of Concept:

More details and the exploitation process can be found in this [PDF](https://github.com/mbadanoiu/CVE-2022-41678/blob/main/Apache%20ActiveMQ%20-%20CVE-2022-41678.pdf).

### Additional Resources:

[YouTube presentation](https://www.youtube.com/watch?v=Hy4ufEfabRA) on how to exploit Log4J MBeans over JMX/Jolokia (a.k.a. Log4JMX)

[Blog post](https://y4tacker.github.io/2023/11/30/year/2023/11/%E6%9F%90%E7%B3%BB%E7%BB%9F%E6%9C%80%E6%96%B0%E5%89%8D%E5%8F%B0RCE%E5%88%86%E6%9E%90/Apache-ActiveMQ-Jolokia%E8%BF%9C%E7%A8%8B%E4%BB%A3%E7%A0%81%E6%89%A7%E8%A1%8C%E4%B8%8D%E4%BE%9D%E8%B5%96JDK%E6%89%93%E6%B3%95/) by [Y4tacker](https://github.com/Y4tacker) explaining how to obtain RCE via the Log4J vector.

[Proof of concept code](https://github.com/vulhub/vulhub/tree/master/activemq/CVE-2022-41678) by [Owen "phith0n" Gong](https://github.com/phith0n) that exploits both the Log4J and JFR vectors.

[Blog post](https://l3yx.github.io/2023/11/29/Apache-ActiveMQ-Jolokia-%E8%BF%9C%E7%A8%8B%E4%BB%A3%E7%A0%81%E6%89%A7%E8%A1%8C%E6%BC%8F%E6%B4%9E-CVE-2022-41678-%E5%88%86%E6%9E%90/) by [淚笑 l3yx](https://github.com/l3yx) explaining how to obtain RCE via the Java Flight Recorder.

### Timeline:
- This vulnerability was initially reported to security@apache.org on 20-Jan-2023
- Confirmation that CVE-2022-41678 was allocated for this vulnerability and retest request for ActiveMQ versions 5.17.3 and 5.18.0 on 25-Aug-2023
- Apache discloses CVE-2022-41678 on 28-Nov-2023
- Performed the retest and confirmed that the latest ActiveMQ is no longer vulnerable on 4-Jan-2024
- Publically disclosed the initial report on 29-Nov-2024
