# CVE-2022-36162

> [Suggested description]
> pdftoroff hovacui 1.1.0 is affected by: Command execution. The impact
> is: execute arbitrary code (local). The component is: hovacui.c, line
> 1574. The attack vector is: To exploit the vulnerability, you just have
> to change HOME environment variable, put some command as postsave, open
> a pdf file and save it.      A vulnerability was found in hovacui, that
> can allow arbitrary command execution. line 1574: 1574 system(command);
> The environment variable HOME is trusted, and the attacker can fake it.
> Then the attacker can enter any command as `postsave` in the config
> file, and all left to do is to open a pdf file and save it. This can
> have Code Execution, Denial of Service or EoP impact on the machine.
>
> ------------------------------------------
>
> [Additional Information]
> hovacui
> The hovacui pdf viewer for the Linux framebuffer and X11 automatically zooms to the blocks of text. It is aimed at viewing files on small screens, and is especially handy for multiple-columns documents.
>
> hovacui is part of pdftoroff, link: https://aur.archlinux.org/packages/pdftoroff
>
> The config file path is found like this
>
> snprintf(configfile, 4096, "%s/.config/hovacui/hovacui.conf",
> 3358\t\t\tgetenv("HOME"));
>
> So we can just fake HOME and make our own config file.
>
> And to get command execution we just save the pdf because at savepdf() function we have:
>
>         else {
>                 cairoui_printlabel(cairoui, output->help, NO_TIMEOUT,
>                         "saved to %s", path);
>                 if (post && output->postsave != NULL) {
>                         command =
>                                 malloc(strlen(output->postsave) + 100);
>                         sprintf(command, output->postsave,
>                                         fileno, fileno);
>                         system(command);
>                         free(command);
>                 }
>                 return CAIROUI_DONE;
>         }
> }
>
> output->postsave will be fully controlled by the attacker:
> if (sscanf(configline, "postsave %900[^\
> \r]", s) == 1)
>                         output.postsave = strdup(s);
> To save just enter d, then follow it with s
> hovacui web poage: http://sgerwk.altervista.org/hovacui/hovacui.html
>
> ------------------------------------------
>
> [VulnerabilityType Other]
> Command execution
>
> ------------------------------------------
>
> [Vendor of Product]
> pdftoroff
>
> ------------------------------------------
>
> [Affected Product Code Base]
> hovacui - 1.1.0
>
> ------------------------------------------
>
> [Affected Component]
> hovacui.c, line 1574
>
> ------------------------------------------
>
> [Attack Type]
> Local
>
> ------------------------------------------
>
> [Impact Code execution]
> true
>
> ------------------------------------------
>
> [Impact Denial of Service]
> true
>
> ------------------------------------------
>
> [Impact Escalation of Privileges]
> true
>
> ------------------------------------------
>
> [Attack Vectors]
> To exploit the vulnerability, you just have to change HOME environment variable, put some command as postsave, open a pdf file and save it.
>
> ------------------------------------------
>
> [Discoverer]
> Maher Azzouzi
>
> ------------------------------------------
>
> [Reference]
> http://hovacui.com
> http://pdftoroff.com
> http://sgerwk.altervista.org/hovacui/hovacui.html
> https://aur.archlinux.org/packages/pdftoroff
