# Description of CVE-2022-34556

PicoC v3.2.2 was discovered to contain a NULL pointer dereference at variable.c. Any project or library that uses Picoc also suffers from this issue. An example of this would be [picoc-js](https://www.npmjs.com/package/picoc-js).

### Setting up our environment

To replicate the null pointer dereference vulnerability in PicoC, we must first download and compile a vulnerable version (v3.2.2) of the PicoC library and interpreter:

```
git clone https://github.com/jpoirier/picoc.git
cd picoc
git checkout a97d94fa3d4d35c6b78b7de69faac7643e34de22
make
```

# Reproduction Steps

Execute the interpreter in script mode against the **poc.c** file included in this repository:

```
$ ./picoc -s poc.c
```

You will receive a segfault and the program will crash. This is a result of a null pointer dereference that is not caught or handled by the library or interpreter.  We can recompile the project with address sanitizer (ASAN) to give us a better idea of where this is taking place.  Let's add *-fsanitize=address* to the CFLAGS variable in the Makefile and recompile the library:

```
CFLAGS=-Wall -g -std=gnu11 -pedantic -DUNIX_HOST -DVER=\"`git show-ref --abbrev=8 --head --hash head`\" -DTAG=\"`git describe --abbrev=0 --tags`\" -fsanitize=address
```

Recompile the library and interpreter (from the root picoc directory):

```
make clean
make
```

When we execute our program, we get the following output from ASAN showing us that the null pointer dereference takes place at line 519 in variable.c:

### ASAN output:
```
AddressSanitizer:DEADLYSIGNAL
=================================================================
==157769==ERROR: AddressSanitizer: SEGV on unknown address 0x000000000018 (pc 0x55b55571240e bp 0x7ffe4f5c39b0 sp 0x7ffe4f5c3980 T0)
==157769==The signal is caused by a READ memory access.
==157769==Hint: address points to the zero page.
    #0 0x55b55571240e in VariableDereferencePointer /dev/shm/picoc/variable.c:519
    #1 0x55b5556fefea in ExpressionStackPushDereference /dev/shm/picoc/expression.c:430
    #2 0x55b555701881 in ExpressionPrefixOperator /dev/shm/picoc/expression.c:687
    #3 0x55b5557053d5 in ExpressionStackCollapse /dev/shm/picoc/expression.c:1257
    #4 0x55b555706e35 in ExpressionParse /dev/shm/picoc/expression.c:1553
    #5 0x55b5556fb6a0 in ParseStatement /dev/shm/picoc/parse.c:646
    #6 0x55b5556fd380 in PicocParse /dev/shm/picoc/parse.c:897
    #7 0x55b555715d0e in PicocPlatformScanFile platform/platform_unix.c:129
    #8 0x55b5556ec213 in main /dev/shm/picoc/picoc.c:62
    #9 0x7f15bd767189 in __libc_start_call_main ../sysdeps/nptl/libc_start_call_main.h:58
    #10 0x7f15bd767244 in __libc_start_main_impl ../csu/libc-start.c:381
    #11 0x55b5556ebd40 in _start (/dev/shm/picoc/picoc+0x16d40)

AddressSanitizer can not provide additional info.
SUMMARY: AddressSanitizer: SEGV /dev/shm/picoc/variable.c:519 in VariableDereferencePointer
==157769==ABORTING

```

### Vulnerable source code:

```
519: *DerefType = PointerValue->Typ->FromType;
```

# References
* https://owasp.org/www-community/vulnerabilities/Null_Dereference
* https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2022-34556
