# __CVE-2022-31902__

* Denial Of Service (DoS) in `Notepad++(x86)` in `8.4.3` and [before](#tested-versions).

# __Description__

*  Vulnerability triggering, via opening a specially crafted text file (`e.g. first.txt`) and then using options `Find All in All Opened Document` or `Find All in Current Opened Document` under Find options.

As an illustrative example below, as of `11/07/2022`, latest version of Notepad++(x86) is 8.4.3 is used.

![Notepad](npp_images/NppVer.png)

# Proof of Concept -

* Open first.txt and Search for any character in Notepad++, and press `Find All in All Opened Document` or `Find All in Current Opened Document` button.

![NotepadCrash](npp_images/02SearchAnyCharacter.png)

#

### Result :

![NotepadCrash](npp_images/02RuntimeCrash.png)

#
##  Visual Studio 2019 Dump Analysis
#
![NotepadCrash](npp_images/02ErrorPoint.png)

Here we can see, the problem is in __ScintallComponent -> ScintillaWin.cxx-> Line number 3699.__
# 
## Root Cause Analysis

* When user uses the find functionality of notepad++ in `first.txt`, it results in application to crash.
* Notepad++ calls a function __finder::add__ in __findReplaceDlg.cpp__ file which calls push_back(foundinfo) function, which internally calls for memory allocation of size __4bf21__ .
* Due to lack of memory, the `new_operator` is unable to allocate the memory and returns __bad_alloc__.

* So we can say that, Searching for a character in `first.txt` using `Find All in All Opened Document` button, leading to Denial of Service.

#
## Tested Versions
The vulnerability is tested to work on following version:
* Notepad++ 8.3.2 32-bit
* Notepad++ 8.3.3 32-bit.
* Notepad++ 8.4.0 32-bit.
* Notepad++ 8.4.1 32-bit.
* Notepad++ 8.4.2 32-bit.
* Notepad++ 8.4.3 32-bit.
#
## Tested Environment
* Windows 11 - 22563.1000 64 bit
* Windows 10 - 10.0.19042.1586 64-bit
* Windows 10 - 10.0.19044.1706 64-bit

## Update
* As of 05-01-2023, this issue still persists in the `Notepad++ versions 8.4.8 (32-bit) and before`.
* As of 01-02-2023, this issue still persists in the `Notepad++ versions 8.4.9 (32-bit) and before`.
