const express = require('express');
const path = require('path');
const app = express();
const PORT = process.env.PORT || 3000;

// Serve static files from the current directory
app.use(express.static(__dirname));

// Route for the simplified survey vulnerability demo
app.get('/survey', (req, res) => {
  res.sendFile(path.join(__dirname, 'simplified-survey.html'));
});

// Route for the simplified survey (alternative path)
app.get('/simplified-survey', (req, res) => {
  res.sendFile(path.join(__dirname, 'simplified-survey.html'));
});

// Start the server
app.listen(PORT, () => {
  console.log(`Access the Simplified Survey Demo at http://localhost:${PORT}/survey`);
  console.log(`Alternative Survey URL: http://localhost:${PORT}/simplified-survey`);
});
