#import <Foundation/Foundation.h>
#include <stdint.h>

#import <AppKit/AppKit.h>
#import <CoreGraphics/CoreGraphics.h>
#import <ImageIO/ImageIO.h>

extern bool CGRenderingStateGetAllowsAcceleration(void *);
extern bool CGRenderingStateSetAllowsAcceleration(void *, bool);
extern void *CGContextGetRenderingState(CGContextRef);

void dummyLogProc() {}

extern void ImageIOSetLoggingProc(void *);

int test_input(const uint8_t *buf, size_t len) {
    ImageIOSetLoggingProc(&dummyLogProc);

    NSData *content = [NSData dataWithBytes:buf length:len];
    NSImage *img = [[NSImage alloc] initWithData:content];
    CGImageRef cgImg = [img CGImageForProposedRect:nil context:nil hints:nil];

    if (cgImg) {
        size_t width = CGImageGetWidth(cgImg);
        size_t height = CGImageGetHeight(cgImg);
        CGColorSpaceRef colorspace = CGColorSpaceCreateDeviceRGB();
        CGContextRef ctx =
            CGBitmapContextCreate(0, width, height, 8, 0, colorspace, 1);
        void *renderingState = CGContextGetRenderingState(ctx);
        CGRenderingStateSetAllowsAcceleration(renderingState, false);
        CGRect rect = CGRectMake(0, 0, width, height);
        CGContextDrawImage(ctx, rect, cgImg);

        CGColorSpaceRelease(colorspace);
        CGContextRelease(ctx);
        CGImageRelease(cgImg);
    }

    [img release];
    [content release];

    return 0;
}

int main(int argc, char **argv) {
    if (argc < 2) {
        printf("Missing testcase arg\n");
        exit(-1);
    }
    NSData *tcase =
        [NSData dataWithContentsOfFile:[NSString stringWithUTF8String:argv[1]]];
    test_input((const uint8_t *)[tcase bytes], tcase.length);
}
