# CVE-2022-26711: Apple ImageIO WebP Integer Overflow

An integer overflow vulnerability in Apple's ImageIO framework when parsing WebP images, leading to an out-of-bounds memory access.

**[Full Writeup](https://0day.gg/blog/cve-2022-26711-imageio-integer-overflow/)** - Detailed root cause analysis with disassembly walkthrough.

## Overview

An integer overflow occurs during the calculation of row bytes when processing malformed WebP images. The overflow results in an undersized buffer allocation, which is subsequently overwritten during image decoding.

Processing a maliciously crafted WebP image may lead to arbitrary code execution in the context of any application using ImageIO (Safari, Preview, Mail, Messages, Quick Look, etc).

| | Affected | Fixed |
|---|----------|-------|
| macOS | Monterey < 12.4 | 12.4 (May 2022) |
| iOS / iPadOS | < 15.5 | 15.5 |
| tvOS | < 15.5 | 15.5 |
| watchOS | < 8.6 | 8.6 |

*Tested on macOS Monterey 12.0.1 and iOS 15.1*

## Usage

Build and run the harness:

```bash
./build_harness_standalone.sh
./harness_standalone intoverflow.webp
```

Or trigger via browser by serving `trigger.html`, or just open the file directly:

```bash
open intoverflow.webp
```

## Expected Crash

```
Process:               harness_standalone [12345]
Exception Type:        EXC_BAD_ACCESS (SIGSEGV)
Exception Codes:       KERN_INVALID_ADDRESS at 0x...

Thread 0 Crashed:
0   libsystem_platform.dylib        _platform_memset_pattern16 + ...
1   CoreGraphics                    CGSColorDataMakeCompositor + ...
2   CoreGraphics                    ripc_RenderImage + ...
3   CoreGraphics                    ripc_DrawImage + ...
4   ImageIO                         ...
```

## References

- [Apple Security Advisory](https://support.apple.com/en-us/HT213257)
- [ZDI-22-792](https://www.zerodayinitiative.com/advisories/ZDI-22-792/)
- [NVD](https://nvd.nist.gov/vuln/detail/CVE-2022-26711)
