#include "fakefuse.h"

int spray1_pipes[2];

int fuse_read(const char *path, char *buf, size_t size, off_t offset, struct fuse_file_info *fi) {
  if(strcmp(path + 1, spray1_path) == 0) {
    char signal;
    read(spray1_pipes[0], &signal, 1);
  } else if (strcmp(path + 1, spray2_path) == 0) {
    sleep(100000);
  }
  return size;
}

int fuse_getattr(const char *path, struct stat *stbuf) {
    int res = 0;

    memset(stbuf, 0, sizeof(struct stat));

    if (strcmp(path, "/") == 0) {
        stbuf->st_mode = S_IFDIR | 0755;
        stbuf->st_nlink = 2;
    } else if (strcmp(path + 1, spray1_path) == 0 || strcmp(path + 1, spray2_path) == 0 ) {
        stbuf->st_mode = S_IFREG | 0444;
        stbuf->st_nlink = 1;
        stbuf->st_size = 0x1000;
    } else {
        res = -ENOENT;
    }

    return res;
}

int fuse_readdir(const char *path, void *buf, fuse_fill_dir_t filler, off_t offset,  struct fuse_file_info *fi) {
    if (strcmp(path, "/") != 0)
        return -ENOENT;

    filler(buf, ".", NULL, 0);
    filler(buf, "..", NULL, 0);
    filler(buf, spray1_path, NULL, 0);
    filler(buf, spray2_path, NULL, 0);

    return 0;
}
